% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitosync_operations.R
\name{cognitosync_set_cognito_events}
\alias{cognitosync_set_cognito_events}
\title{Sets the AWS Lambda function for a given event type for an identity pool}
\usage{
cognitosync_set_cognito_events(IdentityPoolId, Events)
}
\arguments{
\item{IdentityPoolId}{[required] The Cognito Identity Pool to use when configuring Cognito Events}

\item{Events}{[required] The events to configure}
}
\value{
An empty list.
}
\description{
Sets the AWS Lambda function for a given event type for an identity
pool. This request only updates the key/value pair specified. Other
key/values pairs are not updated. To remove a key value pair, pass a
empty value for the particular key.

This API can only be called with developer credentials. You cannot call
this API with the temporary user credentials provided by Cognito
Identity.
}
\section{Request syntax}{
\preformatted{svc$set_cognito_events(
  IdentityPoolId = "string",
  Events = list(
    "string"
  )
)
}
}

\keyword{internal}
