% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitosync_operations.R
\name{cognitosync_list_identity_pool_usage}
\alias{cognitosync_list_identity_pool_usage}
\title{Gets a list of identity pools registered with Cognito}
\usage{
cognitosync_list_identity_pool_usage(NextToken, MaxResults)
}
\arguments{
\item{NextToken}{A pagination token for obtaining the next page of results.}

\item{MaxResults}{The maximum number of results to be returned.}
}
\value{
A list with the following syntax:\preformatted{list(
  IdentityPoolUsages = list(
    list(
      IdentityPoolId = "string",
      SyncSessionsCount = 123,
      DataStorage = 123,
      LastModifiedDate = as.POSIXct(
        "2015-01-01"
      )
    )
  ),
  MaxResults = 123,
  Count = 123,
  NextToken = "string"
)
}
}
\description{
Gets a list of identity pools registered with Cognito.

ListIdentityPoolUsage can only be called with developer credentials. You
cannot make this API call with the temporary user credentials provided
by Cognito Identity.
}
\section{Request syntax}{
\preformatted{svc$list_identity_pool_usage(
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
