% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/iam_operations.R
\name{iam_create_saml_provider}
\alias{iam_create_saml_provider}
\title{Creates an IAM resource that describes an identity provider (IdP) that
supports SAML 2}
\usage{
iam_create_saml_provider(SAMLMetadataDocument, Name)
}
\arguments{
\item{SAMLMetadataDocument}{[required] An XML document generated by an identity provider (IdP) that supports
SAML 2.0. The document includes the issuer's name, expiration
information, and keys that can be used to validate the SAML
authentication response (assertions) that are received from the IdP. You
must generate the metadata document using the identity management
software that is used as your organization's IdP.

For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html}{About SAML 2.0-based Federation}
in the \emph{IAM User Guide}}

\item{Name}{[required] The name of the provider to create.

This parameter allows (through its \href{https://en.wikipedia.org/wiki/Regex}{regex pattern}) a string of characters
consisting of upper and lowercase alphanumeric characters with no
spaces. You can also include any of the following characters: \\_+=,.@-}
}
\description{
Creates an IAM resource that describes an identity provider (IdP) that
supports SAML 2.0.

The SAML provider resource that you create with this operation can be
used as a principal in an IAM role's trust policy. Such a policy can
enable federated users who sign in using the SAML IdP to assume the
role. You can create an IAM role that supports Web-based single sign-on
(SSO) to the AWS Management Console or one that supports API access to
AWS.

When you create the SAML provider resource, you upload a SAML metadata
document that you get from your IdP. That document includes the issuer's
name, expiration information, and keys that can be used to validate the
SAML authentication response (assertions) that the IdP sends. You must
generate the metadata document using the identity management software
that is used as your organization's IdP.

This operation requires \href{https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html}{Signature Version 4}.

For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_enable-console-saml.html}{Enabling SAML 2.0 Federated Users to Access the AWS Management Console}
and \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/id_roles_providers_saml.html}{About SAML 2.0-based Federation}
in the \emph{IAM User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_saml_provider(
  SAMLMetadataDocument = "string",
  Name = "string"
)
}
}

\keyword{internal}
