% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_update_rate_based_rule}
\alias{wafregional_update_rate_based_rule}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_update_rate_based_rule(RuleId, ChangeToken, Updates,
  RateLimit)
}
\arguments{
\item{RuleId}{[required] The \code{RuleId} of the \code{RateBasedRule} that you want to update. \code{RuleId} is
returned by \code{CreateRateBasedRule} and by ListRateBasedRules.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}

\item{Updates}{[required] An array of \code{RuleUpdate} objects that you want to insert into or delete
from a RateBasedRule.}

\item{RateLimit}{[required] The maximum number of requests, which have an identical value in the
field specified by the \code{RateKey}, allowed in a five-minute period. If
the number of requests exceeds the \code{RateLimit} and the other predicates
specified in the rule are also met, AWS WAF triggers the action that is
specified for this rule.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see
\href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic}
in the developer guide.

\strong{For the latest version of AWS WAF}, use the AWS WAFV2 API and see the
\href{https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html}{AWS WAF Developer Guide}.
With the latest version, AWS WAF has a single set of endpoints for
regional and global use.

Inserts or deletes Predicate objects in a rule and updates the
\code{RateLimit} in the rule.

Each \code{Predicate} object identifies a predicate, such as a ByteMatchSet
or an IPSet, that specifies the web requests that you want to block or
count. The \code{RateLimit} specifies the number of requests every five
minutes that triggers the rule.

If you add more than one predicate to a \code{RateBasedRule}, a request must
match all the predicates and exceed the \code{RateLimit} to be counted or
blocked. For example, suppose you add the following to a
\code{RateBasedRule}:
\itemize{
\item An \code{IPSet} that matches the IP address \verb{192.0.2.44/32}
\item A \code{ByteMatchSet} that matches \code{BadBot} in the \code{User-Agent} header
}

Further, you specify a \code{RateLimit} of 1,000.

You then add the \code{RateBasedRule} to a \code{WebACL} and specify that you want
to block requests that satisfy the rule. For a request to be blocked, it
must come from the IP address 192.0.2.44 \emph{and} the \code{User-Agent} header
in the request must contain the value \code{BadBot}. Further, requests that
match these two conditions much be received at a rate of more than 1,000
every five minutes. If the rate drops below this limit, AWS WAF no
longer blocks the requests.

As a second example, suppose you want to limit requests to a particular
page on your site. To do this, you could add the following to a
\code{RateBasedRule}:
\itemize{
\item A \code{ByteMatchSet} with \code{FieldToMatch} of \code{URI}
\item A \code{PositionalConstraint} of \code{STARTS_WITH}
\item A \code{TargetString} of \code{login}
}

Further, you specify a \code{RateLimit} of 1,000.

By adding this \code{RateBasedRule} to a \code{WebACL}, you could limit requests
to your login page without affecting the rest of your site.
}
\section{Request syntax}{
\preformatted{svc$update_rate_based_rule(
  RuleId = "string",
  ChangeToken = "string",
  Updates = list(
    list(
      Action = "INSERT"|"DELETE",
      Predicate = list(
        Negated = TRUE|FALSE,
        Type = "IPMatch"|"ByteMatch"|"SqlInjectionMatch"|"GeoMatch"|"SizeConstraint"|"XssMatch"|"RegexMatch",
        DataId = "string"
      )
    )
  ),
  RateLimit = 123
)
}
}

\keyword{internal}
