% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kms_operations.R
\name{kms_put_key_policy}
\alias{kms_put_key_policy}
\title{Attaches a key policy to the specified customer master key (CMK)}
\usage{
kms_put_key_policy(KeyId, PolicyName, Policy,
  BypassPolicyLockoutSafetyCheck)
}
\arguments{
\item{KeyId}{[required] A unique identifier for the customer master key (CMK).

Specify the key ID or the Amazon Resource Name (ARN) of the CMK.

For example:
\itemize{
\item Key ID: \verb{1234abcd-12ab-34cd-56ef-1234567890ab}
\item Key ARN:
\verb{arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab}
}

To get the key ID and key ARN for a CMK, use ListKeys or DescribeKey.}

\item{PolicyName}{[required] The name of the key policy. The only valid value is \code{default}.}

\item{Policy}{[required] The key policy to attach to the CMK.

The key policy must meet the following criteria:
\itemize{
\item If you don't set \code{BypassPolicyLockoutSafetyCheck} to true, the key
policy must allow the principal that is making the \code{PutKeyPolicy}
request to make a subsequent \code{PutKeyPolicy} request on the CMK. This
reduces the risk that the CMK becomes unmanageable. For more
information, refer to the scenario in the \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam}{Default Key Policy}
section of the \emph{AWS Key Management Service Developer Guide}.
\item Each statement in the key policy must contain one or more
principals. The principals in the key policy must exist and be
visible to AWS KMS. When you create a new AWS principal (for
example, an IAM user or role), you might need to enforce a delay
before including the new principal in a key policy because the new
principal might not be immediately visible to AWS KMS. For more
information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/troubleshoot_general.html#troubleshoot_general_eventual-consistency}{Changes that I make are not always immediately visible}
in the \emph{AWS Identity and Access Management User Guide}.
}

The key policy cannot exceed 32 kilobytes (32768 bytes). For more
information, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/resource-limits.html}{Resource Quotas}
in the \emph{AWS Key Management Service Developer Guide}.}

\item{BypassPolicyLockoutSafetyCheck}{A flag to indicate whether to bypass the key policy lockout safety
check.

Setting this value to true increases the risk that the CMK becomes
unmanageable. Do not set this value to true indiscriminately.

For more information, refer to the scenario in the \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html#key-policy-default-allow-root-enable-iam}{Default Key Policy}
section in the \emph{AWS Key Management Service Developer Guide}.

Use this parameter only when you intend to prevent the principal that is
making the request from making a subsequent \code{PutKeyPolicy} request on
the CMK.

The default value is false.}
}
\description{
Attaches a key policy to the specified customer master key (CMK).

For more information about key policies, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/key-policies.html}{Key Policies}
in the \emph{AWS Key Management Service Developer Guide}. For help writing
and formatting a JSON policy document, see the \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference_policies.html}{IAM JSON Policy Reference}
in the \strong{IAM User Guide} . For examples of adding a key policy in
multiple programming languages, see \href{https://docs.aws.amazon.com/kms/latest/developerguide/programming-key-policies.html#put-policy}{Setting a key policy}
in the \emph{AWS Key Management Service Developer Guide}.

\strong{Cross-account use}: No. You cannot perform this operation on a CMK in
a different AWS account.

\strong{Required permissions}:
\href{https://docs.aws.amazon.com/kms/latest/developerguide/kms-api-permissions-reference.html}{kms:PutKeyPolicy}
(key policy)

\strong{Related operations}: GetKeyPolicy
}
\section{Request syntax}{
\preformatted{svc$put_key_policy(
  KeyId = "string",
  PolicyName = "string",
  Policy = "string",
  BypassPolicyLockoutSafetyCheck = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# The following example attaches a key policy to the specified CMK.
svc$put_key_policy(
  KeyId = "1234abcd-12ab-34cd-56ef-1234567890ab",
  Policy = "\{\n    \"Version\": \"2012-10-17\",\n    \"Id\": \"custom-policy-2016-12-07\",\n...",
  PolicyName = "default"
)
}

}
\keyword{internal}
