# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include inspector_service.R
NULL

#' Assigns attributes (key and value pairs) to the findings that are
#' specified by the ARNs of the findings
#'
#' @description
#' Assigns attributes (key and value pairs) to the findings that are
#' specified by the ARNs of the findings.
#'
#' @usage
#' inspector_add_attributes_to_findings(findingArns, attributes)
#'
#' @param findingArns &#91;required&#93; The ARNs that specify the findings that you want to assign attributes
#' to.
#' @param attributes &#91;required&#93; The array of attributes that you want to assign to specified findings.
#'
#' @section Request syntax:
#' ```
#' svc$add_attributes_to_findings(
#'   findingArns = list(
#'     "string"
#'   ),
#'   attributes = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Assigns attributes (key and value pairs) to the findings that are
#' # specified by the ARNs of the findings.
#' svc$add_attributes_to_findings(
#'   attributes = list(
#'     list(
#'       key = "Example",
#'       value = "example"
#'     )
#'   ),
#'   findingArns = list(
#'     "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-8l1VIE0D/run/0-Z0..."
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_add_attributes_to_findings
inspector_add_attributes_to_findings <- function(findingArns, attributes) {
  op <- new_operation(
    name = "AddAttributesToFindings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$add_attributes_to_findings_input(findingArns = findingArns, attributes = attributes)
  output <- .inspector$add_attributes_to_findings_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$add_attributes_to_findings <- inspector_add_attributes_to_findings

#' Creates a new assessment target using the ARN of the resource group that
#' is generated by CreateResourceGroup
#'
#' @description
#' Creates a new assessment target using the ARN of the resource group that
#' is generated by CreateResourceGroup. If resourceGroupArn is not
#' specified, all EC2 instances in the current AWS account and region are
#' included in the assessment target. If the [service-linked
#' role](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html)
#' isn’t already registered, this action also creates and registers a
#' service-linked role to grant Amazon Inspector access to AWS Services
#' needed to perform security assessments. You can create up to 50
#' assessment targets per AWS account. You can run up to 500 concurrent
#' agents per AWS account. For more information, see [Amazon Inspector
#' Assessment
#' Targets](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
#'
#' @usage
#' inspector_create_assessment_target(assessmentTargetName,
#'   resourceGroupArn)
#'
#' @param assessmentTargetName &#91;required&#93; The user-defined name that identifies the assessment target that you
#' want to create. The name must be unique within the AWS account.
#' @param resourceGroupArn The ARN that specifies the resource group that is used to create the
#' assessment target. If resourceGroupArn is not specified, all EC2
#' instances in the current AWS account and region are included in the
#' assessment target.
#'
#' @section Request syntax:
#' ```
#' svc$create_assessment_target(
#'   assessmentTargetName = "string",
#'   resourceGroupArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Creates a new assessment target using the ARN of the resource group that
#' # is generated by CreateResourceGroup. You can create up to 50 assessment
#' # targets per AWS account. You can run up to 500 concurrent agents per AWS
#' # account.
#' svc$create_assessment_target(
#'   assessmentTargetName = "ExampleAssessmentTarget",
#'   resourceGroupArn = "arn:aws:inspector:us-west-2:123456789012:resourcegroup/0-AB6DMKnv"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_create_assessment_target
inspector_create_assessment_target <- function(assessmentTargetName, resourceGroupArn = NULL) {
  op <- new_operation(
    name = "CreateAssessmentTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$create_assessment_target_input(assessmentTargetName = assessmentTargetName, resourceGroupArn = resourceGroupArn)
  output <- .inspector$create_assessment_target_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$create_assessment_target <- inspector_create_assessment_target

#' Creates an assessment template for the assessment target that is
#' specified by the ARN of the assessment target
#'
#' @description
#' Creates an assessment template for the assessment target that is
#' specified by the ARN of the assessment target. If the [service-linked
#' role](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_slr.html)
#' isn’t already registered, this action also creates and registers a
#' service-linked role to grant Amazon Inspector access to AWS Services
#' needed to perform security assessments.
#'
#' @usage
#' inspector_create_assessment_template(assessmentTargetArn,
#'   assessmentTemplateName, durationInSeconds, rulesPackageArns,
#'   userAttributesForFindings)
#'
#' @param assessmentTargetArn &#91;required&#93; The ARN that specifies the assessment target for which you want to
#' create the assessment template.
#' @param assessmentTemplateName &#91;required&#93; The user-defined name that identifies the assessment template that you
#' want to create. You can create several assessment templates for an
#' assessment target. The names of the assessment templates that correspond
#' to a particular assessment target must be unique.
#' @param durationInSeconds &#91;required&#93; The duration of the assessment run in seconds.
#' @param rulesPackageArns &#91;required&#93; The ARNs that specify the rules packages that you want to attach to the
#' assessment template.
#' @param userAttributesForFindings The user-defined attributes that are assigned to every finding that is
#' generated by the assessment run that uses this assessment template. An
#' attribute is a key and value pair (an Attribute object). Within an
#' assessment template, each key must be unique.
#'
#' @section Request syntax:
#' ```
#' svc$create_assessment_template(
#'   assessmentTargetArn = "string",
#'   assessmentTemplateName = "string",
#'   durationInSeconds = 123,
#'   rulesPackageArns = list(
#'     "string"
#'   ),
#'   userAttributesForFindings = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Creates an assessment template for the assessment target that is
#' # specified by the ARN of the assessment target.
#' svc$create_assessment_template(
#'   assessmentTargetArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX",
#'   assessmentTemplateName = "ExampleAssessmentTemplate",
#'   durationInSeconds = 180L,
#'   rulesPackageArns = list(
#'     "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-11B9DBXp"
#'   ),
#'   userAttributesForFindings = list(
#'     list(
#'       key = "Example",
#'       value = "example"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_create_assessment_template
inspector_create_assessment_template <- function(assessmentTargetArn, assessmentTemplateName, durationInSeconds, rulesPackageArns, userAttributesForFindings = NULL) {
  op <- new_operation(
    name = "CreateAssessmentTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$create_assessment_template_input(assessmentTargetArn = assessmentTargetArn, assessmentTemplateName = assessmentTemplateName, durationInSeconds = durationInSeconds, rulesPackageArns = rulesPackageArns, userAttributesForFindings = userAttributesForFindings)
  output <- .inspector$create_assessment_template_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$create_assessment_template <- inspector_create_assessment_template

#' Starts the generation of an exclusions preview for the specified
#' assessment template
#'
#' @description
#' Starts the generation of an exclusions preview for the specified
#' assessment template. The exclusions preview lists the potential
#' exclusions (ExclusionPreview) that Inspector can detect before it runs
#' the assessment.
#'
#' @usage
#' inspector_create_exclusions_preview(assessmentTemplateArn)
#'
#' @param assessmentTemplateArn &#91;required&#93; The ARN that specifies the assessment template for which you want to
#' create an exclusions preview.
#'
#' @section Request syntax:
#' ```
#' svc$create_exclusions_preview(
#'   assessmentTemplateArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname inspector_create_exclusions_preview
inspector_create_exclusions_preview <- function(assessmentTemplateArn) {
  op <- new_operation(
    name = "CreateExclusionsPreview",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$create_exclusions_preview_input(assessmentTemplateArn = assessmentTemplateArn)
  output <- .inspector$create_exclusions_preview_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$create_exclusions_preview <- inspector_create_exclusions_preview

#' Creates a resource group using the specified set of tags (key and value
#' pairs) that are used to select the EC2 instances to be included in an
#' Amazon Inspector assessment target
#'
#' @description
#' Creates a resource group using the specified set of tags (key and value
#' pairs) that are used to select the EC2 instances to be included in an
#' Amazon Inspector assessment target. The created resource group is then
#' used to create an Amazon Inspector assessment target. For more
#' information, see CreateAssessmentTarget.
#'
#' @usage
#' inspector_create_resource_group(resourceGroupTags)
#'
#' @param resourceGroupTags &#91;required&#93; A collection of keys and an array of possible values,
#' '\[\{"key":"key1","values":\["Value1","Value2"\]\},\{"key":"Key2","values":\["Value3"\]\}\]'.
#' 
#' For example,'\[\{"key":"Name","values":\["TestEC2Instance"\]\}\]'.
#'
#' @section Request syntax:
#' ```
#' svc$create_resource_group(
#'   resourceGroupTags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Creates a resource group using the specified set of tags (key and value
#' # pairs) that are used to select the EC2 instances to be included in an
#' # Amazon Inspector assessment target. The created resource group is then
#' # used to create an Amazon Inspector assessment target.
#' svc$create_resource_group(
#'   resourceGroupTags = list(
#'     list(
#'       key = "Name",
#'       value = "example"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_create_resource_group
inspector_create_resource_group <- function(resourceGroupTags) {
  op <- new_operation(
    name = "CreateResourceGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$create_resource_group_input(resourceGroupTags = resourceGroupTags)
  output <- .inspector$create_resource_group_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$create_resource_group <- inspector_create_resource_group

#' Deletes the assessment run that is specified by the ARN of the
#' assessment run
#'
#' @description
#' Deletes the assessment run that is specified by the ARN of the
#' assessment run.
#'
#' @usage
#' inspector_delete_assessment_run(assessmentRunArn)
#'
#' @param assessmentRunArn &#91;required&#93; The ARN that specifies the assessment run that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_assessment_run(
#'   assessmentRunArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Deletes the assessment run that is specified by the ARN of the
#' # assessment run.
#' svc$delete_assessment_run(
#'   assessmentRunArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX/template/0-..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_delete_assessment_run
inspector_delete_assessment_run <- function(assessmentRunArn) {
  op <- new_operation(
    name = "DeleteAssessmentRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$delete_assessment_run_input(assessmentRunArn = assessmentRunArn)
  output <- .inspector$delete_assessment_run_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$delete_assessment_run <- inspector_delete_assessment_run

#' Deletes the assessment target that is specified by the ARN of the
#' assessment target
#'
#' @description
#' Deletes the assessment target that is specified by the ARN of the
#' assessment target.
#'
#' @usage
#' inspector_delete_assessment_target(assessmentTargetArn)
#'
#' @param assessmentTargetArn &#91;required&#93; The ARN that specifies the assessment target that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_assessment_target(
#'   assessmentTargetArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Deletes the assessment target that is specified by the ARN of the
#' # assessment target.
#' svc$delete_assessment_target(
#'   assessmentTargetArn = "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_delete_assessment_target
inspector_delete_assessment_target <- function(assessmentTargetArn) {
  op <- new_operation(
    name = "DeleteAssessmentTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$delete_assessment_target_input(assessmentTargetArn = assessmentTargetArn)
  output <- .inspector$delete_assessment_target_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$delete_assessment_target <- inspector_delete_assessment_target

#' Deletes the assessment template that is specified by the ARN of the
#' assessment template
#'
#' @description
#' Deletes the assessment template that is specified by the ARN of the
#' assessment template.
#'
#' @usage
#' inspector_delete_assessment_template(assessmentTemplateArn)
#'
#' @param assessmentTemplateArn &#91;required&#93; The ARN that specifies the assessment template that you want to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_assessment_template(
#'   assessmentTemplateArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Deletes the assessment template that is specified by the ARN of the
#' # assessment template.
#' svc$delete_assessment_template(
#'   assessmentTemplateArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX/templa..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_delete_assessment_template
inspector_delete_assessment_template <- function(assessmentTemplateArn) {
  op <- new_operation(
    name = "DeleteAssessmentTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$delete_assessment_template_input(assessmentTemplateArn = assessmentTemplateArn)
  output <- .inspector$delete_assessment_template_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$delete_assessment_template <- inspector_delete_assessment_template

#' Describes the assessment runs that are specified by the ARNs of the
#' assessment runs
#'
#' @description
#' Describes the assessment runs that are specified by the ARNs of the
#' assessment runs.
#'
#' @usage
#' inspector_describe_assessment_runs(assessmentRunArns)
#'
#' @param assessmentRunArns &#91;required&#93; The ARN that specifies the assessment run that you want to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_assessment_runs(
#'   assessmentRunArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Describes the assessment runs that are specified by the ARNs of the
#' # assessment runs.
#' svc$describe_assessment_runs(
#'   assessmentRunArns = list(
#'     "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-4r1V2mAw/run/0-MK..."
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_describe_assessment_runs
inspector_describe_assessment_runs <- function(assessmentRunArns) {
  op <- new_operation(
    name = "DescribeAssessmentRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_assessment_runs_input(assessmentRunArns = assessmentRunArns)
  output <- .inspector$describe_assessment_runs_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_assessment_runs <- inspector_describe_assessment_runs

#' Describes the assessment targets that are specified by the ARNs of the
#' assessment targets
#'
#' @description
#' Describes the assessment targets that are specified by the ARNs of the
#' assessment targets.
#'
#' @usage
#' inspector_describe_assessment_targets(assessmentTargetArns)
#'
#' @param assessmentTargetArns &#91;required&#93; The ARNs that specifies the assessment targets that you want to
#' describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_assessment_targets(
#'   assessmentTargetArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Describes the assessment targets that are specified by the ARNs of the
#' # assessment targets.
#' svc$describe_assessment_targets(
#'   assessmentTargetArns = list(
#'     "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_describe_assessment_targets
inspector_describe_assessment_targets <- function(assessmentTargetArns) {
  op <- new_operation(
    name = "DescribeAssessmentTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_assessment_targets_input(assessmentTargetArns = assessmentTargetArns)
  output <- .inspector$describe_assessment_targets_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_assessment_targets <- inspector_describe_assessment_targets

#' Describes the assessment templates that are specified by the ARNs of the
#' assessment templates
#'
#' @description
#' Describes the assessment templates that are specified by the ARNs of the
#' assessment templates.
#'
#' @usage
#' inspector_describe_assessment_templates(assessmentTemplateArns)
#'
#' @param assessmentTemplateArns &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$describe_assessment_templates(
#'   assessmentTemplateArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Describes the assessment templates that are specified by the ARNs of the
#' # assessment templates.
#' svc$describe_assessment_templates(
#'   assessmentTemplateArns = list(
#'     "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-4r1V2mAw"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_describe_assessment_templates
inspector_describe_assessment_templates <- function(assessmentTemplateArns) {
  op <- new_operation(
    name = "DescribeAssessmentTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_assessment_templates_input(assessmentTemplateArns = assessmentTemplateArns)
  output <- .inspector$describe_assessment_templates_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_assessment_templates <- inspector_describe_assessment_templates

#' Describes the IAM role that enables Amazon Inspector to access your AWS
#' account
#'
#' @description
#' Describes the IAM role that enables Amazon Inspector to access your AWS
#' account.
#'
#' @usage
#' inspector_describe_cross_account_access_role()
#'

#'

#'
#' @examples
#' \dontrun{
#' # Describes the IAM role that enables Amazon Inspector to access your AWS
#' # account.
#' svc$describe_cross_account_access_role()
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_describe_cross_account_access_role
inspector_describe_cross_account_access_role <- function() {
  op <- new_operation(
    name = "DescribeCrossAccountAccessRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_cross_account_access_role_input()
  output <- .inspector$describe_cross_account_access_role_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_cross_account_access_role <- inspector_describe_cross_account_access_role

#' Describes the exclusions that are specified by the exclusions' ARNs
#'
#' @description
#' Describes the exclusions that are specified by the exclusions' ARNs.
#'
#' @usage
#' inspector_describe_exclusions(exclusionArns, locale)
#'
#' @param exclusionArns &#91;required&#93; The list of ARNs that specify the exclusions that you want to describe.
#' @param locale The locale into which you want to translate the exclusion's title,
#' description, and recommendation.
#'
#' @section Request syntax:
#' ```
#' svc$describe_exclusions(
#'   exclusionArns = list(
#'     "string"
#'   ),
#'   locale = "EN_US"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname inspector_describe_exclusions
inspector_describe_exclusions <- function(exclusionArns, locale = NULL) {
  op <- new_operation(
    name = "DescribeExclusions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_exclusions_input(exclusionArns = exclusionArns, locale = locale)
  output <- .inspector$describe_exclusions_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_exclusions <- inspector_describe_exclusions

#' Describes the findings that are specified by the ARNs of the findings
#'
#' @description
#' Describes the findings that are specified by the ARNs of the findings.
#'
#' @usage
#' inspector_describe_findings(findingArns, locale)
#'
#' @param findingArns &#91;required&#93; The ARN that specifies the finding that you want to describe.
#' @param locale The locale into which you want to translate a finding description,
#' recommendation, and the short description that identifies the finding.
#'
#' @section Request syntax:
#' ```
#' svc$describe_findings(
#'   findingArns = list(
#'     "string"
#'   ),
#'   locale = "EN_US"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Describes the findings that are specified by the ARNs of the findings.
#' svc$describe_findings(
#'   findingArns = list(
#'     "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-4r1V2mAw/run/0-MK..."
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_describe_findings
inspector_describe_findings <- function(findingArns, locale = NULL) {
  op <- new_operation(
    name = "DescribeFindings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_findings_input(findingArns = findingArns, locale = locale)
  output <- .inspector$describe_findings_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_findings <- inspector_describe_findings

#' Describes the resource groups that are specified by the ARNs of the
#' resource groups
#'
#' @description
#' Describes the resource groups that are specified by the ARNs of the
#' resource groups.
#'
#' @usage
#' inspector_describe_resource_groups(resourceGroupArns)
#'
#' @param resourceGroupArns &#91;required&#93; The ARN that specifies the resource group that you want to describe.
#'
#' @section Request syntax:
#' ```
#' svc$describe_resource_groups(
#'   resourceGroupArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Describes the resource groups that are specified by the ARNs of the
#' # resource groups.
#' svc$describe_resource_groups(
#'   resourceGroupArns = list(
#'     "arn:aws:inspector:us-west-2:123456789012:resourcegroup/0-PyGXopAI"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_describe_resource_groups
inspector_describe_resource_groups <- function(resourceGroupArns) {
  op <- new_operation(
    name = "DescribeResourceGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_resource_groups_input(resourceGroupArns = resourceGroupArns)
  output <- .inspector$describe_resource_groups_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_resource_groups <- inspector_describe_resource_groups

#' Describes the rules packages that are specified by the ARNs of the rules
#' packages
#'
#' @description
#' Describes the rules packages that are specified by the ARNs of the rules
#' packages.
#'
#' @usage
#' inspector_describe_rules_packages(rulesPackageArns, locale)
#'
#' @param rulesPackageArns &#91;required&#93; The ARN that specifies the rules package that you want to describe.
#' @param locale The locale that you want to translate a rules package description into.
#'
#' @section Request syntax:
#' ```
#' svc$describe_rules_packages(
#'   rulesPackageArns = list(
#'     "string"
#'   ),
#'   locale = "EN_US"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Describes the rules packages that are specified by the ARNs of the rules
#' # packages.
#' svc$describe_rules_packages(
#'   rulesPackageArns = list(
#'     "arn:aws:inspector:us-west-2:758058086616:rulespackage/0-JJOtZiqQ"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_describe_rules_packages
inspector_describe_rules_packages <- function(rulesPackageArns, locale = NULL) {
  op <- new_operation(
    name = "DescribeRulesPackages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$describe_rules_packages_input(rulesPackageArns = rulesPackageArns, locale = locale)
  output <- .inspector$describe_rules_packages_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$describe_rules_packages <- inspector_describe_rules_packages

#' Produces an assessment report that includes detailed and comprehensive
#' results of a specified assessment run
#'
#' @description
#' Produces an assessment report that includes detailed and comprehensive
#' results of a specified assessment run.
#'
#' @usage
#' inspector_get_assessment_report(assessmentRunArn, reportFileFormat,
#'   reportType)
#'
#' @param assessmentRunArn &#91;required&#93; The ARN that specifies the assessment run for which you want to generate
#' a report.
#' @param reportFileFormat &#91;required&#93; Specifies the file format (html or pdf) of the assessment report that
#' you want to generate.
#' @param reportType &#91;required&#93; Specifies the type of the assessment report that you want to generate.
#' There are two types of assessment reports: a finding report and a full
#' report. For more information, see [Assessment
#' Reports](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_reports.html).
#'
#' @section Request syntax:
#' ```
#' svc$get_assessment_report(
#'   assessmentRunArn = "string",
#'   reportFileFormat = "HTML"|"PDF",
#'   reportType = "FINDING"|"FULL"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname inspector_get_assessment_report
inspector_get_assessment_report <- function(assessmentRunArn, reportFileFormat, reportType) {
  op <- new_operation(
    name = "GetAssessmentReport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$get_assessment_report_input(assessmentRunArn = assessmentRunArn, reportFileFormat = reportFileFormat, reportType = reportType)
  output <- .inspector$get_assessment_report_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$get_assessment_report <- inspector_get_assessment_report

#' Retrieves the exclusions preview (a list of ExclusionPreview objects)
#' specified by the preview token
#'
#' @description
#' Retrieves the exclusions preview (a list of ExclusionPreview objects)
#' specified by the preview token. You can obtain the preview token by
#' running the CreateExclusionsPreview API.
#'
#' @usage
#' inspector_get_exclusions_preview(assessmentTemplateArn, previewToken,
#'   nextToken, maxResults, locale)
#'
#' @param assessmentTemplateArn &#91;required&#93; The ARN that specifies the assessment template for which the exclusions
#' preview was requested.
#' @param previewToken &#91;required&#93; The unique identifier associated of the exclusions preview.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the
#' GetExclusionsPreviewRequest action. Subsequent calls to the action fill
#' nextToken in the request with the value of nextToken from the previous
#' response to continue listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 100. The maximum value is
#' 500.
#' @param locale The locale into which you want to translate the exclusion's title,
#' description, and recommendation.
#'
#' @section Request syntax:
#' ```
#' svc$get_exclusions_preview(
#'   assessmentTemplateArn = "string",
#'   previewToken = "string",
#'   nextToken = "string",
#'   maxResults = 123,
#'   locale = "EN_US"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname inspector_get_exclusions_preview
inspector_get_exclusions_preview <- function(assessmentTemplateArn, previewToken, nextToken = NULL, maxResults = NULL, locale = NULL) {
  op <- new_operation(
    name = "GetExclusionsPreview",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$get_exclusions_preview_input(assessmentTemplateArn = assessmentTemplateArn, previewToken = previewToken, nextToken = nextToken, maxResults = maxResults, locale = locale)
  output <- .inspector$get_exclusions_preview_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$get_exclusions_preview <- inspector_get_exclusions_preview

#' Information about the data that is collected for the specified
#' assessment run
#'
#' @description
#' Information about the data that is collected for the specified
#' assessment run.
#'
#' @usage
#' inspector_get_telemetry_metadata(assessmentRunArn)
#'
#' @param assessmentRunArn &#91;required&#93; The ARN that specifies the assessment run that has the telemetry data
#' that you want to obtain.
#'
#' @section Request syntax:
#' ```
#' svc$get_telemetry_metadata(
#'   assessmentRunArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Information about the data that is collected for the specified
#' # assessment run.
#' svc$get_telemetry_metadata(
#'   assessmentRunArn = "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_get_telemetry_metadata
inspector_get_telemetry_metadata <- function(assessmentRunArn) {
  op <- new_operation(
    name = "GetTelemetryMetadata",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$get_telemetry_metadata_input(assessmentRunArn = assessmentRunArn)
  output <- .inspector$get_telemetry_metadata_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$get_telemetry_metadata <- inspector_get_telemetry_metadata

#' Lists the agents of the assessment runs that are specified by the ARNs
#' of the assessment runs
#'
#' @description
#' Lists the agents of the assessment runs that are specified by the ARNs
#' of the assessment runs.
#'
#' @usage
#' inspector_list_assessment_run_agents(assessmentRunArn, filter,
#'   nextToken, maxResults)
#'
#' @param assessmentRunArn &#91;required&#93; The ARN that specifies the assessment run whose agents you want to list.
#' @param filter You can use this parameter to specify a subset of data to be included in
#' the action's response.
#' 
#' For a record to match a filter, all specified filter attributes must
#' match. When multiple values are specified for a filter attribute, any of
#' the values can match.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the
#' **ListAssessmentRunAgents** action. Subsequent calls to the action fill
#' **nextToken** in the request with the value of **NextToken** from the
#' previous response to continue listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 10. The maximum value is
#' 500.
#'
#' @section Request syntax:
#' ```
#' svc$list_assessment_run_agents(
#'   assessmentRunArn = "string",
#'   filter = list(
#'     agentHealths = list(
#'       "HEALTHY"|"UNHEALTHY"|"UNKNOWN"
#'     ),
#'     agentHealthCodes = list(
#'       "IDLE"|"RUNNING"|"SHUTDOWN"|"UNHEALTHY"|"THROTTLED"|"UNKNOWN"
#'     )
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists the agents of the assessment runs that are specified by the ARNs
#' # of the assessment runs.
#' svc$list_assessment_run_agents(
#'   assessmentRunArn = "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-...",
#'   maxResults = 123L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_list_assessment_run_agents
inspector_list_assessment_run_agents <- function(assessmentRunArn, filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentRunAgents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$list_assessment_run_agents_input(assessmentRunArn = assessmentRunArn, filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_assessment_run_agents_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_assessment_run_agents <- inspector_list_assessment_run_agents

#' Lists the assessment runs that correspond to the assessment templates
#' that are specified by the ARNs of the assessment templates
#'
#' @description
#' Lists the assessment runs that correspond to the assessment templates
#' that are specified by the ARNs of the assessment templates.
#'
#' @usage
#' inspector_list_assessment_runs(assessmentTemplateArns, filter,
#'   nextToken, maxResults)
#'
#' @param assessmentTemplateArns The ARNs that specify the assessment templates whose assessment runs you
#' want to list.
#' @param filter You can use this parameter to specify a subset of data to be included in
#' the action's response.
#' 
#' For a record to match a filter, all specified filter attributes must
#' match. When multiple values are specified for a filter attribute, any of
#' the values can match.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the **ListAssessmentRuns**
#' action. Subsequent calls to the action fill **nextToken** in the request
#' with the value of **NextToken** from the previous response to continue
#' listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items that
#' you want in the response. The default value is 10. The maximum value is
#' 500.
#'
#' @section Request syntax:
#' ```
#' svc$list_assessment_runs(
#'   assessmentTemplateArns = list(
#'     "string"
#'   ),
#'   filter = list(
#'     namePattern = "string",
#'     states = list(
#'       "CREATED"|"START_DATA_COLLECTION_PENDING"|"START_DATA_COLLECTION_IN_PROGRESS"|"COLLECTING_DATA"|"STOP_DATA_COLLECTION_PENDING"|"DATA_COLLECTED"|"START_EVALUATING_RULES_PENDING"|"EVALUATING_RULES"|"FAILED"|"ERROR"|"COMPLETED"|"COMPLETED_WITH_ERRORS"|"CANCELED"
#'     ),
#'     durationRange = list(
#'       minSeconds = 123,
#'       maxSeconds = 123
#'     ),
#'     rulesPackageArns = list(
#'       "string"
#'     ),
#'     startTimeRange = list(
#'       beginDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       endDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     completionTimeRange = list(
#'       beginDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       endDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     ),
#'     stateChangeTimeRange = list(
#'       beginDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       endDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists the assessment runs that correspond to the assessment templates
#' # that are specified by the ARNs of the assessment templates.
#' svc$list_assessment_runs(
#'   assessmentTemplateArns = list(
#'     "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-4r1V2mAw"
#'   ),
#'   maxResults = 123L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_list_assessment_runs
inspector_list_assessment_runs <- function(assessmentTemplateArns = NULL, filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentRuns",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$list_assessment_runs_input(assessmentTemplateArns = assessmentTemplateArns, filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_assessment_runs_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_assessment_runs <- inspector_list_assessment_runs

#' Lists the ARNs of the assessment targets within this AWS account
#'
#' @description
#' Lists the ARNs of the assessment targets within this AWS account. For
#' more information about assessment targets, see [Amazon Inspector
#' Assessment
#' Targets](https://docs.aws.amazon.com/inspector/latest/userguide/inspector_applications.html).
#'
#' @usage
#' inspector_list_assessment_targets(filter, nextToken, maxResults)
#'
#' @param filter You can use this parameter to specify a subset of data to be included in
#' the action's response.
#' 
#' For a record to match a filter, all specified filter attributes must
#' match. When multiple values are specified for a filter attribute, any of
#' the values can match.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the
#' **ListAssessmentTargets** action. Subsequent calls to the action fill
#' **nextToken** in the request with the value of **NextToken** from the
#' previous response to continue listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @section Request syntax:
#' ```
#' svc$list_assessment_targets(
#'   filter = list(
#'     assessmentTargetNamePattern = "string"
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists the ARNs of the assessment targets within this AWS account.
#' svc$list_assessment_targets(
#'   maxResults = 123L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_list_assessment_targets
inspector_list_assessment_targets <- function(filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$list_assessment_targets_input(filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_assessment_targets_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_assessment_targets <- inspector_list_assessment_targets

#' Lists the assessment templates that correspond to the assessment targets
#' that are specified by the ARNs of the assessment targets
#'
#' @description
#' Lists the assessment templates that correspond to the assessment targets
#' that are specified by the ARNs of the assessment targets.
#'
#' @usage
#' inspector_list_assessment_templates(assessmentTargetArns, filter,
#'   nextToken, maxResults)
#'
#' @param assessmentTargetArns A list of ARNs that specifies the assessment targets whose assessment
#' templates you want to list.
#' @param filter You can use this parameter to specify a subset of data to be included in
#' the action's response.
#' 
#' For a record to match a filter, all specified filter attributes must
#' match. When multiple values are specified for a filter attribute, any of
#' the values can match.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the
#' **ListAssessmentTemplates** action. Subsequent calls to the action fill
#' **nextToken** in the request with the value of **NextToken** from the
#' previous response to continue listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @section Request syntax:
#' ```
#' svc$list_assessment_templates(
#'   assessmentTargetArns = list(
#'     "string"
#'   ),
#'   filter = list(
#'     namePattern = "string",
#'     durationRange = list(
#'       minSeconds = 123,
#'       maxSeconds = 123
#'     ),
#'     rulesPackageArns = list(
#'       "string"
#'     )
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists the assessment templates that correspond to the assessment targets
#' # that are specified by the ARNs of the assessment targets.
#' svc$list_assessment_templates(
#'   assessmentTargetArns = list(
#'     "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq"
#'   ),
#'   maxResults = 123L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_list_assessment_templates
inspector_list_assessment_templates <- function(assessmentTargetArns = NULL, filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListAssessmentTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$list_assessment_templates_input(assessmentTargetArns = assessmentTargetArns, filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_assessment_templates_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_assessment_templates <- inspector_list_assessment_templates

#' Lists all the event subscriptions for the assessment template that is
#' specified by the ARN of the assessment template
#'
#' @description
#' Lists all the event subscriptions for the assessment template that is
#' specified by the ARN of the assessment template. For more information,
#' see SubscribeToEvent and UnsubscribeFromEvent.
#'
#' @usage
#' inspector_list_event_subscriptions(resourceArn, nextToken, maxResults)
#'
#' @param resourceArn The ARN of the assessment template for which you want to list the
#' existing event subscriptions.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the
#' **ListEventSubscriptions** action. Subsequent calls to the action fill
#' **nextToken** in the request with the value of **NextToken** from the
#' previous response to continue listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @section Request syntax:
#' ```
#' svc$list_event_subscriptions(
#'   resourceArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists all the event subscriptions for the assessment template that is
#' # specified by the ARN of the assessment template.
#' svc$list_event_subscriptions(
#'   maxResults = 123L,
#'   resourceArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX/template/0-7sbz2..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_list_event_subscriptions
inspector_list_event_subscriptions <- function(resourceArn = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListEventSubscriptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$list_event_subscriptions_input(resourceArn = resourceArn, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_event_subscriptions_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_event_subscriptions <- inspector_list_event_subscriptions

#' List exclusions that are generated by the assessment run
#'
#' @description
#' List exclusions that are generated by the assessment run.
#'
#' @usage
#' inspector_list_exclusions(assessmentRunArn, nextToken, maxResults)
#'
#' @param assessmentRunArn &#91;required&#93; The ARN of the assessment run that generated the exclusions that you
#' want to list.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the ListExclusionsRequest
#' action. Subsequent calls to the action fill nextToken in the request
#' with the value of nextToken from the previous response to continue
#' listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 100. The maximum value is
#' 500.
#'
#' @section Request syntax:
#' ```
#' svc$list_exclusions(
#'   assessmentRunArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname inspector_list_exclusions
inspector_list_exclusions <- function(assessmentRunArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListExclusions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$list_exclusions_input(assessmentRunArn = assessmentRunArn, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_exclusions_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_exclusions <- inspector_list_exclusions

#' Lists findings that are generated by the assessment runs that are
#' specified by the ARNs of the assessment runs
#'
#' @description
#' Lists findings that are generated by the assessment runs that are
#' specified by the ARNs of the assessment runs.
#'
#' @usage
#' inspector_list_findings(assessmentRunArns, filter, nextToken,
#'   maxResults)
#'
#' @param assessmentRunArns The ARNs of the assessment runs that generate the findings that you want
#' to list.
#' @param filter You can use this parameter to specify a subset of data to be included in
#' the action's response.
#' 
#' For a record to match a filter, all specified filter attributes must
#' match. When multiple values are specified for a filter attribute, any of
#' the values can match.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the **ListFindings**
#' action. Subsequent calls to the action fill **nextToken** in the request
#' with the value of **NextToken** from the previous response to continue
#' listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @section Request syntax:
#' ```
#' svc$list_findings(
#'   assessmentRunArns = list(
#'     "string"
#'   ),
#'   filter = list(
#'     agentIds = list(
#'       "string"
#'     ),
#'     autoScalingGroups = list(
#'       "string"
#'     ),
#'     ruleNames = list(
#'       "string"
#'     ),
#'     severities = list(
#'       "Low"|"Medium"|"High"|"Informational"|"Undefined"
#'     ),
#'     rulesPackageArns = list(
#'       "string"
#'     ),
#'     attributes = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     userAttributes = list(
#'       list(
#'         key = "string",
#'         value = "string"
#'       )
#'     ),
#'     creationTimeRange = list(
#'       beginDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       endDate = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists findings that are generated by the assessment runs that are
#' # specified by the ARNs of the assessment runs.
#' svc$list_findings(
#'   assessmentRunArns = list(
#'     "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-4r1V2mAw/run/0-MK..."
#'   ),
#'   maxResults = 123L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_list_findings
inspector_list_findings <- function(assessmentRunArns = NULL, filter = NULL, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListFindings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$list_findings_input(assessmentRunArns = assessmentRunArns, filter = filter, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_findings_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_findings <- inspector_list_findings

#' Lists all available Amazon Inspector rules packages
#'
#' @description
#' Lists all available Amazon Inspector rules packages.
#'
#' @usage
#' inspector_list_rules_packages(nextToken, maxResults)
#'
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the **ListRulesPackages**
#' action. Subsequent calls to the action fill **nextToken** in the request
#' with the value of **NextToken** from the previous response to continue
#' listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @section Request syntax:
#' ```
#' svc$list_rules_packages(
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists all available Amazon Inspector rules packages.
#' svc$list_rules_packages(
#'   maxResults = 123L
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_list_rules_packages
inspector_list_rules_packages <- function(nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "ListRulesPackages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$list_rules_packages_input(nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$list_rules_packages_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_rules_packages <- inspector_list_rules_packages

#' Lists all tags associated with an assessment template
#'
#' @description
#' Lists all tags associated with an assessment template.
#'
#' @usage
#' inspector_list_tags_for_resource(resourceArn)
#'
#' @param resourceArn &#91;required&#93; The ARN that specifies the assessment template whose tags you want to
#' list.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   resourceArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Lists all tags associated with an assessment template.
#' svc$list_tags_for_resource(
#'   resourceArn = "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-gcwFl..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_list_tags_for_resource
inspector_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .inspector$list_tags_for_resource_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$list_tags_for_resource <- inspector_list_tags_for_resource

#' Previews the agents installed on the EC2 instances that are part of the
#' specified assessment target
#'
#' @description
#' Previews the agents installed on the EC2 instances that are part of the
#' specified assessment target.
#'
#' @usage
#' inspector_preview_agents(previewAgentsArn, nextToken, maxResults)
#'
#' @param previewAgentsArn &#91;required&#93; The ARN of the assessment target whose agents you want to preview.
#' @param nextToken You can use this parameter when paginating results. Set the value of
#' this parameter to null on your first call to the **PreviewAgents**
#' action. Subsequent calls to the action fill **nextToken** in the request
#' with the value of **NextToken** from the previous response to continue
#' listing data.
#' @param maxResults You can use this parameter to indicate the maximum number of items you
#' want in the response. The default value is 10. The maximum value is 500.
#'
#' @section Request syntax:
#' ```
#' svc$preview_agents(
#'   previewAgentsArn = "string",
#'   nextToken = "string",
#'   maxResults = 123
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Previews the agents installed on the EC2 instances that are part of the
#' # specified assessment target.
#' svc$preview_agents(
#'   maxResults = 123L,
#'   previewAgentsArn = "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_preview_agents
inspector_preview_agents <- function(previewAgentsArn, nextToken = NULL, maxResults = NULL) {
  op <- new_operation(
    name = "PreviewAgents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$preview_agents_input(previewAgentsArn = previewAgentsArn, nextToken = nextToken, maxResults = maxResults)
  output <- .inspector$preview_agents_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$preview_agents <- inspector_preview_agents

#' Registers the IAM role that grants Amazon Inspector access to AWS
#' Services needed to perform security assessments
#'
#' @description
#' Registers the IAM role that grants Amazon Inspector access to AWS
#' Services needed to perform security assessments.
#'
#' @usage
#' inspector_register_cross_account_access_role(roleArn)
#'
#' @param roleArn &#91;required&#93; The ARN of the IAM role that grants Amazon Inspector access to AWS
#' Services needed to perform security assessments.
#'
#' @section Request syntax:
#' ```
#' svc$register_cross_account_access_role(
#'   roleArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Registers the IAM role that Amazon Inspector uses to list your EC2
#' # instances at the start of the assessment run or when you call the
#' # PreviewAgents action.
#' svc$register_cross_account_access_role(
#'   roleArn = "arn:aws:iam::123456789012:role/inspector"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_register_cross_account_access_role
inspector_register_cross_account_access_role <- function(roleArn) {
  op <- new_operation(
    name = "RegisterCrossAccountAccessRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$register_cross_account_access_role_input(roleArn = roleArn)
  output <- .inspector$register_cross_account_access_role_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$register_cross_account_access_role <- inspector_register_cross_account_access_role

#' Removes entire attributes (key and value pairs) from the findings that
#' are specified by the ARNs of the findings where an attribute with the
#' specified key exists
#'
#' @description
#' Removes entire attributes (key and value pairs) from the findings that
#' are specified by the ARNs of the findings where an attribute with the
#' specified key exists.
#'
#' @usage
#' inspector_remove_attributes_from_findings(findingArns, attributeKeys)
#'
#' @param findingArns &#91;required&#93; The ARNs that specify the findings that you want to remove attributes
#' from.
#' @param attributeKeys &#91;required&#93; The array of attribute keys that you want to remove from specified
#' findings.
#'
#' @section Request syntax:
#' ```
#' svc$remove_attributes_from_findings(
#'   findingArns = list(
#'     "string"
#'   ),
#'   attributeKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Removes entire attributes (key and value pairs) from the findings that
#' # are specified by the ARNs of the findings where an attribute with the
#' # specified key exists.
#' svc$remove_attributes_from_findings(
#'   attributeKeys = list(
#'     "key=Example,value=example"
#'   ),
#'   findingArns = list(
#'     "arn:aws:inspector:us-west-2:123456789012:target/0-0kFIPusq/template/0-8l1VIE0D/run/0-Z0..."
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_remove_attributes_from_findings
inspector_remove_attributes_from_findings <- function(findingArns, attributeKeys) {
  op <- new_operation(
    name = "RemoveAttributesFromFindings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$remove_attributes_from_findings_input(findingArns = findingArns, attributeKeys = attributeKeys)
  output <- .inspector$remove_attributes_from_findings_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$remove_attributes_from_findings <- inspector_remove_attributes_from_findings

#' Sets tags (key and value pairs) to the assessment template that is
#' specified by the ARN of the assessment template
#'
#' @description
#' Sets tags (key and value pairs) to the assessment template that is
#' specified by the ARN of the assessment template.
#'
#' @usage
#' inspector_set_tags_for_resource(resourceArn, tags)
#'
#' @param resourceArn &#91;required&#93; The ARN of the assessment template that you want to set tags to.
#' @param tags A collection of key and value pairs that you want to set to the
#' assessment template.
#'
#' @section Request syntax:
#' ```
#' svc$set_tags_for_resource(
#'   resourceArn = "string",
#'   tags = list(
#'     list(
#'       key = "string",
#'       value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Sets tags (key and value pairs) to the assessment template that is
#' # specified by the ARN of the assessment template.
#' svc$set_tags_for_resource(
#'   resourceArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX/template/0-7sbz2...",
#'   tags = list(
#'     list(
#'       key = "Example",
#'       value = "example"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_set_tags_for_resource
inspector_set_tags_for_resource <- function(resourceArn, tags = NULL) {
  op <- new_operation(
    name = "SetTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$set_tags_for_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .inspector$set_tags_for_resource_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$set_tags_for_resource <- inspector_set_tags_for_resource

#' Starts the assessment run specified by the ARN of the assessment
#' template
#'
#' @description
#' Starts the assessment run specified by the ARN of the assessment
#' template. For this API to function properly, you must not exceed the
#' limit of running up to 500 concurrent agents per AWS account.
#'
#' @usage
#' inspector_start_assessment_run(assessmentTemplateArn, assessmentRunName)
#'
#' @param assessmentTemplateArn &#91;required&#93; The ARN of the assessment template of the assessment run that you want
#' to start.
#' @param assessmentRunName You can specify the name for the assessment run. The name must be unique
#' for the assessment template whose ARN is used to start the assessment
#' run.
#'
#' @section Request syntax:
#' ```
#' svc$start_assessment_run(
#'   assessmentTemplateArn = "string",
#'   assessmentRunName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Starts the assessment run specified by the ARN of the assessment
#' # template. For this API to function properly, you must not exceed the
#' # limit of running up to 500 concurrent agents per AWS account.
#' svc$start_assessment_run(
#'   assessmentRunName = "examplerun",
#'   assessmentTemplateArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX/templa..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_start_assessment_run
inspector_start_assessment_run <- function(assessmentTemplateArn, assessmentRunName = NULL) {
  op <- new_operation(
    name = "StartAssessmentRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$start_assessment_run_input(assessmentTemplateArn = assessmentTemplateArn, assessmentRunName = assessmentRunName)
  output <- .inspector$start_assessment_run_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$start_assessment_run <- inspector_start_assessment_run

#' Stops the assessment run that is specified by the ARN of the assessment
#' run
#'
#' @description
#' Stops the assessment run that is specified by the ARN of the assessment
#' run.
#'
#' @usage
#' inspector_stop_assessment_run(assessmentRunArn, stopAction)
#'
#' @param assessmentRunArn &#91;required&#93; The ARN of the assessment run that you want to stop.
#' @param stopAction An input option that can be set to either START\\_EVALUATION or
#' SKIP\\_EVALUATION. START\\_EVALUATION (the default value), stops the AWS
#' agent from collecting data and begins the results evaluation and the
#' findings generation process. SKIP\\_EVALUATION cancels the assessment run
#' immediately, after which no findings are generated.
#'
#' @section Request syntax:
#' ```
#' svc$stop_assessment_run(
#'   assessmentRunArn = "string",
#'   stopAction = "START_EVALUATION"|"SKIP_EVALUATION"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Stops the assessment run that is specified by the ARN of the assessment
#' # run.
#' svc$stop_assessment_run(
#'   assessmentRunArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX/template/0-..."
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_stop_assessment_run
inspector_stop_assessment_run <- function(assessmentRunArn, stopAction = NULL) {
  op <- new_operation(
    name = "StopAssessmentRun",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$stop_assessment_run_input(assessmentRunArn = assessmentRunArn, stopAction = stopAction)
  output <- .inspector$stop_assessment_run_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$stop_assessment_run <- inspector_stop_assessment_run

#' Enables the process of sending Amazon Simple Notification Service (SNS)
#' notifications about a specified event to a specified SNS topic
#'
#' @description
#' Enables the process of sending Amazon Simple Notification Service (SNS)
#' notifications about a specified event to a specified SNS topic.
#'
#' @usage
#' inspector_subscribe_to_event(resourceArn, event, topicArn)
#'
#' @param resourceArn &#91;required&#93; The ARN of the assessment template that is used during the event for
#' which you want to receive SNS notifications.
#' @param event &#91;required&#93; The event for which you want to receive SNS notifications.
#' @param topicArn &#91;required&#93; The ARN of the SNS topic to which the SNS notifications are sent.
#'
#' @section Request syntax:
#' ```
#' svc$subscribe_to_event(
#'   resourceArn = "string",
#'   event = "ASSESSMENT_RUN_STARTED"|"ASSESSMENT_RUN_COMPLETED"|"ASSESSMENT_RUN_STATE_CHANGED"|"FINDING_REPORTED"|"OTHER",
#'   topicArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Enables the process of sending Amazon Simple Notification Service (SNS)
#' # notifications about a specified event to a specified SNS topic.
#' svc$subscribe_to_event(
#'   event = "ASSESSMENT_RUN_COMPLETED",
#'   resourceArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX/template/0-7sbz2...",
#'   topicArn = "arn:aws:sns:us-west-2:123456789012:exampletopic"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_subscribe_to_event
inspector_subscribe_to_event <- function(resourceArn, event, topicArn) {
  op <- new_operation(
    name = "SubscribeToEvent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$subscribe_to_event_input(resourceArn = resourceArn, event = event, topicArn = topicArn)
  output <- .inspector$subscribe_to_event_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$subscribe_to_event <- inspector_subscribe_to_event

#' Disables the process of sending Amazon Simple Notification Service (SNS)
#' notifications about a specified event to a specified SNS topic
#'
#' @description
#' Disables the process of sending Amazon Simple Notification Service (SNS)
#' notifications about a specified event to a specified SNS topic.
#'
#' @usage
#' inspector_unsubscribe_from_event(resourceArn, event, topicArn)
#'
#' @param resourceArn &#91;required&#93; The ARN of the assessment template that is used during the event for
#' which you want to stop receiving SNS notifications.
#' @param event &#91;required&#93; The event for which you want to stop receiving SNS notifications.
#' @param topicArn &#91;required&#93; The ARN of the SNS topic to which SNS notifications are sent.
#'
#' @section Request syntax:
#' ```
#' svc$unsubscribe_from_event(
#'   resourceArn = "string",
#'   event = "ASSESSMENT_RUN_STARTED"|"ASSESSMENT_RUN_COMPLETED"|"ASSESSMENT_RUN_STATE_CHANGED"|"FINDING_REPORTED"|"OTHER",
#'   topicArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Disables the process of sending Amazon Simple Notification Service (SNS)
#' # notifications about a specified event to a specified SNS topic.
#' svc$unsubscribe_from_event(
#'   event = "ASSESSMENT_RUN_COMPLETED",
#'   resourceArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX/template/0-7sbz2...",
#'   topicArn = "arn:aws:sns:us-west-2:123456789012:exampletopic"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_unsubscribe_from_event
inspector_unsubscribe_from_event <- function(resourceArn, event, topicArn) {
  op <- new_operation(
    name = "UnsubscribeFromEvent",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$unsubscribe_from_event_input(resourceArn = resourceArn, event = event, topicArn = topicArn)
  output <- .inspector$unsubscribe_from_event_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$unsubscribe_from_event <- inspector_unsubscribe_from_event

#' Updates the assessment target that is specified by the ARN of the
#' assessment target
#'
#' @description
#' Updates the assessment target that is specified by the ARN of the
#' assessment target.
#' 
#' If resourceGroupArn is not specified, all EC2 instances in the current
#' AWS account and region are included in the assessment target.
#'
#' @usage
#' inspector_update_assessment_target(assessmentTargetArn,
#'   assessmentTargetName, resourceGroupArn)
#'
#' @param assessmentTargetArn &#91;required&#93; The ARN of the assessment target that you want to update.
#' @param assessmentTargetName &#91;required&#93; The name of the assessment target that you want to update.
#' @param resourceGroupArn The ARN of the resource group that is used to specify the new resource
#' group to associate with the assessment target.
#'
#' @section Request syntax:
#' ```
#' svc$update_assessment_target(
#'   assessmentTargetArn = "string",
#'   assessmentTargetName = "string",
#'   resourceGroupArn = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # Updates the assessment target that is specified by the ARN of the
#' # assessment target.
#' svc$update_assessment_target(
#'   assessmentTargetArn = "arn:aws:inspector:us-west-2:123456789012:target/0-nvgVhaxX",
#'   assessmentTargetName = "Example",
#'   resourceGroupArn = "arn:aws:inspector:us-west-2:123456789012:resourcegroup/0-yNbgL5Pt"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname inspector_update_assessment_target
inspector_update_assessment_target <- function(assessmentTargetArn, assessmentTargetName, resourceGroupArn = NULL) {
  op <- new_operation(
    name = "UpdateAssessmentTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .inspector$update_assessment_target_input(assessmentTargetArn = assessmentTargetArn, assessmentTargetName = assessmentTargetName, resourceGroupArn = resourceGroupArn)
  output <- .inspector$update_assessment_target_output()
  config <- get_config()
  svc <- .inspector$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.inspector$operations$update_assessment_target <- inspector_update_assessment_target
