% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acmpca_operations.R
\name{acmpca_delete_certificate_authority}
\alias{acmpca_delete_certificate_authority}
\title{Deletes a private certificate authority (CA)}
\usage{
acmpca_delete_certificate_authority(CertificateAuthorityArn,
  PermanentDeletionTimeInDays)
}
\arguments{
\item{CertificateAuthorityArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
CreateCertificateAuthority. This must have the following form:

\code{arn:aws:acm-pca:<i>region</i>:<i>account</i>:certificate-authority/<i>12345678-1234-1234-1234-123456789012</i> }.}

\item{PermanentDeletionTimeInDays}{The number of days to make a CA restorable after it has been deleted.
This can be anywhere from 7 to 30 days, with 30 being the default.}
}
\description{
Deletes a private certificate authority (CA). You must provide the ARN
(Amazon Resource Name) of the private CA that you want to delete. You
can find the ARN by calling the ListCertificateAuthorities operation.
Before you can delete a CA, you must disable it. Call the
UpdateCertificateAuthority operation and set the
\strong{CertificateAuthorityStatus} parameter to \code{DISABLED}.
}
\details{
Additionally, you can delete a CA if you are waiting for it to be
created (the \strong{Status} field of the CertificateAuthority is
\code{CREATING}). You can also delete it if the CA has been created but you
haven't yet imported the signed certificate (the \strong{Status} is
\code{PENDING_CERTIFICATE}) into ACM PCA.

If the CA is in one of the previously mentioned states and you call
DeleteCertificateAuthority, the CA's status changes to \code{DELETED}.
However, the CA won't be permanently deleted until the restoration
period has passed. By default, if you do not set the
\code{PermanentDeletionTimeInDays} parameter, the CA remains restorable for
30 days. You can set the parameter from 7 to 30 days. The
DescribeCertificateAuthority operation returns the time remaining in the
restoration window of a Private CA in the \code{DELETED} state. To restore an
eligible CA, call the RestoreCertificateAuthority operation.
}
\section{Request syntax}{
\preformatted{svc$delete_certificate_authority(
  CertificateAuthorityArn = "string",
  PermanentDeletionTimeInDays = 123
)
}
}

\keyword{internal}
