% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_modify_listener}
\alias{elbv2_modify_listener}
\title{Replaces the specified properties of the specified listener}
\usage{
elbv2_modify_listener(
  ListenerArn,
  Port = NULL,
  Protocol = NULL,
  SslPolicy = NULL,
  Certificates = NULL,
  DefaultActions = NULL,
  AlpnPolicy = NULL,
  MutualAuthentication = NULL
)
}
\arguments{
\item{ListenerArn}{[required] The Amazon Resource Name (ARN) of the listener.}

\item{Port}{The port for connections from clients to the load balancer. You can't
specify a port for a Gateway Load Balancer.}

\item{Protocol}{The protocol for connections from clients to the load balancer.
Application Load Balancers support the HTTP and HTTPS protocols. Network
Load Balancers support the TCP, TLS, UDP, and TCP_UDP protocols. You
can’t change the protocol to UDP or TCP_UDP if dual-stack mode is
enabled. You can't specify a protocol for a Gateway Load Balancer.}

\item{SslPolicy}{[HTTPS and TLS listeners] The security policy that defines which
protocols and ciphers are supported.

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/application/create-https-listener.html#describe-ssl-policies}{Security policies}
in the \emph{Application Load Balancers Guide} or \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/#describe-ssl-policies}{Security policies}
in the \emph{Network Load Balancers Guide}.}

\item{Certificates}{[HTTPS and TLS listeners] The default certificate for the listener.
You must provide exactly one certificate. Set \code{CertificateArn} to the
certificate ARN but do not set \code{IsDefault}.}

\item{DefaultActions}{The actions for the default rule.}

\item{AlpnPolicy}{[TLS listeners] The name of the Application-Layer Protocol Negotiation
(ALPN) policy. You can specify one policy name. The following are the
possible values:
\itemize{
\item \code{HTTP1Only}
\item \code{HTTP2Only}
\item \code{HTTP2Optional}
\item \code{HTTP2Preferred}
\item \code{None}
}

For more information, see \href{https://docs.aws.amazon.com/elasticloadbalancing/latest/network/#alpn-policies}{ALPN policies}
in the \emph{Network Load Balancers Guide}.}

\item{MutualAuthentication}{The mutual authentication configuration information.}
}
\description{
Replaces the specified properties of the specified listener. Any properties that you do not specify remain unchanged.

See \url{https://www.paws-r-sdk.com/docs/elbv2_modify_listener/} for full documentation.
}
\keyword{internal}
