# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include telconetworkbuilder_service.R
NULL

#' Cancels a network operation
#'
#' @description
#' Cancels a network operation.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_cancel_sol_network_operation/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_cancel_sol_network_operation/) for full documentation.
#'
#' @param nsLcmOpOccId &#91;required&#93; The identifier of the network operation.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_cancel_sol_network_operation
telconetworkbuilder_cancel_sol_network_operation <- function(nsLcmOpOccId) {
  op <- new_operation(
    name = "CancelSolNetworkOperation",
    http_method = "POST",
    http_path = "/sol/nslcm/v1/ns_lcm_op_occs/{nsLcmOpOccId}/cancel",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$cancel_sol_network_operation_input(nsLcmOpOccId = nsLcmOpOccId)
  output <- .telconetworkbuilder$cancel_sol_network_operation_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$cancel_sol_network_operation <- telconetworkbuilder_cancel_sol_network_operation

#' Creates a function package
#'
#' @description
#' Creates a function package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_create_sol_function_package/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_create_sol_function_package/) for full documentation.
#'
#' @param tags A tag is a label that you assign to an Amazon Web Services resource.
#' Each tag consists of a key and an optional value. You can use tags to
#' search and filter your resources or track your Amazon Web Services
#' costs.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_create_sol_function_package
telconetworkbuilder_create_sol_function_package <- function(tags = NULL) {
  op <- new_operation(
    name = "CreateSolFunctionPackage",
    http_method = "POST",
    http_path = "/sol/vnfpkgm/v1/vnf_packages",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$create_sol_function_package_input(tags = tags)
  output <- .telconetworkbuilder$create_sol_function_package_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$create_sol_function_package <- telconetworkbuilder_create_sol_function_package

#' Creates a network instance
#'
#' @description
#' Creates a network instance.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_create_sol_network_instance/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_create_sol_network_instance/) for full documentation.
#'
#' @param nsDescription Network instance description.
#' @param nsName &#91;required&#93; Network instance name.
#' @param nsdInfoId &#91;required&#93; ID for network service descriptor.
#' @param tags A tag is a label that you assign to an Amazon Web Services resource.
#' Each tag consists of a key and an optional value. You can use tags to
#' search and filter your resources or track your Amazon Web Services
#' costs.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_create_sol_network_instance
telconetworkbuilder_create_sol_network_instance <- function(nsDescription = NULL, nsName, nsdInfoId, tags = NULL) {
  op <- new_operation(
    name = "CreateSolNetworkInstance",
    http_method = "POST",
    http_path = "/sol/nslcm/v1/ns_instances",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$create_sol_network_instance_input(nsDescription = nsDescription, nsName = nsName, nsdInfoId = nsdInfoId, tags = tags)
  output <- .telconetworkbuilder$create_sol_network_instance_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$create_sol_network_instance <- telconetworkbuilder_create_sol_network_instance

#' Creates a network package
#'
#' @description
#' Creates a network package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_create_sol_network_package/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_create_sol_network_package/) for full documentation.
#'
#' @param tags A tag is a label that you assign to an Amazon Web Services resource.
#' Each tag consists of a key and an optional value. You can use tags to
#' search and filter your resources or track your Amazon Web Services
#' costs.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_create_sol_network_package
telconetworkbuilder_create_sol_network_package <- function(tags = NULL) {
  op <- new_operation(
    name = "CreateSolNetworkPackage",
    http_method = "POST",
    http_path = "/sol/nsd/v1/ns_descriptors",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$create_sol_network_package_input(tags = tags)
  output <- .telconetworkbuilder$create_sol_network_package_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$create_sol_network_package <- telconetworkbuilder_create_sol_network_package

#' Deletes a function package
#'
#' @description
#' Deletes a function package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_delete_sol_function_package/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_delete_sol_function_package/) for full documentation.
#'
#' @param vnfPkgId &#91;required&#93; ID of the function package.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_delete_sol_function_package
telconetworkbuilder_delete_sol_function_package <- function(vnfPkgId) {
  op <- new_operation(
    name = "DeleteSolFunctionPackage",
    http_method = "DELETE",
    http_path = "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$delete_sol_function_package_input(vnfPkgId = vnfPkgId)
  output <- .telconetworkbuilder$delete_sol_function_package_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$delete_sol_function_package <- telconetworkbuilder_delete_sol_function_package

#' Deletes a network instance
#'
#' @description
#' Deletes a network instance.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_delete_sol_network_instance/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_delete_sol_network_instance/) for full documentation.
#'
#' @param nsInstanceId &#91;required&#93; Network instance ID.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_delete_sol_network_instance
telconetworkbuilder_delete_sol_network_instance <- function(nsInstanceId) {
  op <- new_operation(
    name = "DeleteSolNetworkInstance",
    http_method = "DELETE",
    http_path = "/sol/nslcm/v1/ns_instances/{nsInstanceId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$delete_sol_network_instance_input(nsInstanceId = nsInstanceId)
  output <- .telconetworkbuilder$delete_sol_network_instance_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$delete_sol_network_instance <- telconetworkbuilder_delete_sol_network_instance

#' Deletes network package
#'
#' @description
#' Deletes network package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_delete_sol_network_package/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_delete_sol_network_package/) for full documentation.
#'
#' @param nsdInfoId &#91;required&#93; ID of the network service descriptor in the network package.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_delete_sol_network_package
telconetworkbuilder_delete_sol_network_package <- function(nsdInfoId) {
  op <- new_operation(
    name = "DeleteSolNetworkPackage",
    http_method = "DELETE",
    http_path = "/sol/nsd/v1/ns_descriptors/{nsdInfoId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$delete_sol_network_package_input(nsdInfoId = nsdInfoId)
  output <- .telconetworkbuilder$delete_sol_network_package_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$delete_sol_network_package <- telconetworkbuilder_delete_sol_network_package

#' Gets the details of a network function instance, including the
#' instantiation state and metadata from the function package descriptor in
#' the network function package
#'
#' @description
#' Gets the details of a network function instance, including the instantiation state and metadata from the function package descriptor in the network function package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_function_instance/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_function_instance/) for full documentation.
#'
#' @param vnfInstanceId &#91;required&#93; ID of the network function.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_get_sol_function_instance
telconetworkbuilder_get_sol_function_instance <- function(vnfInstanceId) {
  op <- new_operation(
    name = "GetSolFunctionInstance",
    http_method = "GET",
    http_path = "/sol/vnflcm/v1/vnf_instances/{vnfInstanceId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$get_sol_function_instance_input(vnfInstanceId = vnfInstanceId)
  output <- .telconetworkbuilder$get_sol_function_instance_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$get_sol_function_instance <- telconetworkbuilder_get_sol_function_instance

#' Gets the details of an individual function package, such as the
#' operational state and whether the package is in use
#'
#' @description
#' Gets the details of an individual function package, such as the operational state and whether the package is in use.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_function_package/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_function_package/) for full documentation.
#'
#' @param vnfPkgId &#91;required&#93; ID of the function package.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_get_sol_function_package
telconetworkbuilder_get_sol_function_package <- function(vnfPkgId) {
  op <- new_operation(
    name = "GetSolFunctionPackage",
    http_method = "GET",
    http_path = "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$get_sol_function_package_input(vnfPkgId = vnfPkgId)
  output <- .telconetworkbuilder$get_sol_function_package_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$get_sol_function_package <- telconetworkbuilder_get_sol_function_package

#' Gets the contents of a function package
#'
#' @description
#' Gets the contents of a function package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_function_package_content/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_function_package_content/) for full documentation.
#'
#' @param accept &#91;required&#93; The format of the package that you want to download from the function
#' packages.
#' @param vnfPkgId &#91;required&#93; ID of the function package.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_get_sol_function_package_content
telconetworkbuilder_get_sol_function_package_content <- function(accept, vnfPkgId) {
  op <- new_operation(
    name = "GetSolFunctionPackageContent",
    http_method = "GET",
    http_path = "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}/package_content",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$get_sol_function_package_content_input(accept = accept, vnfPkgId = vnfPkgId)
  output <- .telconetworkbuilder$get_sol_function_package_content_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$get_sol_function_package_content <- telconetworkbuilder_get_sol_function_package_content

#' Gets a function package descriptor in a function package
#'
#' @description
#' Gets a function package descriptor in a function package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_function_package_descriptor/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_function_package_descriptor/) for full documentation.
#'
#' @param accept &#91;required&#93; Indicates which content types, expressed as MIME types, the client is
#' able to understand.
#' @param vnfPkgId &#91;required&#93; ID of the function package.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_get_sol_function_package_descriptor
telconetworkbuilder_get_sol_function_package_descriptor <- function(accept, vnfPkgId) {
  op <- new_operation(
    name = "GetSolFunctionPackageDescriptor",
    http_method = "GET",
    http_path = "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}/vnfd",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$get_sol_function_package_descriptor_input(accept = accept, vnfPkgId = vnfPkgId)
  output <- .telconetworkbuilder$get_sol_function_package_descriptor_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$get_sol_function_package_descriptor <- telconetworkbuilder_get_sol_function_package_descriptor

#' Gets the details of the network instance
#'
#' @description
#' Gets the details of the network instance.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_network_instance/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_network_instance/) for full documentation.
#'
#' @param nsInstanceId &#91;required&#93; ID of the network instance.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_get_sol_network_instance
telconetworkbuilder_get_sol_network_instance <- function(nsInstanceId) {
  op <- new_operation(
    name = "GetSolNetworkInstance",
    http_method = "GET",
    http_path = "/sol/nslcm/v1/ns_instances/{nsInstanceId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$get_sol_network_instance_input(nsInstanceId = nsInstanceId)
  output <- .telconetworkbuilder$get_sol_network_instance_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$get_sol_network_instance <- telconetworkbuilder_get_sol_network_instance

#' Gets the details of a network operation, including the tasks involved in
#' the network operation and the status of the tasks
#'
#' @description
#' Gets the details of a network operation, including the tasks involved in the network operation and the status of the tasks.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_network_operation/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_network_operation/) for full documentation.
#'
#' @param nsLcmOpOccId &#91;required&#93; The identifier of the network operation.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_get_sol_network_operation
telconetworkbuilder_get_sol_network_operation <- function(nsLcmOpOccId) {
  op <- new_operation(
    name = "GetSolNetworkOperation",
    http_method = "GET",
    http_path = "/sol/nslcm/v1/ns_lcm_op_occs/{nsLcmOpOccId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$get_sol_network_operation_input(nsLcmOpOccId = nsLcmOpOccId)
  output <- .telconetworkbuilder$get_sol_network_operation_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$get_sol_network_operation <- telconetworkbuilder_get_sol_network_operation

#' Gets the details of a network package
#'
#' @description
#' Gets the details of a network package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_network_package/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_network_package/) for full documentation.
#'
#' @param nsdInfoId &#91;required&#93; ID of the network service descriptor in the network package.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_get_sol_network_package
telconetworkbuilder_get_sol_network_package <- function(nsdInfoId) {
  op <- new_operation(
    name = "GetSolNetworkPackage",
    http_method = "GET",
    http_path = "/sol/nsd/v1/ns_descriptors/{nsdInfoId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$get_sol_network_package_input(nsdInfoId = nsdInfoId)
  output <- .telconetworkbuilder$get_sol_network_package_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$get_sol_network_package <- telconetworkbuilder_get_sol_network_package

#' Gets the contents of a network package
#'
#' @description
#' Gets the contents of a network package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_network_package_content/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_network_package_content/) for full documentation.
#'
#' @param accept &#91;required&#93; The format of the package you want to download from the network package.
#' @param nsdInfoId &#91;required&#93; ID of the network service descriptor in the network package.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_get_sol_network_package_content
telconetworkbuilder_get_sol_network_package_content <- function(accept, nsdInfoId) {
  op <- new_operation(
    name = "GetSolNetworkPackageContent",
    http_method = "GET",
    http_path = "/sol/nsd/v1/ns_descriptors/{nsdInfoId}/nsd_content",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$get_sol_network_package_content_input(accept = accept, nsdInfoId = nsdInfoId)
  output <- .telconetworkbuilder$get_sol_network_package_content_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$get_sol_network_package_content <- telconetworkbuilder_get_sol_network_package_content

#' Gets the content of the network service descriptor
#'
#' @description
#' Gets the content of the network service descriptor.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_network_package_descriptor/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_get_sol_network_package_descriptor/) for full documentation.
#'
#' @param nsdInfoId &#91;required&#93; ID of the network service descriptor in the network package.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_get_sol_network_package_descriptor
telconetworkbuilder_get_sol_network_package_descriptor <- function(nsdInfoId) {
  op <- new_operation(
    name = "GetSolNetworkPackageDescriptor",
    http_method = "GET",
    http_path = "/sol/nsd/v1/ns_descriptors/{nsdInfoId}/nsd",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$get_sol_network_package_descriptor_input(nsdInfoId = nsdInfoId)
  output <- .telconetworkbuilder$get_sol_network_package_descriptor_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$get_sol_network_package_descriptor <- telconetworkbuilder_get_sol_network_package_descriptor

#' Instantiates a network instance
#'
#' @description
#' Instantiates a network instance.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_instantiate_sol_network_instance/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_instantiate_sol_network_instance/) for full documentation.
#'
#' @param additionalParamsForNs Provides values for the configurable properties.
#' @param dryRun A check for whether you have the required permissions for the action
#' without actually making the request and provides an error response. If
#' you have the required permissions, the error response is
#' `DryRunOperation`. Otherwise, it is `UnauthorizedOperation`.
#' @param nsInstanceId &#91;required&#93; ID of the network instance.
#' @param tags A tag is a label that you assign to an Amazon Web Services resource.
#' Each tag consists of a key and an optional value. When you use this API,
#' the tags are only applied to the network operation that is created.
#' These tags are not applied to the network instance. Use tags to search
#' and filter your resources or track your Amazon Web Services costs.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_instantiate_sol_network_instance
telconetworkbuilder_instantiate_sol_network_instance <- function(additionalParamsForNs = NULL, dryRun = NULL, nsInstanceId, tags = NULL) {
  op <- new_operation(
    name = "InstantiateSolNetworkInstance",
    http_method = "POST",
    http_path = "/sol/nslcm/v1/ns_instances/{nsInstanceId}/instantiate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$instantiate_sol_network_instance_input(additionalParamsForNs = additionalParamsForNs, dryRun = dryRun, nsInstanceId = nsInstanceId, tags = tags)
  output <- .telconetworkbuilder$instantiate_sol_network_instance_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$instantiate_sol_network_instance <- telconetworkbuilder_instantiate_sol_network_instance

#' Lists network function instances
#'
#' @description
#' Lists network function instances.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_sol_function_instances/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_sol_function_instances/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_list_sol_function_instances
telconetworkbuilder_list_sol_function_instances <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSolFunctionInstances",
    http_method = "GET",
    http_path = "/sol/vnflcm/v1/vnf_instances",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "functionInstances"),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$list_sol_function_instances_input(maxResults = maxResults, nextToken = nextToken)
  output <- .telconetworkbuilder$list_sol_function_instances_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$list_sol_function_instances <- telconetworkbuilder_list_sol_function_instances

#' Lists information about function packages
#'
#' @description
#' Lists information about function packages.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_sol_function_packages/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_sol_function_packages/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_list_sol_function_packages
telconetworkbuilder_list_sol_function_packages <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSolFunctionPackages",
    http_method = "GET",
    http_path = "/sol/vnfpkgm/v1/vnf_packages",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "functionPackages"),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$list_sol_function_packages_input(maxResults = maxResults, nextToken = nextToken)
  output <- .telconetworkbuilder$list_sol_function_packages_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$list_sol_function_packages <- telconetworkbuilder_list_sol_function_packages

#' Lists your network instances
#'
#' @description
#' Lists your network instances.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_sol_network_instances/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_sol_network_instances/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_list_sol_network_instances
telconetworkbuilder_list_sol_network_instances <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSolNetworkInstances",
    http_method = "GET",
    http_path = "/sol/nslcm/v1/ns_instances",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "networkInstances"),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$list_sol_network_instances_input(maxResults = maxResults, nextToken = nextToken)
  output <- .telconetworkbuilder$list_sol_network_instances_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$list_sol_network_instances <- telconetworkbuilder_list_sol_network_instances

#' Lists details for a network operation, including when the operation
#' started and the status of the operation
#'
#' @description
#' Lists details for a network operation, including when the operation started and the status of the operation.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_sol_network_operations/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_sol_network_operations/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token for the next page of results.
#' @param nsInstanceId Network instance id filter, to retrieve network operations associated to
#' a network instance.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_list_sol_network_operations
telconetworkbuilder_list_sol_network_operations <- function(maxResults = NULL, nextToken = NULL, nsInstanceId = NULL) {
  op <- new_operation(
    name = "ListSolNetworkOperations",
    http_method = "GET",
    http_path = "/sol/nslcm/v1/ns_lcm_op_occs",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "networkOperations"),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$list_sol_network_operations_input(maxResults = maxResults, nextToken = nextToken, nsInstanceId = nsInstanceId)
  output <- .telconetworkbuilder$list_sol_network_operations_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$list_sol_network_operations <- telconetworkbuilder_list_sol_network_operations

#' Lists network packages
#'
#' @description
#' Lists network packages.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_sol_network_packages/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_sol_network_packages/) for full documentation.
#'
#' @param maxResults The maximum number of results to include in the response.
#' @param nextToken The token for the next page of results.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_list_sol_network_packages
telconetworkbuilder_list_sol_network_packages <- function(maxResults = NULL, nextToken = NULL) {
  op <- new_operation(
    name = "ListSolNetworkPackages",
    http_method = "GET",
    http_path = "/sol/nsd/v1/ns_descriptors",
    host_prefix = "",
    paginator = list(input_token = "nextToken", output_token = "nextToken", limit_key = "maxResults", result_key = "networkPackages"),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$list_sol_network_packages_input(maxResults = maxResults, nextToken = nextToken)
  output <- .telconetworkbuilder$list_sol_network_packages_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$list_sol_network_packages <- telconetworkbuilder_list_sol_network_packages

#' Lists tags for AWS TNB resources
#'
#' @description
#' Lists tags for AWS TNB resources.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_list_tags_for_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; Resource ARN.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_list_tags_for_resource
telconetworkbuilder_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .telconetworkbuilder$list_tags_for_resource_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$list_tags_for_resource <- telconetworkbuilder_list_tags_for_resource

#' Uploads the contents of a function package
#'
#' @description
#' Uploads the contents of a function package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_put_sol_function_package_content/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_put_sol_function_package_content/) for full documentation.
#'
#' @param contentType Function package content type.
#' @param file &#91;required&#93; Function package file.
#' @param vnfPkgId &#91;required&#93; Function package ID.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_put_sol_function_package_content
telconetworkbuilder_put_sol_function_package_content <- function(contentType = NULL, file, vnfPkgId) {
  op <- new_operation(
    name = "PutSolFunctionPackageContent",
    http_method = "PUT",
    http_path = "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}/package_content",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$put_sol_function_package_content_input(contentType = contentType, file = file, vnfPkgId = vnfPkgId)
  output <- .telconetworkbuilder$put_sol_function_package_content_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$put_sol_function_package_content <- telconetworkbuilder_put_sol_function_package_content

#' Uploads the contents of a network package
#'
#' @description
#' Uploads the contents of a network package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_put_sol_network_package_content/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_put_sol_network_package_content/) for full documentation.
#'
#' @param contentType Network package content type.
#' @param file &#91;required&#93; Network package file.
#' @param nsdInfoId &#91;required&#93; Network service descriptor info ID.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_put_sol_network_package_content
telconetworkbuilder_put_sol_network_package_content <- function(contentType = NULL, file, nsdInfoId) {
  op <- new_operation(
    name = "PutSolNetworkPackageContent",
    http_method = "PUT",
    http_path = "/sol/nsd/v1/ns_descriptors/{nsdInfoId}/nsd_content",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$put_sol_network_package_content_input(contentType = contentType, file = file, nsdInfoId = nsdInfoId)
  output <- .telconetworkbuilder$put_sol_network_package_content_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$put_sol_network_package_content <- telconetworkbuilder_put_sol_network_package_content

#' Tags an AWS TNB resource
#'
#' @description
#' Tags an AWS TNB resource.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_tag_resource/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_tag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; Resource ARN.
#' @param tags &#91;required&#93; A tag is a label that you assign to an Amazon Web Services resource.
#' Each tag consists of a key and an optional value. You can use tags to
#' search and filter your resources or track your Amazon Web Services
#' costs.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_tag_resource
telconetworkbuilder_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .telconetworkbuilder$tag_resource_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$tag_resource <- telconetworkbuilder_tag_resource

#' Terminates a network instance
#'
#' @description
#' Terminates a network instance.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_terminate_sol_network_instance/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_terminate_sol_network_instance/) for full documentation.
#'
#' @param nsInstanceId &#91;required&#93; ID of the network instance.
#' @param tags A tag is a label that you assign to an Amazon Web Services resource.
#' Each tag consists of a key and an optional value. When you use this API,
#' the tags are only applied to the network operation that is created.
#' These tags are not applied to the network instance. Use tags to search
#' and filter your resources or track your Amazon Web Services costs.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_terminate_sol_network_instance
telconetworkbuilder_terminate_sol_network_instance <- function(nsInstanceId, tags = NULL) {
  op <- new_operation(
    name = "TerminateSolNetworkInstance",
    http_method = "POST",
    http_path = "/sol/nslcm/v1/ns_instances/{nsInstanceId}/terminate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$terminate_sol_network_instance_input(nsInstanceId = nsInstanceId, tags = tags)
  output <- .telconetworkbuilder$terminate_sol_network_instance_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$terminate_sol_network_instance <- telconetworkbuilder_terminate_sol_network_instance

#' Untags an AWS TNB resource
#'
#' @description
#' Untags an AWS TNB resource.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_untag_resource/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_untag_resource/) for full documentation.
#'
#' @param resourceArn &#91;required&#93; Resource ARN.
#' @param tagKeys &#91;required&#93; Tag keys.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_untag_resource
telconetworkbuilder_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{resourceArn}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .telconetworkbuilder$untag_resource_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$untag_resource <- telconetworkbuilder_untag_resource

#' Updates the operational state of function package
#'
#' @description
#' Updates the operational state of function package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_update_sol_function_package/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_update_sol_function_package/) for full documentation.
#'
#' @param operationalState &#91;required&#93; Operational state of the function package.
#' @param vnfPkgId &#91;required&#93; ID of the function package.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_update_sol_function_package
telconetworkbuilder_update_sol_function_package <- function(operationalState, vnfPkgId) {
  op <- new_operation(
    name = "UpdateSolFunctionPackage",
    http_method = "PATCH",
    http_path = "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$update_sol_function_package_input(operationalState = operationalState, vnfPkgId = vnfPkgId)
  output <- .telconetworkbuilder$update_sol_function_package_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$update_sol_function_package <- telconetworkbuilder_update_sol_function_package

#' Update a network instance
#'
#' @description
#' Update a network instance.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_update_sol_network_instance/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_update_sol_network_instance/) for full documentation.
#'
#' @param modifyVnfInfoData Identifies the network function information parameters and/or the
#' configurable properties of the network function to be modified.
#' 
#' Include this property only if the update type is
#' `MODIFY_VNF_INFORMATION`.
#' @param nsInstanceId &#91;required&#93; ID of the network instance.
#' @param tags A tag is a label that you assign to an Amazon Web Services resource.
#' Each tag consists of a key and an optional value. When you use this API,
#' the tags are only applied to the network operation that is created.
#' These tags are not applied to the network instance. Use tags to search
#' and filter your resources or track your Amazon Web Services costs.
#' @param updateNs Identifies the network service descriptor and the configurable
#' properties of the descriptor, to be used for the update.
#' 
#' Include this property only if the update type is `UPDATE_NS`.
#' @param updateType &#91;required&#93; The type of update.
#' 
#' -   Use the `MODIFY_VNF_INFORMATION` update type, to update a specific
#'     network function configuration, in the network instance.
#' 
#' -   Use the `UPDATE_NS` update type, to update the network instance to a
#'     new network service descriptor.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_update_sol_network_instance
telconetworkbuilder_update_sol_network_instance <- function(modifyVnfInfoData = NULL, nsInstanceId, tags = NULL, updateNs = NULL, updateType) {
  op <- new_operation(
    name = "UpdateSolNetworkInstance",
    http_method = "POST",
    http_path = "/sol/nslcm/v1/ns_instances/{nsInstanceId}/update",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$update_sol_network_instance_input(modifyVnfInfoData = modifyVnfInfoData, nsInstanceId = nsInstanceId, tags = tags, updateNs = updateNs, updateType = updateType)
  output <- .telconetworkbuilder$update_sol_network_instance_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$update_sol_network_instance <- telconetworkbuilder_update_sol_network_instance

#' Updates the operational state of a network package
#'
#' @description
#' Updates the operational state of a network package.
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_update_sol_network_package/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_update_sol_network_package/) for full documentation.
#'
#' @param nsdInfoId &#91;required&#93; ID of the network service descriptor in the network package.
#' @param nsdOperationalState &#91;required&#93; Operational state of the network service descriptor in the network
#' package.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_update_sol_network_package
telconetworkbuilder_update_sol_network_package <- function(nsdInfoId, nsdOperationalState) {
  op <- new_operation(
    name = "UpdateSolNetworkPackage",
    http_method = "PATCH",
    http_path = "/sol/nsd/v1/ns_descriptors/{nsdInfoId}",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$update_sol_network_package_input(nsdInfoId = nsdInfoId, nsdOperationalState = nsdOperationalState)
  output <- .telconetworkbuilder$update_sol_network_package_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$update_sol_network_package <- telconetworkbuilder_update_sol_network_package

#' Validates function package content
#'
#' @description
#' Validates function package content. This can be used as a dry run before uploading function package content with [`put_sol_function_package_content`][telconetworkbuilder_put_sol_function_package_content].
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_validate_sol_function_package_content/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_validate_sol_function_package_content/) for full documentation.
#'
#' @param contentType Function package content type.
#' @param file &#91;required&#93; Function package file.
#' @param vnfPkgId &#91;required&#93; Function package ID.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_validate_sol_function_package_content
telconetworkbuilder_validate_sol_function_package_content <- function(contentType = NULL, file, vnfPkgId) {
  op <- new_operation(
    name = "ValidateSolFunctionPackageContent",
    http_method = "PUT",
    http_path = "/sol/vnfpkgm/v1/vnf_packages/{vnfPkgId}/package_content/validate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$validate_sol_function_package_content_input(contentType = contentType, file = file, vnfPkgId = vnfPkgId)
  output <- .telconetworkbuilder$validate_sol_function_package_content_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$validate_sol_function_package_content <- telconetworkbuilder_validate_sol_function_package_content

#' Validates network package content
#'
#' @description
#' Validates network package content. This can be used as a dry run before uploading network package content with [`put_sol_network_package_content`][telconetworkbuilder_put_sol_network_package_content].
#'
#' See [https://www.paws-r-sdk.com/docs/telconetworkbuilder_validate_sol_network_package_content/](https://www.paws-r-sdk.com/docs/telconetworkbuilder_validate_sol_network_package_content/) for full documentation.
#'
#' @param contentType Network package content type.
#' @param file &#91;required&#93; Network package file.
#' @param nsdInfoId &#91;required&#93; Network service descriptor file.
#'
#' @keywords internal
#'
#' @rdname telconetworkbuilder_validate_sol_network_package_content
telconetworkbuilder_validate_sol_network_package_content <- function(contentType = NULL, file, nsdInfoId) {
  op <- new_operation(
    name = "ValidateSolNetworkPackageContent",
    http_method = "PUT",
    http_path = "/sol/nsd/v1/ns_descriptors/{nsdInfoId}/nsd_content/validate",
    host_prefix = "",
    paginator = list(),
    stream_api = FALSE
  )
  input <- .telconetworkbuilder$validate_sol_network_package_content_input(contentType = contentType, file = file, nsdInfoId = nsdInfoId)
  output <- .telconetworkbuilder$validate_sol_network_package_content_output()
  config <- get_config()
  svc <- .telconetworkbuilder$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.telconetworkbuilder$operations$validate_sol_network_package_content <- telconetworkbuilder_validate_sol_network_package_content
