% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkfirewall_operations.R
\name{networkfirewall_put_resource_policy}
\alias{networkfirewall_put_resource_policy}
\title{Creates or updates an IAM policy for your rule group or firewall policy}
\usage{
networkfirewall_put_resource_policy(ResourceArn, Policy)
}
\arguments{
\item{ResourceArn}{[required] The Amazon Resource Name (ARN) of the account that you want to share
rule groups and firewall policies with.}

\item{Policy}{[required] The IAM policy statement that lists the accounts that you want to share
your rule group or firewall policy with and the operations that you want
the accounts to be able to perform.

For a rule group resource, you can specify the following operations in
the Actions section of the statement:
\itemize{
\item network-firewall:CreateFirewallPolicy
\item network-firewall:UpdateFirewallPolicy
\item network-firewall:ListRuleGroups
}

For a firewall policy resource, you can specify the following operations
in the Actions section of the statement:
\itemize{
\item network-firewall:AssociateFirewallPolicy
\item network-firewall:ListFirewallPolicies
}

In the Resource section of the statement, you specify the ARNs for the
rule groups and firewall policies that you want to share with the
account that you specified in \code{Arn}.}
}
\description{
Creates or updates an IAM policy for your rule group or firewall policy. Use this to share rule groups and firewall policies between accounts. This operation works in conjunction with the Amazon Web Services Resource Access Manager (RAM) service to manage resource sharing for Network Firewall.

See \url{https://www.paws-r-sdk.com/docs/networkfirewall_put_resource_policy/} for full documentation.
}
\keyword{internal}
