% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_create_outpost_resolver}
\alias{route53resolver_create_outpost_resolver}
\title{Creates an Route 53 Resolver on an Outpost}
\usage{
route53resolver_create_outpost_resolver(
  CreatorRequestId,
  Name,
  InstanceCount = NULL,
  PreferredInstanceType,
  OutpostArn,
  Tags = NULL
)
}
\arguments{
\item{CreatorRequestId}{[required] A unique string that identifies the request and that allows failed
requests to be retried without the risk of running the operation twice.

\code{CreatorRequestId} can be any unique string, for example, a date/time
stamp.}

\item{Name}{[required] A friendly name that lets you easily find a configuration in the
Resolver dashboard in the Route 53 console.}

\item{InstanceCount}{Number of Amazon EC2 instances for the Resolver on Outpost. The default
and minimal value is 4.}

\item{PreferredInstanceType}{[required] The Amazon EC2 instance type. If you specify this, you must also specify
a value for the \code{OutpostArn}.}

\item{OutpostArn}{[required] The Amazon Resource Name (ARN) of the Outpost. If you specify this, you
must also specify a value for the \code{PreferredInstanceType}.}

\item{Tags}{A string that helps identify the Route 53 Resolvers on Outpost.}
}
\description{
Creates an Route 53 Resolver on an Outpost.

See \url{https://www.paws-r-sdk.com/docs/route53resolver_create_outpost_resolver/} for full documentation.
}
\keyword{internal}
