# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include route53recoverycontrolconfig_service.R
NULL

#' Create a new cluster
#'
#' @description
#' Create a new cluster. A cluster is a set of redundant Regional endpoints against which you can run API calls to update or get the state of one or more routing controls. Each cluster has a name, status, Amazon Resource Name (ARN), and an array of the five cluster endpoints (one for each supported Amazon Web Services Region) that you can use with API calls to the cluster data plane.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_create_cluster/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_create_cluster/) for full documentation.
#'
#' @param ClientToken A unique, case-sensitive string of up to 64 ASCII characters. To make an
#' idempotent API request with an action, specify a client token in the
#' request.
#' @param ClusterName &#91;required&#93; The name of the cluster.
#' @param Tags The tags associated with the cluster.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_create_cluster
route53recoverycontrolconfig_create_cluster <- function(ClientToken = NULL, ClusterName, Tags = NULL) {
  op <- new_operation(
    name = "CreateCluster",
    http_method = "POST",
    http_path = "/cluster",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$create_cluster_input(ClientToken = ClientToken, ClusterName = ClusterName, Tags = Tags)
  output <- .route53recoverycontrolconfig$create_cluster_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$create_cluster <- route53recoverycontrolconfig_create_cluster

#' Creates a new control panel
#'
#' @description
#' Creates a new control panel. A control panel represents a group of routing controls that can be changed together in a single transaction. You can use a control panel to centrally view the operational status of applications across your organization, and trigger multi-app failovers in a single transaction, for example, to fail over an Availability Zone or Amazon Web Services Region.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_create_control_panel/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_create_control_panel/) for full documentation.
#'
#' @param ClientToken A unique, case-sensitive string of up to 64 ASCII characters. To make an
#' idempotent API request with an action, specify a client token in the
#' request.
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster for the control panel.
#' @param ControlPanelName &#91;required&#93; The name of the control panel.
#' @param Tags The tags associated with the control panel.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_create_control_panel
route53recoverycontrolconfig_create_control_panel <- function(ClientToken = NULL, ClusterArn, ControlPanelName, Tags = NULL) {
  op <- new_operation(
    name = "CreateControlPanel",
    http_method = "POST",
    http_path = "/controlpanel",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$create_control_panel_input(ClientToken = ClientToken, ClusterArn = ClusterArn, ControlPanelName = ControlPanelName, Tags = Tags)
  output <- .route53recoverycontrolconfig$create_control_panel_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$create_control_panel <- route53recoverycontrolconfig_create_control_panel

#' Creates a new routing control
#'
#' @description
#' Creates a new routing control.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_create_routing_control/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_create_routing_control/) for full documentation.
#'
#' @param ClientToken A unique, case-sensitive string of up to 64 ASCII characters. To make an
#' idempotent API request with an action, specify a client token in the
#' request.
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster that includes the routing
#' control.
#' @param ControlPanelArn The Amazon Resource Name (ARN) of the control panel that includes the
#' routing control.
#' @param RoutingControlName &#91;required&#93; The name of the routing control.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_create_routing_control
route53recoverycontrolconfig_create_routing_control <- function(ClientToken = NULL, ClusterArn, ControlPanelArn = NULL, RoutingControlName) {
  op <- new_operation(
    name = "CreateRoutingControl",
    http_method = "POST",
    http_path = "/routingcontrol",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$create_routing_control_input(ClientToken = ClientToken, ClusterArn = ClusterArn, ControlPanelArn = ControlPanelArn, RoutingControlName = RoutingControlName)
  output <- .route53recoverycontrolconfig$create_routing_control_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$create_routing_control <- route53recoverycontrolconfig_create_routing_control

#' Creates a safety rule in a control panel
#'
#' @description
#' Creates a safety rule in a control panel. Safety rules let you add safeguards around changing routing control states, and for enabling and disabling routing controls, to help prevent unexpected outcomes.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_create_safety_rule/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_create_safety_rule/) for full documentation.
#'
#' @param AssertionRule The assertion rule requested.
#' @param ClientToken A unique, case-sensitive string of up to 64 ASCII characters. To make an
#' idempotent API request with an action, specify a client token in the
#' request.
#' @param GatingRule The gating rule requested.
#' @param Tags The tags associated with the safety rule.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_create_safety_rule
route53recoverycontrolconfig_create_safety_rule <- function(AssertionRule = NULL, ClientToken = NULL, GatingRule = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateSafetyRule",
    http_method = "POST",
    http_path = "/safetyrule",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$create_safety_rule_input(AssertionRule = AssertionRule, ClientToken = ClientToken, GatingRule = GatingRule, Tags = Tags)
  output <- .route53recoverycontrolconfig$create_safety_rule_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$create_safety_rule <- route53recoverycontrolconfig_create_safety_rule

#' Delete a cluster
#'
#' @description
#' Delete a cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_delete_cluster/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_delete_cluster/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster that you're deleting.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_delete_cluster
route53recoverycontrolconfig_delete_cluster <- function(ClusterArn) {
  op <- new_operation(
    name = "DeleteCluster",
    http_method = "DELETE",
    http_path = "/cluster/{ClusterArn}",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$delete_cluster_input(ClusterArn = ClusterArn)
  output <- .route53recoverycontrolconfig$delete_cluster_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$delete_cluster <- route53recoverycontrolconfig_delete_cluster

#' Deletes a control panel
#'
#' @description
#' Deletes a control panel.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_delete_control_panel/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_delete_control_panel/) for full documentation.
#'
#' @param ControlPanelArn &#91;required&#93; The Amazon Resource Name (ARN) of the control panel.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_delete_control_panel
route53recoverycontrolconfig_delete_control_panel <- function(ControlPanelArn) {
  op <- new_operation(
    name = "DeleteControlPanel",
    http_method = "DELETE",
    http_path = "/controlpanel/{ControlPanelArn}",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$delete_control_panel_input(ControlPanelArn = ControlPanelArn)
  output <- .route53recoverycontrolconfig$delete_control_panel_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$delete_control_panel <- route53recoverycontrolconfig_delete_control_panel

#' Deletes a routing control
#'
#' @description
#' Deletes a routing control.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_delete_routing_control/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_delete_routing_control/) for full documentation.
#'
#' @param RoutingControlArn &#91;required&#93; The Amazon Resource Name (ARN) of the routing control that you're
#' deleting.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_delete_routing_control
route53recoverycontrolconfig_delete_routing_control <- function(RoutingControlArn) {
  op <- new_operation(
    name = "DeleteRoutingControl",
    http_method = "DELETE",
    http_path = "/routingcontrol/{RoutingControlArn}",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$delete_routing_control_input(RoutingControlArn = RoutingControlArn)
  output <- .route53recoverycontrolconfig$delete_routing_control_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$delete_routing_control <- route53recoverycontrolconfig_delete_routing_control

#' Deletes a safety rule
#'
#' @description
#' Deletes a safety rule.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_delete_safety_rule/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_delete_safety_rule/) for full documentation.
#'
#' @param SafetyRuleArn &#91;required&#93; The ARN of the safety rule.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_delete_safety_rule
route53recoverycontrolconfig_delete_safety_rule <- function(SafetyRuleArn) {
  op <- new_operation(
    name = "DeleteSafetyRule",
    http_method = "DELETE",
    http_path = "/safetyrule/{SafetyRuleArn}",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$delete_safety_rule_input(SafetyRuleArn = SafetyRuleArn)
  output <- .route53recoverycontrolconfig$delete_safety_rule_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$delete_safety_rule <- route53recoverycontrolconfig_delete_safety_rule

#' Display the details about a cluster
#'
#' @description
#' Display the details about a cluster. The response includes the cluster name, endpoints, status, and Amazon Resource Name (ARN).
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_describe_cluster/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_describe_cluster/) for full documentation.
#'
#' @param ClusterArn &#91;required&#93; The Amazon Resource Name (ARN) of the cluster.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_describe_cluster
route53recoverycontrolconfig_describe_cluster <- function(ClusterArn) {
  op <- new_operation(
    name = "DescribeCluster",
    http_method = "GET",
    http_path = "/cluster/{ClusterArn}",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$describe_cluster_input(ClusterArn = ClusterArn)
  output <- .route53recoverycontrolconfig$describe_cluster_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$describe_cluster <- route53recoverycontrolconfig_describe_cluster

#' Displays details about a control panel
#'
#' @description
#' Displays details about a control panel.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_describe_control_panel/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_describe_control_panel/) for full documentation.
#'
#' @param ControlPanelArn &#91;required&#93; The Amazon Resource Name (ARN) of the control panel.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_describe_control_panel
route53recoverycontrolconfig_describe_control_panel <- function(ControlPanelArn) {
  op <- new_operation(
    name = "DescribeControlPanel",
    http_method = "GET",
    http_path = "/controlpanel/{ControlPanelArn}",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$describe_control_panel_input(ControlPanelArn = ControlPanelArn)
  output <- .route53recoverycontrolconfig$describe_control_panel_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$describe_control_panel <- route53recoverycontrolconfig_describe_control_panel

#' Displays details about a routing control
#'
#' @description
#' Displays details about a routing control. A routing control has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_describe_routing_control/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_describe_routing_control/) for full documentation.
#'
#' @param RoutingControlArn &#91;required&#93; The Amazon Resource Name (ARN) of the routing control.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_describe_routing_control
route53recoverycontrolconfig_describe_routing_control <- function(RoutingControlArn) {
  op <- new_operation(
    name = "DescribeRoutingControl",
    http_method = "GET",
    http_path = "/routingcontrol/{RoutingControlArn}",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$describe_routing_control_input(RoutingControlArn = RoutingControlArn)
  output <- .route53recoverycontrolconfig$describe_routing_control_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$describe_routing_control <- route53recoverycontrolconfig_describe_routing_control

#' Returns information about a safety rule
#'
#' @description
#' Returns information about a safety rule.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_describe_safety_rule/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_describe_safety_rule/) for full documentation.
#'
#' @param SafetyRuleArn &#91;required&#93; The ARN of the safety rule.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_describe_safety_rule
route53recoverycontrolconfig_describe_safety_rule <- function(SafetyRuleArn) {
  op <- new_operation(
    name = "DescribeSafetyRule",
    http_method = "GET",
    http_path = "/safetyrule/{SafetyRuleArn}",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$describe_safety_rule_input(SafetyRuleArn = SafetyRuleArn)
  output <- .route53recoverycontrolconfig$describe_safety_rule_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$describe_safety_rule <- route53recoverycontrolconfig_describe_safety_rule

#' Returns an array of all Amazon Route 53 health checks associated with a
#' specific routing control
#'
#' @description
#' Returns an array of all Amazon Route 53 health checks associated with a specific routing control.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_associated_route_53_health_checks/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_associated_route_53_health_checks/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#' @param RoutingControlArn &#91;required&#93; The Amazon Resource Name (ARN) of the routing control.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_lis_ass_rou_53_hea_che
route53recoverycontrolconfig_list_associated_route_53_health_checks <- function(MaxResults = NULL, NextToken = NULL, RoutingControlArn) {
  op <- new_operation(
    name = "ListAssociatedRoute53HealthChecks",
    http_method = "GET",
    http_path = "/routingcontrol/{RoutingControlArn}/associatedRoute53HealthChecks",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$list_associated_route_53_health_checks_input(MaxResults = MaxResults, NextToken = NextToken, RoutingControlArn = RoutingControlArn)
  output <- .route53recoverycontrolconfig$list_associated_route_53_health_checks_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$list_associated_route_53_health_checks <- route53recoverycontrolconfig_list_associated_route_53_health_checks

#' Returns an array of all the clusters in an account
#'
#' @description
#' Returns an array of all the clusters in an account.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_clusters/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_clusters/) for full documentation.
#'
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_list_clusters
route53recoverycontrolconfig_list_clusters <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListClusters",
    http_method = "GET",
    http_path = "/cluster",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$list_clusters_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53recoverycontrolconfig$list_clusters_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$list_clusters <- route53recoverycontrolconfig_list_clusters

#' Returns an array of control panels in an account or in a cluster
#'
#' @description
#' Returns an array of control panels in an account or in a cluster.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_control_panels/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_control_panels/) for full documentation.
#'
#' @param ClusterArn The Amazon Resource Name (ARN) of a cluster.
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_list_control_panels
route53recoverycontrolconfig_list_control_panels <- function(ClusterArn = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListControlPanels",
    http_method = "GET",
    http_path = "/controlpanels",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$list_control_panels_input(ClusterArn = ClusterArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53recoverycontrolconfig$list_control_panels_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$list_control_panels <- route53recoverycontrolconfig_list_control_panels

#' Returns an array of routing controls for a control panel
#'
#' @description
#' Returns an array of routing controls for a control panel. A routing control is an Amazon Route 53 Application Recovery Controller construct that has one of two states: ON and OFF. You can map the routing control state to the state of an Amazon Route 53 health check, which can be used to control routing.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_routing_controls/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_routing_controls/) for full documentation.
#'
#' @param ControlPanelArn &#91;required&#93; The Amazon Resource Name (ARN) of the control panel.
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_list_routing_controls
route53recoverycontrolconfig_list_routing_controls <- function(ControlPanelArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListRoutingControls",
    http_method = "GET",
    http_path = "/controlpanel/{ControlPanelArn}/routingcontrols",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$list_routing_controls_input(ControlPanelArn = ControlPanelArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53recoverycontrolconfig$list_routing_controls_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$list_routing_controls <- route53recoverycontrolconfig_list_routing_controls

#' List the safety rules (the assertion rules and gating rules) that you've
#' defined for the routing controls in a control panel
#'
#' @description
#' List the safety rules (the assertion rules and gating rules) that you've defined for the routing controls in a control panel.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_safety_rules/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_safety_rules/) for full documentation.
#'
#' @param ControlPanelArn &#91;required&#93; The Amazon Resource Name (ARN) of the control panel.
#' @param MaxResults The number of objects that you want to return with this call.
#' @param NextToken The token that identifies which batch of results you want to see.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_list_safety_rules
route53recoverycontrolconfig_list_safety_rules <- function(ControlPanelArn, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListSafetyRules",
    http_method = "GET",
    http_path = "/controlpanel/{ControlPanelArn}/safetyrules",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$list_safety_rules_input(ControlPanelArn = ControlPanelArn, MaxResults = MaxResults, NextToken = NextToken)
  output <- .route53recoverycontrolconfig$list_safety_rules_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$list_safety_rules <- route53recoverycontrolconfig_list_safety_rules

#' Lists the tags for a resource
#'
#' @description
#' Lists the tags for a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_tags_for_resource/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_list_tags_for_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that's tagged.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_list_tags_for_resource
route53recoverycontrolconfig_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .route53recoverycontrolconfig$list_tags_for_resource_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$list_tags_for_resource <- route53recoverycontrolconfig_list_tags_for_resource

#' Adds a tag to a resource
#'
#' @description
#' Adds a tag to a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_tag_resource/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_tag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that's tagged.
#' @param Tags &#91;required&#93; The tags associated with the resource.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_tag_resource
route53recoverycontrolconfig_tag_resource <- function(ResourceArn, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .route53recoverycontrolconfig$tag_resource_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$tag_resource <- route53recoverycontrolconfig_tag_resource

#' Removes a tag from a resource
#'
#' @description
#' Removes a tag from a resource.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_untag_resource/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_untag_resource/) for full documentation.
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) for the resource that's tagged.
#' @param TagKeys &#91;required&#93; Keys for the tags to be removed.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_untag_resource
route53recoverycontrolconfig_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/tags/{ResourceArn}",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .route53recoverycontrolconfig$untag_resource_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$untag_resource <- route53recoverycontrolconfig_untag_resource

#' Updates a control panel
#'
#' @description
#' Updates a control panel. The only update you can make to a control panel is to change the name of the control panel.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_update_control_panel/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_update_control_panel/) for full documentation.
#'
#' @param ControlPanelArn &#91;required&#93; The Amazon Resource Name (ARN) of the control panel.
#' @param ControlPanelName &#91;required&#93; The name of the control panel.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_update_control_panel
route53recoverycontrolconfig_update_control_panel <- function(ControlPanelArn, ControlPanelName) {
  op <- new_operation(
    name = "UpdateControlPanel",
    http_method = "PUT",
    http_path = "/controlpanel",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$update_control_panel_input(ControlPanelArn = ControlPanelArn, ControlPanelName = ControlPanelName)
  output <- .route53recoverycontrolconfig$update_control_panel_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$update_control_panel <- route53recoverycontrolconfig_update_control_panel

#' Updates a routing control
#'
#' @description
#' Updates a routing control. You can only update the name of the routing control. To get or update the routing control state, see the Recovery Cluster (data plane) API actions for Amazon Route 53 Application Recovery Controller.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_update_routing_control/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_update_routing_control/) for full documentation.
#'
#' @param RoutingControlArn &#91;required&#93; The Amazon Resource Name (ARN) of the routing control.
#' @param RoutingControlName &#91;required&#93; The name of the routing control.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_update_routing_control
route53recoverycontrolconfig_update_routing_control <- function(RoutingControlArn, RoutingControlName) {
  op <- new_operation(
    name = "UpdateRoutingControl",
    http_method = "PUT",
    http_path = "/routingcontrol",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$update_routing_control_input(RoutingControlArn = RoutingControlArn, RoutingControlName = RoutingControlName)
  output <- .route53recoverycontrolconfig$update_routing_control_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$update_routing_control <- route53recoverycontrolconfig_update_routing_control

#' Update a safety rule (an assertion rule or gating rule)
#'
#' @description
#' Update a safety rule (an assertion rule or gating rule). You can only update the name and the waiting period for a safety rule. To make other updates, delete the safety rule and create a new one.
#'
#' See [https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_update_safety_rule/](https://www.paws-r-sdk.com/docs/route53recoverycontrolconfig_update_safety_rule/) for full documentation.
#'
#' @param AssertionRuleUpdate The assertion rule to update.
#' @param GatingRuleUpdate The gating rule to update.
#'
#' @keywords internal
#'
#' @rdname route53recoverycontrolconfig_update_safety_rule
route53recoverycontrolconfig_update_safety_rule <- function(AssertionRuleUpdate = NULL, GatingRuleUpdate = NULL) {
  op <- new_operation(
    name = "UpdateSafetyRule",
    http_method = "PUT",
    http_path = "/safetyrule",
    paginator = list()
  )
  input <- .route53recoverycontrolconfig$update_safety_rule_input(AssertionRuleUpdate = AssertionRuleUpdate, GatingRuleUpdate = GatingRuleUpdate)
  output <- .route53recoverycontrolconfig$update_safety_rule_output()
  config <- get_config()
  svc <- .route53recoverycontrolconfig$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.route53recoverycontrolconfig$operations$update_safety_rule <- route53recoverycontrolconfig_update_safety_rule
