% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_create_custom_routing_accelerator}
\alias{globalaccelerator_create_custom_routing_accelerator}
\title{Create a custom routing accelerator}
\usage{
globalaccelerator_create_custom_routing_accelerator(
  Name,
  IpAddressType = NULL,
  IpAddresses = NULL,
  Enabled = NULL,
  IdempotencyToken,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of a custom routing accelerator. The name can have a maximum of
64 characters, must contain only alphanumeric characters or hyphens (-),
and must not begin or end with a hyphen.}

\item{IpAddressType}{The IP address type that an accelerator supports. For a custom routing
accelerator, the value must be IPV4.}

\item{IpAddresses}{Optionally, if you've added your own IP address pool to Global
Accelerator (BYOIP), you can choose an IPv4 address from your own pool
to use for the accelerator's static IPv4 address when you create an
accelerator.

After you bring an address range to Amazon Web Services, it appears in
your account as an address pool. When you create an accelerator, you can
assign one IPv4 address from your range to it. Global Accelerator
assigns you a second static IPv4 address from an Amazon IP address
range. If you bring two IPv4 address ranges to Amazon Web Services, you
can assign one IPv4 address from each range to your accelerator. This
restriction is because Global Accelerator assigns each address range to
a different network zone, for high availability.

You can specify one or two addresses, separated by a space. Do not
include the /32 suffix.

Note that you can't update IP addresses for an existing accelerator. To
change them, you must create a new accelerator with the new addresses.

For more information, see \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/using-byoip.html}{Bring your own IP addresses (BYOIP)}
in the \emph{Global Accelerator Developer Guide}.}

\item{Enabled}{Indicates whether an accelerator is enabled. The value is true or false.
The default value is true.

If the value is set to true, an accelerator cannot be deleted. If set to
false, the accelerator can be deleted.}

\item{IdempotencyToken}{[required] A unique, case-sensitive identifier that you provide to ensure the
idempotency—that is, the uniqueness—of the request.}

\item{Tags}{Create tags for an accelerator.

For more information, see \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html}{Tagging in Global Accelerator}
in the \emph{Global Accelerator Developer Guide}.}
}
\description{
Create a custom routing accelerator. A custom routing accelerator directs traffic to one of possibly thousands of Amazon EC2 instance destinations running in a single or multiple virtual private clouds (VPC) subnet endpoints.

See \url{https://paws-r.github.io/docs/globalaccelerator/create_custom_routing_accelerator.html} for full documentation.
}
\keyword{internal}
