% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigateway_operations.R
\name{apigateway_create_vpc_link}
\alias{apigateway_create_vpc_link}
\title{Creates a VPC link, under the caller's account in a selected region, in
an asynchronous operation that typically takes 2-4 minutes to complete
and become operational}
\usage{
apigateway_create_vpc_link(name, description, targetArns, tags)
}
\arguments{
\item{name}{[required] [Required] The name used to label and identify the VPC link.}

\item{description}{The description of the VPC link.}

\item{targetArns}{[required] [Required] The ARN of the network load balancer of the VPC targeted by
the VPC link. The network load balancer must be owned by the same AWS
account of the API owner.}

\item{tags}{The key-value map of strings. The valid character set is
[a-zA-Z+-=.\\_:/]. The tag key can be up to 128 characters and must not
start with \verb{aws:}. The tag value can be up to 256 characters.}
}
\description{
Creates a VPC link, under the caller\'s account in a selected region, in
an asynchronous operation that typically takes 2-4 minutes to complete
and become operational. The caller must have permissions to create and
update VPC Endpoint services.
}
\section{Request syntax}{
\preformatted{svc$create_vpc_link(
  name = "string",
  description = "string",
  targetArns = list(
    "string"
  ),
  tags = list(
    "string"
  )
)
}
}

\keyword{internal}
