% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_describe_load_balancers}
\alias{elbv2_describe_load_balancers}
\title{Describes the specified load balancers or all of your load balancers}
\usage{
elbv2_describe_load_balancers(LoadBalancerArns, Names, Marker, PageSize)
}
\arguments{
\item{LoadBalancerArns}{The Amazon Resource Names (ARN) of the load balancers. You can specify
up to 20 load balancers in a single call.}

\item{Names}{The names of the load balancers.}

\item{Marker}{The marker for the next set of results. (You received this marker from a
previous call.)}

\item{PageSize}{The maximum number of results to return with this call.}
}
\description{
Describes the specified load balancers or all of your load balancers.
}
\details{
To describe the listeners for a load balancer, use DescribeListeners. To
describe the attributes for a load balancer, use
DescribeLoadBalancerAttributes.
}
\section{Request syntax}{
\preformatted{svc$describe_load_balancers(
  LoadBalancerArns = list(
    "string"
  ),
  Names = list(
    "string"
  ),
  Marker = "string",
  PageSize = 123
)
}
}

\examples{
# This example describes the specified load balancer.
\dontrun{svc$describe_load_balancers(
  LoadBalancerArns = list(
    "arn:aws:elasticloadbalancing:us-west-2:123456789012:loadbalancer/app/my-load-balancer/5..."
  )
)}

}
\keyword{internal}
