% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/apigatewayv2_operations.R
\name{apigatewayv2_create_api}
\alias{apigatewayv2_create_api}
\title{Creates an Api resource}
\usage{
apigatewayv2_create_api(ApiKeySelectionExpression, Description,
  DisableSchemaValidation, Name, ProtocolType, RouteSelectionExpression,
  Version, Tags)
}
\arguments{
\item{ApiKeySelectionExpression}{An API key selection expression. See \href{https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions}{API Key Selection Expressions}.}

\item{Description}{The description of the API.}

\item{DisableSchemaValidation}{Avoid validating models when creating a deployment.}

\item{Name}{[required] The name of the API.}

\item{ProtocolType}{[required] The API protocol: Currently only WEBSOCKET is supported.}

\item{RouteSelectionExpression}{[required] The route selection expression for the API.}

\item{Version}{A version identifier for the API.}

\item{Tags}{The key-value map of strings. The valid character set is
[a-zA-Z+-=.\_:/]. The tag key can be up to 128 characters and must not
start with aws:. The tag value can be up to 256 characters..}
}
\description{
Creates an Api resource.
}
\section{Request syntax}{
\preformatted{svc$create_api(
  ApiKeySelectionExpression = "string",
  Description = "string",
  DisableSchemaValidation = TRUE|FALSE,
  Name = "string",
  ProtocolType = "WEBSOCKET",
  RouteSelectionExpression = "string",
  Version = "string",
  Tags = list(
    "string"
  )
)
}
}

\keyword{internal}
