# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_operation new_request send_request
#' @include apigatewayv2_service.R
NULL

#' Creates an Api resource
#'
#' Creates an Api resource.
#'
#' @usage
#' apigatewayv2_create_api(ApiKeySelectionExpression, Description,
#'   DisableSchemaValidation, Name, ProtocolType, RouteSelectionExpression,
#'   Version, Tags)
#'
#' @param ApiKeySelectionExpression An API key selection expression. See [API Key Selection
#' Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
#' @param Description The description of the API.
#' @param DisableSchemaValidation Avoid validating models when creating a deployment.
#' @param Name &#91;required&#93; The name of the API.
#' @param ProtocolType &#91;required&#93; The API protocol: Currently only WEBSOCKET is supported.
#' @param RouteSelectionExpression &#91;required&#93; The route selection expression for the API.
#' @param Version A version identifier for the API.
#' @param Tags The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=.\\_:/\]. The tag key can be up to 128 characters and must not
#' start with aws:. The tag value can be up to 256 characters..
#'
#' @section Request syntax:
#' ```
#' svc$create_api(
#'   ApiKeySelectionExpression = "string",
#'   Description = "string",
#'   DisableSchemaValidation = TRUE|FALSE,
#'   Name = "string",
#'   ProtocolType = "WEBSOCKET",
#'   RouteSelectionExpression = "string",
#'   Version = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_api
apigatewayv2_create_api <- function(ApiKeySelectionExpression = NULL, Description = NULL, DisableSchemaValidation = NULL, Name, ProtocolType, RouteSelectionExpression, Version = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateApi",
    http_method = "POST",
    http_path = "/v2/apis",
    paginator = list()
  )
  input <- .apigatewayv2$create_api_input(ApiKeySelectionExpression = ApiKeySelectionExpression, Description = Description, DisableSchemaValidation = DisableSchemaValidation, Name = Name, ProtocolType = ProtocolType, RouteSelectionExpression = RouteSelectionExpression, Version = Version, Tags = Tags)
  output <- .apigatewayv2$create_api_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_api <- apigatewayv2_create_api

#' Creates an API mapping
#'
#' Creates an API mapping.
#'
#' @usage
#' apigatewayv2_create_api_mapping(ApiId, ApiMappingKey, DomainName, Stage)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ApiMappingKey 
#' @param DomainName &#91;required&#93; The domain name.
#' @param Stage &#91;required&#93; The API stage.
#'
#' @section Request syntax:
#' ```
#' svc$create_api_mapping(
#'   ApiId = "string",
#'   ApiMappingKey = "string",
#'   DomainName = "string",
#'   Stage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_api_mapping
apigatewayv2_create_api_mapping <- function(ApiId, ApiMappingKey = NULL, DomainName, Stage) {
  op <- new_operation(
    name = "CreateApiMapping",
    http_method = "POST",
    http_path = "/v2/domainnames/{domainName}/apimappings",
    paginator = list()
  )
  input <- .apigatewayv2$create_api_mapping_input(ApiId = ApiId, ApiMappingKey = ApiMappingKey, DomainName = DomainName, Stage = Stage)
  output <- .apigatewayv2$create_api_mapping_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_api_mapping <- apigatewayv2_create_api_mapping

#' Creates an Authorizer for an API
#'
#' Creates an Authorizer for an API.
#'
#' @usage
#' apigatewayv2_create_authorizer(ApiId, AuthorizerCredentialsArn,
#'   AuthorizerResultTtlInSeconds, AuthorizerType, AuthorizerUri,
#'   IdentitySource, IdentityValidationExpression, Name, ProviderArns)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param AuthorizerCredentialsArn Specifies the required credentials as an IAM role for API Gateway to
#' invoke the authorizer. To specify an IAM role for API Gateway to assume,
#' use the role\'s Amazon Resource Name (ARN). To use resource-based
#' permissions on the Lambda function, specify null.
#' @param AuthorizerResultTtlInSeconds The time to live (TTL), in seconds, of cached authorizer results. If it
#' equals 0, authorization caching is disabled. If it is greater than 0,
#' API Gateway will cache authorizer responses. If this field is not set,
#' the default value is 300. The maximum value is 3600, or 1 hour.
#' @param AuthorizerType &#91;required&#93; The authorizer type. Currently the only valid value is REQUEST, for a
#' Lambda function using incoming request parameters.
#' @param AuthorizerUri &#91;required&#93; The authorizer\'s Uniform Resource Identifier (URI). For REQUEST
#' authorizers, this must be a well-formed Lambda function URI, for
#' example,
#' arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:\{account\\_id\}:function:\{lambda\\_function\\_name\}/invocations.
#' In general, the URI has this form:
#' arn:aws:apigateway:\{region\}:lambda:path/\{service\\_api\} , where \{region\}
#' is the same as the region hosting the Lambda function, path indicates
#' that the remaining substring in the URI should be treated as the path to
#' the resource, including the initial /. For Lambda functions, this is
#' usually of the form /2015-03-31/functions/\[FunctionARN\]/invocations.
#' @param IdentitySource &#91;required&#93; The identity source for which authorization is requested.
#' 
#' For the REQUEST authorizer, this is required when authorization caching
#' is enabled. The value is a comma-separated string of one or more mapping
#' expressions of the specified request parameters. For example, if an Auth
#' header and a Name query string parameters are defined as identity
#' sources, this value is method.request.header.Auth,
#' method.request.querystring.Name. These parameters will be used to derive
#' the authorization caching key and to perform runtime validation of the
#' REQUEST authorizer by verifying all of the identity-related request
#' parameters are present, not null, and non-empty. Only when this is true
#' does the authorizer invoke the authorizer Lambda function, otherwise, it
#' returns a 401 Unauthorized response without calling the Lambda function.
#' The valid value is a string of comma-separated mapping expressions of
#' the specified request parameters. When the authorization caching is not
#' enabled, this property is optional.
#' @param IdentityValidationExpression The validation expression does not apply to the REQUEST authorizer.
#' @param Name &#91;required&#93; The name of the authorizer.
#' @param ProviderArns For REQUEST authorizer, this is not defined.
#'
#' @section Request syntax:
#' ```
#' svc$create_authorizer(
#'   ApiId = "string",
#'   AuthorizerCredentialsArn = "string",
#'   AuthorizerResultTtlInSeconds = 123,
#'   AuthorizerType = "REQUEST",
#'   AuthorizerUri = "string",
#'   IdentitySource = list(
#'     "string"
#'   ),
#'   IdentityValidationExpression = "string",
#'   Name = "string",
#'   ProviderArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_authorizer
apigatewayv2_create_authorizer <- function(ApiId, AuthorizerCredentialsArn = NULL, AuthorizerResultTtlInSeconds = NULL, AuthorizerType, AuthorizerUri, IdentitySource, IdentityValidationExpression = NULL, Name, ProviderArns = NULL) {
  op <- new_operation(
    name = "CreateAuthorizer",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/authorizers",
    paginator = list()
  )
  input <- .apigatewayv2$create_authorizer_input(ApiId = ApiId, AuthorizerCredentialsArn = AuthorizerCredentialsArn, AuthorizerResultTtlInSeconds = AuthorizerResultTtlInSeconds, AuthorizerType = AuthorizerType, AuthorizerUri = AuthorizerUri, IdentitySource = IdentitySource, IdentityValidationExpression = IdentityValidationExpression, Name = Name, ProviderArns = ProviderArns)
  output <- .apigatewayv2$create_authorizer_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_authorizer <- apigatewayv2_create_authorizer

#' Creates a Deployment for an API
#'
#' Creates a Deployment for an API.
#'
#' @usage
#' apigatewayv2_create_deployment(ApiId, Description, StageName)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param Description The description for the deployment resource.
#' @param StageName The name of the Stage resource for the Deployment resource to create.
#'
#' @section Request syntax:
#' ```
#' svc$create_deployment(
#'   ApiId = "string",
#'   Description = "string",
#'   StageName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_deployment
apigatewayv2_create_deployment <- function(ApiId, Description = NULL, StageName = NULL) {
  op <- new_operation(
    name = "CreateDeployment",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/deployments",
    paginator = list()
  )
  input <- .apigatewayv2$create_deployment_input(ApiId = ApiId, Description = Description, StageName = StageName)
  output <- .apigatewayv2$create_deployment_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_deployment <- apigatewayv2_create_deployment

#' Creates a domain name
#'
#' Creates a domain name.
#'
#' @usage
#' apigatewayv2_create_domain_name(DomainName, DomainNameConfigurations,
#'   Tags)
#'
#' @param DomainName &#91;required&#93; The domain name.
#' @param DomainNameConfigurations The domain name configurations.
#' @param Tags The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=.\\_:/\]. The tag key can be up to 128 characters and must not
#' start with aws:. The tag value can be up to 256 characters..
#'
#' @section Request syntax:
#' ```
#' svc$create_domain_name(
#'   DomainName = "string",
#'   DomainNameConfigurations = list(
#'     list(
#'       ApiGatewayDomainName = "string",
#'       CertificateArn = "string",
#'       CertificateName = "string",
#'       CertificateUploadDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EndpointType = "REGIONAL"|"EDGE",
#'       HostedZoneId = "string",
#'       SecurityPolicy = "TLS_1_0"|"TLS_1_2",
#'       DomainNameStatus = "AVAILABLE"|"UPDATING",
#'       DomainNameStatusMessage = "string"
#'     )
#'   ),
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_domain_name
apigatewayv2_create_domain_name <- function(DomainName, DomainNameConfigurations = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateDomainName",
    http_method = "POST",
    http_path = "/v2/domainnames",
    paginator = list()
  )
  input <- .apigatewayv2$create_domain_name_input(DomainName = DomainName, DomainNameConfigurations = DomainNameConfigurations, Tags = Tags)
  output <- .apigatewayv2$create_domain_name_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_domain_name <- apigatewayv2_create_domain_name

#' Creates an Integration
#'
#' Creates an Integration.
#'
#' @usage
#' apigatewayv2_create_integration(ApiId, ConnectionId, ConnectionType,
#'   ContentHandlingStrategy, CredentialsArn, Description, IntegrationMethod,
#'   IntegrationType, IntegrationUri, PassthroughBehavior, RequestParameters,
#'   RequestTemplates, TemplateSelectionExpression, TimeoutInMillis)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ConnectionId The connection ID.
#' @param ConnectionType The type of the network connection to the integration endpoint.
#' Currently the only valid value is INTERNET, for connections through the
#' public routable internet.
#' @param ContentHandlingStrategy Specifies how to handle response payload content type conversions.
#' Supported values are CONVERT\\_TO\\_BINARY and CONVERT\\_TO\\_TEXT, with the
#' following behaviors:
#' 
#' CONVERT\\_TO\\_BINARY: Converts a response payload from a Base64-encoded
#' string to the corresponding binary blob.
#' 
#' CONVERT\\_TO\\_TEXT: Converts a response payload from a binary blob to a
#' Base64-encoded string.
#' 
#' If this property is not defined, the response payload will be passed
#' through from the integration response to the route response or method
#' response without modification.
#' @param CredentialsArn Specifies the credentials required for the integration, if any. For AWS
#' integrations, three options are available. To specify an IAM Role for
#' API Gateway to assume, use the role\'s Amazon Resource Name (ARN). To
#' require that the caller\'s identity be passed through from the request,
#' specify the string arn:aws:iam::\*:user/\*. To use resource-based
#' permissions on supported AWS services, specify null.
#' @param Description The description of the integration.
#' @param IntegrationMethod Specifies the integration\'s HTTP method type.
#' @param IntegrationType &#91;required&#93; The integration type of an integration. One of the following:
#' 
#' AWS: for integrating the route or method request with an AWS service
#' action, including the Lambda function-invoking action. With the Lambda
#' function-invoking action, this is referred to as the Lambda custom
#' integration. With any other AWS service action, this is known as AWS
#' integration.
#' 
#' AWS\\_PROXY: for integrating the route or method request with the Lambda
#' function-invoking action with the client request passed through as-is.
#' This integration is also referred to as Lambda proxy integration.
#' 
#' HTTP: for integrating the route or method request with an HTTP endpoint.
#' This integration is also referred to as HTTP custom integration.
#' 
#' HTTP\\_PROXY: for integrating route or method request with an HTTP
#' endpoint, with the client request passed through as-is. This is also
#' referred to as HTTP proxy integration.
#' 
#' MOCK: for integrating the route or method request with API Gateway as a
#' \"loopback\" endpoint without invoking any backend.
#' @param IntegrationUri For a Lambda proxy integration, this is the URI of the Lambda function.
#' @param PassthroughBehavior Specifies the pass-through behavior for incoming requests based on the
#' Content-Type header in the request, and the available mapping templates
#' specified as the requestTemplates property on the Integration resource.
#' There are three valid values: WHEN\\_NO\\_MATCH, WHEN\\_NO\\_TEMPLATES, and
#' NEVER.
#' 
#' WHEN\\_NO\\_MATCH passes the request body for unmapped content types
#' through to the integration backend without transformation.
#' 
#' NEVER rejects unmapped content types with an HTTP 415 Unsupported Media
#' Type response.
#' 
#' WHEN\\_NO\\_TEMPLATES allows pass-through when the integration has no
#' content types mapped to templates. However, if there is at least one
#' content type defined, unmapped content types will be rejected with the
#' same HTTP 415 Unsupported Media Type response.
#' @param RequestParameters A key-value map specifying request parameters that are passed from the
#' method request to the backend. The key is an integration request
#' parameter name and the associated value is a method request parameter
#' value or static value that must be enclosed within single quotes and
#' pre-encoded as required by the backend. The method request parameter
#' value must match the pattern of method.request.\{location\}.\{name\} , where
#' \{location\} is querystring, path, or header; and \{name\} must be a valid
#' and unique method request parameter name.
#' @param RequestTemplates Represents a map of Velocity templates that are applied on the request
#' payload based on the value of the Content-Type header sent by the
#' client. The content type value is the key in this map, and the template
#' (as a String) is the value.
#' @param TemplateSelectionExpression The template selection expression for the integration.
#' @param TimeoutInMillis Custom timeout between 50 and 29,000 milliseconds. The default value is
#' 29,000 milliseconds or 29 seconds.
#'
#' @section Request syntax:
#' ```
#' svc$create_integration(
#'   ApiId = "string",
#'   ConnectionId = "string",
#'   ConnectionType = "INTERNET"|"VPC_LINK",
#'   ContentHandlingStrategy = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT",
#'   CredentialsArn = "string",
#'   Description = "string",
#'   IntegrationMethod = "string",
#'   IntegrationType = "AWS"|"HTTP"|"MOCK"|"HTTP_PROXY"|"AWS_PROXY",
#'   IntegrationUri = "string",
#'   PassthroughBehavior = "WHEN_NO_MATCH"|"NEVER"|"WHEN_NO_TEMPLATES",
#'   RequestParameters = list(
#'     "string"
#'   ),
#'   RequestTemplates = list(
#'     "string"
#'   ),
#'   TemplateSelectionExpression = "string",
#'   TimeoutInMillis = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_integration
apigatewayv2_create_integration <- function(ApiId, ConnectionId = NULL, ConnectionType = NULL, ContentHandlingStrategy = NULL, CredentialsArn = NULL, Description = NULL, IntegrationMethod = NULL, IntegrationType, IntegrationUri = NULL, PassthroughBehavior = NULL, RequestParameters = NULL, RequestTemplates = NULL, TemplateSelectionExpression = NULL, TimeoutInMillis = NULL) {
  op <- new_operation(
    name = "CreateIntegration",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/integrations",
    paginator = list()
  )
  input <- .apigatewayv2$create_integration_input(ApiId = ApiId, ConnectionId = ConnectionId, ConnectionType = ConnectionType, ContentHandlingStrategy = ContentHandlingStrategy, CredentialsArn = CredentialsArn, Description = Description, IntegrationMethod = IntegrationMethod, IntegrationType = IntegrationType, IntegrationUri = IntegrationUri, PassthroughBehavior = PassthroughBehavior, RequestParameters = RequestParameters, RequestTemplates = RequestTemplates, TemplateSelectionExpression = TemplateSelectionExpression, TimeoutInMillis = TimeoutInMillis)
  output <- .apigatewayv2$create_integration_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_integration <- apigatewayv2_create_integration

#' Creates an IntegrationResponses
#'
#' Creates an IntegrationResponses.
#'
#' @usage
#' apigatewayv2_create_integration_response(ApiId, ContentHandlingStrategy,
#'   IntegrationId, IntegrationResponseKey, ResponseParameters,
#'   ResponseTemplates, TemplateSelectionExpression)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ContentHandlingStrategy Specifies how to handle response payload content type conversions.
#' Supported values are CONVERT\\_TO\\_BINARY and CONVERT\\_TO\\_TEXT, with the
#' following behaviors:
#' 
#' CONVERT\\_TO\\_BINARY: Converts a response payload from a Base64-encoded
#' string to the corresponding binary blob.
#' 
#' CONVERT\\_TO\\_TEXT: Converts a response payload from a binary blob to a
#' Base64-encoded string.
#' 
#' If this property is not defined, the response payload will be passed
#' through from the integration response to the route response or method
#' response without modification.
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param IntegrationResponseKey &#91;required&#93; The integration response key.
#' @param ResponseParameters A key-value map specifying response parameters that are passed to the
#' method response from the backend. The key is a method response header
#' parameter name and the mapped value is an integration response header
#' value, a static value enclosed within a pair of single quotes, or a JSON
#' expression from the integration response body. The mapping key must
#' match the pattern of method.response.header.\{name\}, where \{name\} is a
#' valid and unique header name. The mapped non-static value must match the
#' pattern of integration.response.header.\{name\} or
#' integration.response.body.\{JSON-expression\}, where \{name\} is a valid and
#' unique response header name and \{JSON-expression\} is a valid JSON
#' expression without the \\$ prefix.
#' @param ResponseTemplates The collection of response templates for the integration response as a
#' string-to-string map of key-value pairs. Response templates are
#' represented as a key/value map, with a content-type as the key and a
#' template as the value.
#' @param TemplateSelectionExpression The template selection expression for the integration response.
#'
#' @section Request syntax:
#' ```
#' svc$create_integration_response(
#'   ApiId = "string",
#'   ContentHandlingStrategy = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT",
#'   IntegrationId = "string",
#'   IntegrationResponseKey = "string",
#'   ResponseParameters = list(
#'     "string"
#'   ),
#'   ResponseTemplates = list(
#'     "string"
#'   ),
#'   TemplateSelectionExpression = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_integration_response
apigatewayv2_create_integration_response <- function(ApiId, ContentHandlingStrategy = NULL, IntegrationId, IntegrationResponseKey, ResponseParameters = NULL, ResponseTemplates = NULL, TemplateSelectionExpression = NULL) {
  op <- new_operation(
    name = "CreateIntegrationResponse",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses",
    paginator = list()
  )
  input <- .apigatewayv2$create_integration_response_input(ApiId = ApiId, ContentHandlingStrategy = ContentHandlingStrategy, IntegrationId = IntegrationId, IntegrationResponseKey = IntegrationResponseKey, ResponseParameters = ResponseParameters, ResponseTemplates = ResponseTemplates, TemplateSelectionExpression = TemplateSelectionExpression)
  output <- .apigatewayv2$create_integration_response_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_integration_response <- apigatewayv2_create_integration_response

#' Creates a Model for an API
#'
#' Creates a Model for an API.
#'
#' @usage
#' apigatewayv2_create_model(ApiId, ContentType, Description, Name, Schema)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ContentType The content-type for the model, for example, \"application/json\".
#' @param Description The description of the model.
#' @param Name &#91;required&#93; The name of the model. Must be alphanumeric.
#' @param Schema &#91;required&#93; The schema for the model. For application/json models, this should be
#' JSON schema draft 4 model.
#'
#' @section Request syntax:
#' ```
#' svc$create_model(
#'   ApiId = "string",
#'   ContentType = "string",
#'   Description = "string",
#'   Name = "string",
#'   Schema = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_model
apigatewayv2_create_model <- function(ApiId, ContentType = NULL, Description = NULL, Name, Schema) {
  op <- new_operation(
    name = "CreateModel",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/models",
    paginator = list()
  )
  input <- .apigatewayv2$create_model_input(ApiId = ApiId, ContentType = ContentType, Description = Description, Name = Name, Schema = Schema)
  output <- .apigatewayv2$create_model_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_model <- apigatewayv2_create_model

#' Creates a Route for an API
#'
#' Creates a Route for an API.
#'
#' @usage
#' apigatewayv2_create_route(ApiId, ApiKeyRequired, AuthorizationScopes,
#'   AuthorizationType, AuthorizerId, ModelSelectionExpression,
#'   OperationName, RequestModels, RequestParameters, RouteKey,
#'   RouteResponseSelectionExpression, Target)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ApiKeyRequired Specifies whether an API key is required for the route.
#' @param AuthorizationScopes The authorization scopes supported by this route.
#' @param AuthorizationType The authorization type for the route. Valid values are NONE for open
#' access, AWS\\_IAM for using AWS IAM permissions, and CUSTOM for using a
#' Lambda authorizer.
#' @param AuthorizerId The identifier of the Authorizer resource to be associated with this
#' route, if the authorizationType is CUSTOM . The authorizer identifier is
#' generated by API Gateway when you created the authorizer.
#' @param ModelSelectionExpression The model selection expression for the route.
#' @param OperationName The operation name for the route.
#' @param RequestModels The request models for the route.
#' @param RequestParameters The request parameters for the route.
#' @param RouteKey &#91;required&#93; The route key for the route.
#' @param RouteResponseSelectionExpression The route response selection expression for the route.
#' @param Target The target for the route.
#'
#' @section Request syntax:
#' ```
#' svc$create_route(
#'   ApiId = "string",
#'   ApiKeyRequired = TRUE|FALSE,
#'   AuthorizationScopes = list(
#'     "string"
#'   ),
#'   AuthorizationType = "NONE"|"AWS_IAM"|"CUSTOM",
#'   AuthorizerId = "string",
#'   ModelSelectionExpression = "string",
#'   OperationName = "string",
#'   RequestModels = list(
#'     "string"
#'   ),
#'   RequestParameters = list(
#'     list(
#'       Required = TRUE|FALSE
#'     )
#'   ),
#'   RouteKey = "string",
#'   RouteResponseSelectionExpression = "string",
#'   Target = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_route
apigatewayv2_create_route <- function(ApiId, ApiKeyRequired = NULL, AuthorizationScopes = NULL, AuthorizationType = NULL, AuthorizerId = NULL, ModelSelectionExpression = NULL, OperationName = NULL, RequestModels = NULL, RequestParameters = NULL, RouteKey, RouteResponseSelectionExpression = NULL, Target = NULL) {
  op <- new_operation(
    name = "CreateRoute",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/routes",
    paginator = list()
  )
  input <- .apigatewayv2$create_route_input(ApiId = ApiId, ApiKeyRequired = ApiKeyRequired, AuthorizationScopes = AuthorizationScopes, AuthorizationType = AuthorizationType, AuthorizerId = AuthorizerId, ModelSelectionExpression = ModelSelectionExpression, OperationName = OperationName, RequestModels = RequestModels, RequestParameters = RequestParameters, RouteKey = RouteKey, RouteResponseSelectionExpression = RouteResponseSelectionExpression, Target = Target)
  output <- .apigatewayv2$create_route_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_route <- apigatewayv2_create_route

#' Creates a RouteResponse for a Route
#'
#' Creates a RouteResponse for a Route.
#'
#' @usage
#' apigatewayv2_create_route_response(ApiId, ModelSelectionExpression,
#'   ResponseModels, ResponseParameters, RouteId, RouteResponseKey)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ModelSelectionExpression The model selection expression for the route response.
#' @param ResponseModels The response models for the route response.
#' @param ResponseParameters The route response parameters.
#' @param RouteId &#91;required&#93; The route ID.
#' @param RouteResponseKey &#91;required&#93; The route response key.
#'
#' @section Request syntax:
#' ```
#' svc$create_route_response(
#'   ApiId = "string",
#'   ModelSelectionExpression = "string",
#'   ResponseModels = list(
#'     "string"
#'   ),
#'   ResponseParameters = list(
#'     list(
#'       Required = TRUE|FALSE
#'     )
#'   ),
#'   RouteId = "string",
#'   RouteResponseKey = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_route_response
apigatewayv2_create_route_response <- function(ApiId, ModelSelectionExpression = NULL, ResponseModels = NULL, ResponseParameters = NULL, RouteId, RouteResponseKey) {
  op <- new_operation(
    name = "CreateRouteResponse",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/routes/{routeId}/routeresponses",
    paginator = list()
  )
  input <- .apigatewayv2$create_route_response_input(ApiId = ApiId, ModelSelectionExpression = ModelSelectionExpression, ResponseModels = ResponseModels, ResponseParameters = ResponseParameters, RouteId = RouteId, RouteResponseKey = RouteResponseKey)
  output <- .apigatewayv2$create_route_response_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_route_response <- apigatewayv2_create_route_response

#' Creates a Stage for an API
#'
#' Creates a Stage for an API.
#'
#' @usage
#' apigatewayv2_create_stage(AccessLogSettings, ApiId, ClientCertificateId,
#'   DefaultRouteSettings, DeploymentId, Description, RouteSettings,
#'   StageName, StageVariables, Tags)
#'
#' @param AccessLogSettings Settings for logging access in this stage.
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ClientCertificateId The identifier of a client certificate for a Stage.
#' @param DefaultRouteSettings The default route settings for the stage.
#' @param DeploymentId The deployment identifier of the API stage.
#' @param Description The description for the API stage.
#' @param RouteSettings Route settings for the stage.
#' @param StageName &#91;required&#93; The name of the stage.
#' @param StageVariables A map that defines the stage variables for a Stage. Variable names can
#' have alphanumeric and underscore characters, and the values must match
#' \[A-Za-z0-9-.\\_\~:/?\\#&=,\]+.
#' @param Tags The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=.\\_:/\]. The tag key can be up to 128 characters and must not
#' start with aws:. The tag value can be up to 256 characters..
#'
#' @section Request syntax:
#' ```
#' svc$create_stage(
#'   AccessLogSettings = list(
#'     DestinationArn = "string",
#'     Format = "string"
#'   ),
#'   ApiId = "string",
#'   ClientCertificateId = "string",
#'   DefaultRouteSettings = list(
#'     DataTraceEnabled = TRUE|FALSE,
#'     DetailedMetricsEnabled = TRUE|FALSE,
#'     LoggingLevel = "ERROR"|"INFO"|"false",
#'     ThrottlingBurstLimit = 123,
#'     ThrottlingRateLimit = 123.0
#'   ),
#'   DeploymentId = "string",
#'   Description = "string",
#'   RouteSettings = list(
#'     list(
#'       DataTraceEnabled = TRUE|FALSE,
#'       DetailedMetricsEnabled = TRUE|FALSE,
#'       LoggingLevel = "ERROR"|"INFO"|"false",
#'       ThrottlingBurstLimit = 123,
#'       ThrottlingRateLimit = 123.0
#'     )
#'   ),
#'   StageName = "string",
#'   StageVariables = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_create_stage
apigatewayv2_create_stage <- function(AccessLogSettings = NULL, ApiId, ClientCertificateId = NULL, DefaultRouteSettings = NULL, DeploymentId = NULL, Description = NULL, RouteSettings = NULL, StageName, StageVariables = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateStage",
    http_method = "POST",
    http_path = "/v2/apis/{apiId}/stages",
    paginator = list()
  )
  input <- .apigatewayv2$create_stage_input(AccessLogSettings = AccessLogSettings, ApiId = ApiId, ClientCertificateId = ClientCertificateId, DefaultRouteSettings = DefaultRouteSettings, DeploymentId = DeploymentId, Description = Description, RouteSettings = RouteSettings, StageName = StageName, StageVariables = StageVariables, Tags = Tags)
  output <- .apigatewayv2$create_stage_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$create_stage <- apigatewayv2_create_stage

#' Deletes an Api resource
#'
#' Deletes an Api resource.
#'
#' @usage
#' apigatewayv2_delete_api(ApiId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#'
#' @section Request syntax:
#' ```
#' svc$delete_api(
#'   ApiId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_api
apigatewayv2_delete_api <- function(ApiId) {
  op <- new_operation(
    name = "DeleteApi",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}",
    paginator = list()
  )
  input <- .apigatewayv2$delete_api_input(ApiId = ApiId)
  output <- .apigatewayv2$delete_api_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_api <- apigatewayv2_delete_api

#' Deletes an API mapping
#'
#' Deletes an API mapping.
#'
#' @usage
#' apigatewayv2_delete_api_mapping(ApiMappingId, DomainName)
#'
#' @param ApiMappingId &#91;required&#93; The API mapping identifier.
#' @param DomainName &#91;required&#93; The domain name.
#'
#' @section Request syntax:
#' ```
#' svc$delete_api_mapping(
#'   ApiMappingId = "string",
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_api_mapping
apigatewayv2_delete_api_mapping <- function(ApiMappingId, DomainName) {
  op <- new_operation(
    name = "DeleteApiMapping",
    http_method = "DELETE",
    http_path = "/v2/domainnames/{domainName}/apimappings/{apiMappingId}",
    paginator = list()
  )
  input <- .apigatewayv2$delete_api_mapping_input(ApiMappingId = ApiMappingId, DomainName = DomainName)
  output <- .apigatewayv2$delete_api_mapping_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_api_mapping <- apigatewayv2_delete_api_mapping

#' Deletes an Authorizer
#'
#' Deletes an Authorizer.
#'
#' @usage
#' apigatewayv2_delete_authorizer(ApiId, AuthorizerId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param AuthorizerId &#91;required&#93; The authorizer identifier.
#'
#' @section Request syntax:
#' ```
#' svc$delete_authorizer(
#'   ApiId = "string",
#'   AuthorizerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_authorizer
apigatewayv2_delete_authorizer <- function(ApiId, AuthorizerId) {
  op <- new_operation(
    name = "DeleteAuthorizer",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/authorizers/{authorizerId}",
    paginator = list()
  )
  input <- .apigatewayv2$delete_authorizer_input(ApiId = ApiId, AuthorizerId = AuthorizerId)
  output <- .apigatewayv2$delete_authorizer_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_authorizer <- apigatewayv2_delete_authorizer

#' Deletes a Deployment
#'
#' Deletes a Deployment.
#'
#' @usage
#' apigatewayv2_delete_deployment(ApiId, DeploymentId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param DeploymentId &#91;required&#93; The deployment ID.
#'
#' @section Request syntax:
#' ```
#' svc$delete_deployment(
#'   ApiId = "string",
#'   DeploymentId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_deployment
apigatewayv2_delete_deployment <- function(ApiId, DeploymentId) {
  op <- new_operation(
    name = "DeleteDeployment",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/deployments/{deploymentId}",
    paginator = list()
  )
  input <- .apigatewayv2$delete_deployment_input(ApiId = ApiId, DeploymentId = DeploymentId)
  output <- .apigatewayv2$delete_deployment_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_deployment <- apigatewayv2_delete_deployment

#' Deletes a domain name
#'
#' Deletes a domain name.
#'
#' @usage
#' apigatewayv2_delete_domain_name(DomainName)
#'
#' @param DomainName &#91;required&#93; The domain name.
#'
#' @section Request syntax:
#' ```
#' svc$delete_domain_name(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_domain_name
apigatewayv2_delete_domain_name <- function(DomainName) {
  op <- new_operation(
    name = "DeleteDomainName",
    http_method = "DELETE",
    http_path = "/v2/domainnames/{domainName}",
    paginator = list()
  )
  input <- .apigatewayv2$delete_domain_name_input(DomainName = DomainName)
  output <- .apigatewayv2$delete_domain_name_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_domain_name <- apigatewayv2_delete_domain_name

#' Deletes an Integration
#'
#' Deletes an Integration.
#'
#' @usage
#' apigatewayv2_delete_integration(ApiId, IntegrationId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param IntegrationId &#91;required&#93; The integration ID.
#'
#' @section Request syntax:
#' ```
#' svc$delete_integration(
#'   ApiId = "string",
#'   IntegrationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_integration
apigatewayv2_delete_integration <- function(ApiId, IntegrationId) {
  op <- new_operation(
    name = "DeleteIntegration",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}",
    paginator = list()
  )
  input <- .apigatewayv2$delete_integration_input(ApiId = ApiId, IntegrationId = IntegrationId)
  output <- .apigatewayv2$delete_integration_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_integration <- apigatewayv2_delete_integration

#' Deletes an IntegrationResponses
#'
#' Deletes an IntegrationResponses.
#'
#' @usage
#' apigatewayv2_delete_integration_response(ApiId, IntegrationId,
#'   IntegrationResponseId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param IntegrationResponseId &#91;required&#93; The integration response ID.
#'
#' @section Request syntax:
#' ```
#' svc$delete_integration_response(
#'   ApiId = "string",
#'   IntegrationId = "string",
#'   IntegrationResponseId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_integration_response
apigatewayv2_delete_integration_response <- function(ApiId, IntegrationId, IntegrationResponseId) {
  op <- new_operation(
    name = "DeleteIntegrationResponse",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses/{integrationResponseId}",
    paginator = list()
  )
  input <- .apigatewayv2$delete_integration_response_input(ApiId = ApiId, IntegrationId = IntegrationId, IntegrationResponseId = IntegrationResponseId)
  output <- .apigatewayv2$delete_integration_response_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_integration_response <- apigatewayv2_delete_integration_response

#' Deletes a Model
#'
#' Deletes a Model.
#'
#' @usage
#' apigatewayv2_delete_model(ApiId, ModelId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ModelId &#91;required&#93; The model ID.
#'
#' @section Request syntax:
#' ```
#' svc$delete_model(
#'   ApiId = "string",
#'   ModelId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_model
apigatewayv2_delete_model <- function(ApiId, ModelId) {
  op <- new_operation(
    name = "DeleteModel",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/models/{modelId}",
    paginator = list()
  )
  input <- .apigatewayv2$delete_model_input(ApiId = ApiId, ModelId = ModelId)
  output <- .apigatewayv2$delete_model_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_model <- apigatewayv2_delete_model

#' Deletes a Route
#'
#' Deletes a Route.
#'
#' @usage
#' apigatewayv2_delete_route(ApiId, RouteId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param RouteId &#91;required&#93; The route ID.
#'
#' @section Request syntax:
#' ```
#' svc$delete_route(
#'   ApiId = "string",
#'   RouteId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_route
apigatewayv2_delete_route <- function(ApiId, RouteId) {
  op <- new_operation(
    name = "DeleteRoute",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/routes/{routeId}",
    paginator = list()
  )
  input <- .apigatewayv2$delete_route_input(ApiId = ApiId, RouteId = RouteId)
  output <- .apigatewayv2$delete_route_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_route <- apigatewayv2_delete_route

#' Deletes a RouteResponse
#'
#' Deletes a RouteResponse.
#'
#' @usage
#' apigatewayv2_delete_route_response(ApiId, RouteId, RouteResponseId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param RouteId &#91;required&#93; The route ID.
#' @param RouteResponseId &#91;required&#93; The route response ID.
#'
#' @section Request syntax:
#' ```
#' svc$delete_route_response(
#'   ApiId = "string",
#'   RouteId = "string",
#'   RouteResponseId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_route_response
apigatewayv2_delete_route_response <- function(ApiId, RouteId, RouteResponseId) {
  op <- new_operation(
    name = "DeleteRouteResponse",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/routes/{routeId}/routeresponses/{routeResponseId}",
    paginator = list()
  )
  input <- .apigatewayv2$delete_route_response_input(ApiId = ApiId, RouteId = RouteId, RouteResponseId = RouteResponseId)
  output <- .apigatewayv2$delete_route_response_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_route_response <- apigatewayv2_delete_route_response

#' Deletes a Stage
#'
#' Deletes a Stage.
#'
#' @usage
#' apigatewayv2_delete_stage(ApiId, StageName)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param StageName &#91;required&#93; The stage name.
#'
#' @section Request syntax:
#' ```
#' svc$delete_stage(
#'   ApiId = "string",
#'   StageName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_delete_stage
apigatewayv2_delete_stage <- function(ApiId, StageName) {
  op <- new_operation(
    name = "DeleteStage",
    http_method = "DELETE",
    http_path = "/v2/apis/{apiId}/stages/{stageName}",
    paginator = list()
  )
  input <- .apigatewayv2$delete_stage_input(ApiId = ApiId, StageName = StageName)
  output <- .apigatewayv2$delete_stage_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$delete_stage <- apigatewayv2_delete_stage

#' Gets an Api resource
#'
#' Gets an Api resource.
#'
#' @usage
#' apigatewayv2_get_api(ApiId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#'
#' @section Request syntax:
#' ```
#' svc$get_api(
#'   ApiId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_api
apigatewayv2_get_api <- function(ApiId) {
  op <- new_operation(
    name = "GetApi",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}",
    paginator = list()
  )
  input <- .apigatewayv2$get_api_input(ApiId = ApiId)
  output <- .apigatewayv2$get_api_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_api <- apigatewayv2_get_api

#' The API mapping
#'
#' The API mapping.
#'
#' @usage
#' apigatewayv2_get_api_mapping(ApiMappingId, DomainName)
#'
#' @param ApiMappingId &#91;required&#93; The API mapping identifier.
#' @param DomainName &#91;required&#93; The domain name.
#'
#' @section Request syntax:
#' ```
#' svc$get_api_mapping(
#'   ApiMappingId = "string",
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_api_mapping
apigatewayv2_get_api_mapping <- function(ApiMappingId, DomainName) {
  op <- new_operation(
    name = "GetApiMapping",
    http_method = "GET",
    http_path = "/v2/domainnames/{domainName}/apimappings/{apiMappingId}",
    paginator = list()
  )
  input <- .apigatewayv2$get_api_mapping_input(ApiMappingId = ApiMappingId, DomainName = DomainName)
  output <- .apigatewayv2$get_api_mapping_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_api_mapping <- apigatewayv2_get_api_mapping

#' The API mappings
#'
#' The API mappings.
#'
#' @usage
#' apigatewayv2_get_api_mappings(DomainName, MaxResults, NextToken)
#'
#' @param DomainName &#91;required&#93; The domain name.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @section Request syntax:
#' ```
#' svc$get_api_mappings(
#'   DomainName = "string",
#'   MaxResults = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_api_mappings
apigatewayv2_get_api_mappings <- function(DomainName, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetApiMappings",
    http_method = "GET",
    http_path = "/v2/domainnames/{domainName}/apimappings",
    paginator = list()
  )
  input <- .apigatewayv2$get_api_mappings_input(DomainName = DomainName, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_api_mappings_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_api_mappings <- apigatewayv2_get_api_mappings

#' Gets a collection of Api resources
#'
#' Gets a collection of Api resources.
#'
#' @usage
#' apigatewayv2_get_apis(MaxResults, NextToken)
#'
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @section Request syntax:
#' ```
#' svc$get_apis(
#'   MaxResults = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_apis
apigatewayv2_get_apis <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetApis",
    http_method = "GET",
    http_path = "/v2/apis",
    paginator = list()
  )
  input <- .apigatewayv2$get_apis_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_apis_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_apis <- apigatewayv2_get_apis

#' Gets an Authorizer
#'
#' Gets an Authorizer.
#'
#' @usage
#' apigatewayv2_get_authorizer(ApiId, AuthorizerId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param AuthorizerId &#91;required&#93; The authorizer identifier.
#'
#' @section Request syntax:
#' ```
#' svc$get_authorizer(
#'   ApiId = "string",
#'   AuthorizerId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_authorizer
apigatewayv2_get_authorizer <- function(ApiId, AuthorizerId) {
  op <- new_operation(
    name = "GetAuthorizer",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/authorizers/{authorizerId}",
    paginator = list()
  )
  input <- .apigatewayv2$get_authorizer_input(ApiId = ApiId, AuthorizerId = AuthorizerId)
  output <- .apigatewayv2$get_authorizer_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_authorizer <- apigatewayv2_get_authorizer

#' Gets the Authorizers for an API
#'
#' Gets the Authorizers for an API.
#'
#' @usage
#' apigatewayv2_get_authorizers(ApiId, MaxResults, NextToken)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @section Request syntax:
#' ```
#' svc$get_authorizers(
#'   ApiId = "string",
#'   MaxResults = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_authorizers
apigatewayv2_get_authorizers <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetAuthorizers",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/authorizers",
    paginator = list()
  )
  input <- .apigatewayv2$get_authorizers_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_authorizers_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_authorizers <- apigatewayv2_get_authorizers

#' Gets a Deployment
#'
#' Gets a Deployment.
#'
#' @usage
#' apigatewayv2_get_deployment(ApiId, DeploymentId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param DeploymentId &#91;required&#93; The deployment ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_deployment(
#'   ApiId = "string",
#'   DeploymentId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_deployment
apigatewayv2_get_deployment <- function(ApiId, DeploymentId) {
  op <- new_operation(
    name = "GetDeployment",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/deployments/{deploymentId}",
    paginator = list()
  )
  input <- .apigatewayv2$get_deployment_input(ApiId = ApiId, DeploymentId = DeploymentId)
  output <- .apigatewayv2$get_deployment_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_deployment <- apigatewayv2_get_deployment

#' Gets the Deployments for an API
#'
#' Gets the Deployments for an API.
#'
#' @usage
#' apigatewayv2_get_deployments(ApiId, MaxResults, NextToken)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @section Request syntax:
#' ```
#' svc$get_deployments(
#'   ApiId = "string",
#'   MaxResults = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_deployments
apigatewayv2_get_deployments <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDeployments",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/deployments",
    paginator = list()
  )
  input <- .apigatewayv2$get_deployments_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_deployments_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_deployments <- apigatewayv2_get_deployments

#' Gets a domain name
#'
#' Gets a domain name.
#'
#' @usage
#' apigatewayv2_get_domain_name(DomainName)
#'
#' @param DomainName &#91;required&#93; The domain name.
#'
#' @section Request syntax:
#' ```
#' svc$get_domain_name(
#'   DomainName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_domain_name
apigatewayv2_get_domain_name <- function(DomainName) {
  op <- new_operation(
    name = "GetDomainName",
    http_method = "GET",
    http_path = "/v2/domainnames/{domainName}",
    paginator = list()
  )
  input <- .apigatewayv2$get_domain_name_input(DomainName = DomainName)
  output <- .apigatewayv2$get_domain_name_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_domain_name <- apigatewayv2_get_domain_name

#' Gets the domain names for an AWS account
#'
#' Gets the domain names for an AWS account.
#'
#' @usage
#' apigatewayv2_get_domain_names(MaxResults, NextToken)
#'
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @section Request syntax:
#' ```
#' svc$get_domain_names(
#'   MaxResults = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_domain_names
apigatewayv2_get_domain_names <- function(MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetDomainNames",
    http_method = "GET",
    http_path = "/v2/domainnames",
    paginator = list()
  )
  input <- .apigatewayv2$get_domain_names_input(MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_domain_names_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_domain_names <- apigatewayv2_get_domain_names

#' Gets an Integration
#'
#' Gets an Integration.
#'
#' @usage
#' apigatewayv2_get_integration(ApiId, IntegrationId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param IntegrationId &#91;required&#93; The integration ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_integration(
#'   ApiId = "string",
#'   IntegrationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_integration
apigatewayv2_get_integration <- function(ApiId, IntegrationId) {
  op <- new_operation(
    name = "GetIntegration",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}",
    paginator = list()
  )
  input <- .apigatewayv2$get_integration_input(ApiId = ApiId, IntegrationId = IntegrationId)
  output <- .apigatewayv2$get_integration_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_integration <- apigatewayv2_get_integration

#' Gets an IntegrationResponses
#'
#' Gets an IntegrationResponses.
#'
#' @usage
#' apigatewayv2_get_integration_response(ApiId, IntegrationId,
#'   IntegrationResponseId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param IntegrationResponseId &#91;required&#93; The integration response ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_integration_response(
#'   ApiId = "string",
#'   IntegrationId = "string",
#'   IntegrationResponseId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_integration_response
apigatewayv2_get_integration_response <- function(ApiId, IntegrationId, IntegrationResponseId) {
  op <- new_operation(
    name = "GetIntegrationResponse",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses/{integrationResponseId}",
    paginator = list()
  )
  input <- .apigatewayv2$get_integration_response_input(ApiId = ApiId, IntegrationId = IntegrationId, IntegrationResponseId = IntegrationResponseId)
  output <- .apigatewayv2$get_integration_response_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_integration_response <- apigatewayv2_get_integration_response

#' Gets the IntegrationResponses for an Integration
#'
#' Gets the IntegrationResponses for an Integration.
#'
#' @usage
#' apigatewayv2_get_integration_responses(ApiId, IntegrationId, MaxResults,
#'   NextToken)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @section Request syntax:
#' ```
#' svc$get_integration_responses(
#'   ApiId = "string",
#'   IntegrationId = "string",
#'   MaxResults = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_integration_responses
apigatewayv2_get_integration_responses <- function(ApiId, IntegrationId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetIntegrationResponses",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses",
    paginator = list()
  )
  input <- .apigatewayv2$get_integration_responses_input(ApiId = ApiId, IntegrationId = IntegrationId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_integration_responses_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_integration_responses <- apigatewayv2_get_integration_responses

#' Gets the Integrations for an API
#'
#' Gets the Integrations for an API.
#'
#' @usage
#' apigatewayv2_get_integrations(ApiId, MaxResults, NextToken)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @section Request syntax:
#' ```
#' svc$get_integrations(
#'   ApiId = "string",
#'   MaxResults = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_integrations
apigatewayv2_get_integrations <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetIntegrations",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/integrations",
    paginator = list()
  )
  input <- .apigatewayv2$get_integrations_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_integrations_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_integrations <- apigatewayv2_get_integrations

#' Gets a Model
#'
#' Gets a Model.
#'
#' @usage
#' apigatewayv2_get_model(ApiId, ModelId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ModelId &#91;required&#93; The model ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_model(
#'   ApiId = "string",
#'   ModelId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_model
apigatewayv2_get_model <- function(ApiId, ModelId) {
  op <- new_operation(
    name = "GetModel",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/models/{modelId}",
    paginator = list()
  )
  input <- .apigatewayv2$get_model_input(ApiId = ApiId, ModelId = ModelId)
  output <- .apigatewayv2$get_model_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_model <- apigatewayv2_get_model

#' Gets a model template
#'
#' Gets a model template.
#'
#' @usage
#' apigatewayv2_get_model_template(ApiId, ModelId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ModelId &#91;required&#93; The model ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_model_template(
#'   ApiId = "string",
#'   ModelId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_model_template
apigatewayv2_get_model_template <- function(ApiId, ModelId) {
  op <- new_operation(
    name = "GetModelTemplate",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/models/{modelId}/template",
    paginator = list()
  )
  input <- .apigatewayv2$get_model_template_input(ApiId = ApiId, ModelId = ModelId)
  output <- .apigatewayv2$get_model_template_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_model_template <- apigatewayv2_get_model_template

#' Gets the Models for an API
#'
#' Gets the Models for an API.
#'
#' @usage
#' apigatewayv2_get_models(ApiId, MaxResults, NextToken)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @section Request syntax:
#' ```
#' svc$get_models(
#'   ApiId = "string",
#'   MaxResults = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_models
apigatewayv2_get_models <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetModels",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/models",
    paginator = list()
  )
  input <- .apigatewayv2$get_models_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_models_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_models <- apigatewayv2_get_models

#' Gets a Route
#'
#' Gets a Route.
#'
#' @usage
#' apigatewayv2_get_route(ApiId, RouteId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param RouteId &#91;required&#93; The route ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_route(
#'   ApiId = "string",
#'   RouteId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_route
apigatewayv2_get_route <- function(ApiId, RouteId) {
  op <- new_operation(
    name = "GetRoute",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/routes/{routeId}",
    paginator = list()
  )
  input <- .apigatewayv2$get_route_input(ApiId = ApiId, RouteId = RouteId)
  output <- .apigatewayv2$get_route_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_route <- apigatewayv2_get_route

#' Gets a RouteResponse
#'
#' Gets a RouteResponse.
#'
#' @usage
#' apigatewayv2_get_route_response(ApiId, RouteId, RouteResponseId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param RouteId &#91;required&#93; The route ID.
#' @param RouteResponseId &#91;required&#93; The route response ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_route_response(
#'   ApiId = "string",
#'   RouteId = "string",
#'   RouteResponseId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_route_response
apigatewayv2_get_route_response <- function(ApiId, RouteId, RouteResponseId) {
  op <- new_operation(
    name = "GetRouteResponse",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/routes/{routeId}/routeresponses/{routeResponseId}",
    paginator = list()
  )
  input <- .apigatewayv2$get_route_response_input(ApiId = ApiId, RouteId = RouteId, RouteResponseId = RouteResponseId)
  output <- .apigatewayv2$get_route_response_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_route_response <- apigatewayv2_get_route_response

#' Gets the RouteResponses for a Route
#'
#' Gets the RouteResponses for a Route.
#'
#' @usage
#' apigatewayv2_get_route_responses(ApiId, MaxResults, NextToken, RouteId)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#' @param RouteId &#91;required&#93; The route ID.
#'
#' @section Request syntax:
#' ```
#' svc$get_route_responses(
#'   ApiId = "string",
#'   MaxResults = "string",
#'   NextToken = "string",
#'   RouteId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_route_responses
apigatewayv2_get_route_responses <- function(ApiId, MaxResults = NULL, NextToken = NULL, RouteId) {
  op <- new_operation(
    name = "GetRouteResponses",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/routes/{routeId}/routeresponses",
    paginator = list()
  )
  input <- .apigatewayv2$get_route_responses_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken, RouteId = RouteId)
  output <- .apigatewayv2$get_route_responses_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_route_responses <- apigatewayv2_get_route_responses

#' Gets the Routes for an API
#'
#' Gets the Routes for an API.
#'
#' @usage
#' apigatewayv2_get_routes(ApiId, MaxResults, NextToken)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @section Request syntax:
#' ```
#' svc$get_routes(
#'   ApiId = "string",
#'   MaxResults = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_routes
apigatewayv2_get_routes <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetRoutes",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/routes",
    paginator = list()
  )
  input <- .apigatewayv2$get_routes_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_routes_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_routes <- apigatewayv2_get_routes

#' Gets a Stage
#'
#' Gets a Stage.
#'
#' @usage
#' apigatewayv2_get_stage(ApiId, StageName)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param StageName &#91;required&#93; The stage name.
#'
#' @section Request syntax:
#' ```
#' svc$get_stage(
#'   ApiId = "string",
#'   StageName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_stage
apigatewayv2_get_stage <- function(ApiId, StageName) {
  op <- new_operation(
    name = "GetStage",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/stages/{stageName}",
    paginator = list()
  )
  input <- .apigatewayv2$get_stage_input(ApiId = ApiId, StageName = StageName)
  output <- .apigatewayv2$get_stage_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_stage <- apigatewayv2_get_stage

#' Gets the Stages for an API
#'
#' Gets the Stages for an API.
#'
#' @usage
#' apigatewayv2_get_stages(ApiId, MaxResults, NextToken)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param MaxResults The maximum number of elements to be returned for this resource.
#' @param NextToken The next page of elements from this collection. Not valid for the last
#' element of the collection.
#'
#' @section Request syntax:
#' ```
#' svc$get_stages(
#'   ApiId = "string",
#'   MaxResults = "string",
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_stages
apigatewayv2_get_stages <- function(ApiId, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "GetStages",
    http_method = "GET",
    http_path = "/v2/apis/{apiId}/stages",
    paginator = list()
  )
  input <- .apigatewayv2$get_stages_input(ApiId = ApiId, MaxResults = MaxResults, NextToken = NextToken)
  output <- .apigatewayv2$get_stages_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_stages <- apigatewayv2_get_stages

#' Gets the Tags for an API
#'
#' Gets the Tags for an API.
#'
#' @usage
#' apigatewayv2_get_tags(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; 
#'
#' @section Request syntax:
#' ```
#' svc$get_tags(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_get_tags
apigatewayv2_get_tags <- function(ResourceArn) {
  op <- new_operation(
    name = "GetTags",
    http_method = "GET",
    http_path = "/v2/tags/{resource-arn}",
    paginator = list()
  )
  input <- .apigatewayv2$get_tags_input(ResourceArn = ResourceArn)
  output <- .apigatewayv2$get_tags_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$get_tags <- apigatewayv2_get_tags

#' Tag an APIGW resource
#'
#' Tag an APIGW resource
#'
#' @usage
#' apigatewayv2_tag_resource(ResourceArn, Tags)
#'
#' @param ResourceArn &#91;required&#93; AWS resource arn
#' @param Tags The key-value map of strings. The valid character set is
#' \[a-zA-Z+-=.\\_:/\]. The tag key can be up to 128 characters and must not
#' start with aws:. The tag value can be up to 256 characters..
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   Tags = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_tag_resource
apigatewayv2_tag_resource <- function(ResourceArn, Tags = NULL) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/v2/tags/{resource-arn}",
    paginator = list()
  )
  input <- .apigatewayv2$tag_resource_input(ResourceArn = ResourceArn, Tags = Tags)
  output <- .apigatewayv2$tag_resource_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$tag_resource <- apigatewayv2_tag_resource

#' Untag an APIGW resource
#'
#' Untag an APIGW resource
#'
#' @usage
#' apigatewayv2_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; AWS resource arn
#' @param TagKeys &#91;required&#93; The Tag keys to delete
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_untag_resource
apigatewayv2_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "DELETE",
    http_path = "/v2/tags/{resource-arn}",
    paginator = list()
  )
  input <- .apigatewayv2$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .apigatewayv2$untag_resource_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$untag_resource <- apigatewayv2_untag_resource

#' Updates an Api resource
#'
#' Updates an Api resource.
#'
#' @usage
#' apigatewayv2_update_api(ApiId, ApiKeySelectionExpression, Description,
#'   DisableSchemaValidation, Name, RouteSelectionExpression, Version)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ApiKeySelectionExpression An API key selection expression. See [API Key Selection
#' Expressions](https://docs.aws.amazon.com/apigateway/latest/developerguide/apigateway-websocket-api-selection-expressions.html#apigateway-websocket-api-apikey-selection-expressions).
#' @param Description The description of the API.
#' @param DisableSchemaValidation Avoid validating models when creating a deployment.
#' @param Name The name of the API.
#' @param RouteSelectionExpression The route selection expression for the API.
#' @param Version A version identifier for the API.
#'
#' @section Request syntax:
#' ```
#' svc$update_api(
#'   ApiId = "string",
#'   ApiKeySelectionExpression = "string",
#'   Description = "string",
#'   DisableSchemaValidation = TRUE|FALSE,
#'   Name = "string",
#'   RouteSelectionExpression = "string",
#'   Version = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_api
apigatewayv2_update_api <- function(ApiId, ApiKeySelectionExpression = NULL, Description = NULL, DisableSchemaValidation = NULL, Name = NULL, RouteSelectionExpression = NULL, Version = NULL) {
  op <- new_operation(
    name = "UpdateApi",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}",
    paginator = list()
  )
  input <- .apigatewayv2$update_api_input(ApiId = ApiId, ApiKeySelectionExpression = ApiKeySelectionExpression, Description = Description, DisableSchemaValidation = DisableSchemaValidation, Name = Name, RouteSelectionExpression = RouteSelectionExpression, Version = Version)
  output <- .apigatewayv2$update_api_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_api <- apigatewayv2_update_api

#' The API mapping
#'
#' The API mapping.
#'
#' @usage
#' apigatewayv2_update_api_mapping(ApiId, ApiMappingId, ApiMappingKey,
#'   DomainName, Stage)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ApiMappingId &#91;required&#93; The API mapping identifier.
#' @param ApiMappingKey The API mapping key.
#' @param DomainName &#91;required&#93; The domain name.
#' @param Stage The API stage.
#'
#' @section Request syntax:
#' ```
#' svc$update_api_mapping(
#'   ApiId = "string",
#'   ApiMappingId = "string",
#'   ApiMappingKey = "string",
#'   DomainName = "string",
#'   Stage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_api_mapping
apigatewayv2_update_api_mapping <- function(ApiId, ApiMappingId, ApiMappingKey = NULL, DomainName, Stage = NULL) {
  op <- new_operation(
    name = "UpdateApiMapping",
    http_method = "PATCH",
    http_path = "/v2/domainnames/{domainName}/apimappings/{apiMappingId}",
    paginator = list()
  )
  input <- .apigatewayv2$update_api_mapping_input(ApiId = ApiId, ApiMappingId = ApiMappingId, ApiMappingKey = ApiMappingKey, DomainName = DomainName, Stage = Stage)
  output <- .apigatewayv2$update_api_mapping_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_api_mapping <- apigatewayv2_update_api_mapping

#' Updates an Authorizer
#'
#' Updates an Authorizer.
#'
#' @usage
#' apigatewayv2_update_authorizer(ApiId, AuthorizerCredentialsArn,
#'   AuthorizerId, AuthorizerResultTtlInSeconds, AuthorizerType,
#'   AuthorizerUri, IdentitySource, IdentityValidationExpression, Name,
#'   ProviderArns)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param AuthorizerCredentialsArn Specifies the required credentials as an IAM role for API Gateway to
#' invoke the authorizer. To specify an IAM role for API Gateway to assume,
#' use the role\'s Amazon Resource Name (ARN). To use resource-based
#' permissions on the Lambda function, specify null.
#' @param AuthorizerId &#91;required&#93; The authorizer identifier.
#' @param AuthorizerResultTtlInSeconds The time to live (TTL), in seconds, of cached authorizer results. If it
#' is zero, authorization caching is disabled. If it is greater than zero,
#' API Gateway will cache authorizer responses. If this field is not set,
#' the default value is 300. The maximum value is 3600, or 1 hour.
#' @param AuthorizerType The authorizer type. Currently the only valid value is REQUEST, for a
#' Lambda function using incoming request parameters.
#' @param AuthorizerUri The authorizer\'s Uniform Resource Identifier (URI). For REQUEST
#' authorizers, this must be a well-formed Lambda function URI, for
#' example,
#' arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:\{account\\_id\}:function:\{lambda\\_function\\_name\}/invocations.
#' In general, the URI has this form:
#' arn:aws:apigateway:\{region\}:lambda:path/\{service\\_api\} , where \{region\}
#' is the same as the region hosting the Lambda function, path indicates
#' that the remaining substring in the URI should be treated as the path to
#' the resource, including the initial /. For Lambda functions, this is
#' usually of the form /2015-03-31/functions/\[FunctionARN\]/invocations.
#' @param IdentitySource The identity source for which authorization is requested.
#' 
#' For the REQUEST authorizer, this is required when authorization caching
#' is enabled. The value is a comma-separated string of one or more mapping
#' expressions of the specified request parameters. For example, if an Auth
#' header, a Name query string parameter are defined as identity sources,
#' this value is \\$method.request.header.Auth,
#' \\$method.request.querystring.Name. These parameters will be used to
#' derive the authorization caching key and to perform runtime validation
#' of the REQUEST authorizer by verifying all of the identity-related
#' request parameters are present, not null and non-empty. Only when this
#' is true does the authorizer invoke the authorizer Lambda function,
#' otherwise, it returns a 401 Unauthorized response without calling the
#' Lambda function. The valid value is a string of comma-separated mapping
#' expressions of the specified request parameters. When the authorization
#' caching is not enabled, this property is optional.
#' @param IdentityValidationExpression The validation expression does not apply to the REQUEST authorizer.
#' @param Name The name of the authorizer.
#' @param ProviderArns For REQUEST authorizer, this is not defined.
#'
#' @section Request syntax:
#' ```
#' svc$update_authorizer(
#'   ApiId = "string",
#'   AuthorizerCredentialsArn = "string",
#'   AuthorizerId = "string",
#'   AuthorizerResultTtlInSeconds = 123,
#'   AuthorizerType = "REQUEST",
#'   AuthorizerUri = "string",
#'   IdentitySource = list(
#'     "string"
#'   ),
#'   IdentityValidationExpression = "string",
#'   Name = "string",
#'   ProviderArns = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_authorizer
apigatewayv2_update_authorizer <- function(ApiId, AuthorizerCredentialsArn = NULL, AuthorizerId, AuthorizerResultTtlInSeconds = NULL, AuthorizerType = NULL, AuthorizerUri = NULL, IdentitySource = NULL, IdentityValidationExpression = NULL, Name = NULL, ProviderArns = NULL) {
  op <- new_operation(
    name = "UpdateAuthorizer",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/authorizers/{authorizerId}",
    paginator = list()
  )
  input <- .apigatewayv2$update_authorizer_input(ApiId = ApiId, AuthorizerCredentialsArn = AuthorizerCredentialsArn, AuthorizerId = AuthorizerId, AuthorizerResultTtlInSeconds = AuthorizerResultTtlInSeconds, AuthorizerType = AuthorizerType, AuthorizerUri = AuthorizerUri, IdentitySource = IdentitySource, IdentityValidationExpression = IdentityValidationExpression, Name = Name, ProviderArns = ProviderArns)
  output <- .apigatewayv2$update_authorizer_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_authorizer <- apigatewayv2_update_authorizer

#' Updates a Deployment
#'
#' Updates a Deployment.
#'
#' @usage
#' apigatewayv2_update_deployment(ApiId, DeploymentId, Description)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param DeploymentId &#91;required&#93; The deployment ID.
#' @param Description The description for the deployment resource.
#'
#' @section Request syntax:
#' ```
#' svc$update_deployment(
#'   ApiId = "string",
#'   DeploymentId = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_deployment
apigatewayv2_update_deployment <- function(ApiId, DeploymentId, Description = NULL) {
  op <- new_operation(
    name = "UpdateDeployment",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/deployments/{deploymentId}",
    paginator = list()
  )
  input <- .apigatewayv2$update_deployment_input(ApiId = ApiId, DeploymentId = DeploymentId, Description = Description)
  output <- .apigatewayv2$update_deployment_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_deployment <- apigatewayv2_update_deployment

#' Updates a domain name
#'
#' Updates a domain name.
#'
#' @usage
#' apigatewayv2_update_domain_name(DomainName, DomainNameConfigurations)
#'
#' @param DomainName &#91;required&#93; The domain name.
#' @param DomainNameConfigurations The domain name configurations.
#'
#' @section Request syntax:
#' ```
#' svc$update_domain_name(
#'   DomainName = "string",
#'   DomainNameConfigurations = list(
#'     list(
#'       ApiGatewayDomainName = "string",
#'       CertificateArn = "string",
#'       CertificateName = "string",
#'       CertificateUploadDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       EndpointType = "REGIONAL"|"EDGE",
#'       HostedZoneId = "string",
#'       SecurityPolicy = "TLS_1_0"|"TLS_1_2",
#'       DomainNameStatus = "AVAILABLE"|"UPDATING",
#'       DomainNameStatusMessage = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_domain_name
apigatewayv2_update_domain_name <- function(DomainName, DomainNameConfigurations = NULL) {
  op <- new_operation(
    name = "UpdateDomainName",
    http_method = "PATCH",
    http_path = "/v2/domainnames/{domainName}",
    paginator = list()
  )
  input <- .apigatewayv2$update_domain_name_input(DomainName = DomainName, DomainNameConfigurations = DomainNameConfigurations)
  output <- .apigatewayv2$update_domain_name_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_domain_name <- apigatewayv2_update_domain_name

#' Updates an Integration
#'
#' Updates an Integration.
#'
#' @usage
#' apigatewayv2_update_integration(ApiId, ConnectionId, ConnectionType,
#'   ContentHandlingStrategy, CredentialsArn, Description, IntegrationId,
#'   IntegrationMethod, IntegrationType, IntegrationUri, PassthroughBehavior,
#'   RequestParameters, RequestTemplates, TemplateSelectionExpression,
#'   TimeoutInMillis)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ConnectionId The connection ID.
#' @param ConnectionType The type of the network connection to the integration endpoint.
#' Currently the only valid value is INTERNET, for connections through the
#' public routable internet.
#' @param ContentHandlingStrategy Specifies how to handle response payload content type conversions.
#' Supported values are CONVERT\\_TO\\_BINARY and CONVERT\\_TO\\_TEXT, with the
#' following behaviors:
#' 
#' CONVERT\\_TO\\_BINARY: Converts a response payload from a Base64-encoded
#' string to the corresponding binary blob.
#' 
#' CONVERT\\_TO\\_TEXT: Converts a response payload from a binary blob to a
#' Base64-encoded string.
#' 
#' If this property is not defined, the response payload will be passed
#' through from the integration response to the route response or method
#' response without modification.
#' @param CredentialsArn Specifies the credentials required for the integration, if any. For AWS
#' integrations, three options are available. To specify an IAM Role for
#' API Gateway to assume, use the role\'s Amazon Resource Name (ARN). To
#' require that the caller\'s identity be passed through from the request,
#' specify the string arn:aws:iam::\*:user/\*. To use resource-based
#' permissions on supported AWS services, specify null.
#' @param Description The description of the integration
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param IntegrationMethod Specifies the integration\'s HTTP method type.
#' @param IntegrationType The integration type of an integration. One of the following:
#' 
#' AWS: for integrating the route or method request with an AWS service
#' action, including the Lambda function-invoking action. With the Lambda
#' function-invoking action, this is referred to as the Lambda custom
#' integration. With any other AWS service action, this is known as AWS
#' integration.
#' 
#' AWS\\_PROXY: for integrating the route or method request with the Lambda
#' function-invoking action with the client request passed through as-is.
#' This integration is also referred to as Lambda proxy integration.
#' 
#' HTTP: for integrating the route or method request with an HTTP endpoint.
#' This integration is also referred to as the HTTP custom integration.
#' 
#' HTTP\\_PROXY: for integrating route or method request with an HTTP
#' endpoint, with the client request passed through as-is. This is also
#' referred to as HTTP proxy integration.
#' 
#' MOCK: for integrating the route or method request with API Gateway as a
#' \"loopback\" endpoint without invoking any backend.
#' @param IntegrationUri For a Lambda proxy integration, this is the URI of the Lambda function.
#' @param PassthroughBehavior Specifies the pass-through behavior for incoming requests based on the
#' Content-Type header in the request, and the available mapping templates
#' specified as the requestTemplates property on the Integration resource.
#' There are three valid values: WHEN\\_NO\\_MATCH, WHEN\\_NO\\_TEMPLATES, and
#' NEVER.
#' 
#' WHEN\\_NO\\_MATCH passes the request body for unmapped content types
#' through to the integration backend without transformation.
#' 
#' NEVER rejects unmapped content types with an HTTP 415 Unsupported Media
#' Type response.
#' 
#' WHEN\\_NO\\_TEMPLATES allows pass-through when the integration has no
#' content types mapped to templates. However, if there is at least one
#' content type defined, unmapped content types will be rejected with the
#' same HTTP 415 Unsupported Media Type response.
#' @param RequestParameters A key-value map specifying request parameters that are passed from the
#' method request to the backend. The key is an integration request
#' parameter name and the associated value is a method request parameter
#' value or static value that must be enclosed within single quotes and
#' pre-encoded as required by the backend. The method request parameter
#' value must match the pattern of method.request.\{location\}.\{name\} , where
#' \{location\} is querystring, path, or header; and \{name\} must be a valid
#' and unique method request parameter name.
#' @param RequestTemplates Represents a map of Velocity templates that are applied on the request
#' payload based on the value of the Content-Type header sent by the
#' client. The content type value is the key in this map, and the template
#' (as a String) is the value.
#' @param TemplateSelectionExpression The template selection expression for the integration.
#' @param TimeoutInMillis Custom timeout between 50 and 29,000 milliseconds. The default value is
#' 29,000 milliseconds or 29 seconds.
#'
#' @section Request syntax:
#' ```
#' svc$update_integration(
#'   ApiId = "string",
#'   ConnectionId = "string",
#'   ConnectionType = "INTERNET"|"VPC_LINK",
#'   ContentHandlingStrategy = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT",
#'   CredentialsArn = "string",
#'   Description = "string",
#'   IntegrationId = "string",
#'   IntegrationMethod = "string",
#'   IntegrationType = "AWS"|"HTTP"|"MOCK"|"HTTP_PROXY"|"AWS_PROXY",
#'   IntegrationUri = "string",
#'   PassthroughBehavior = "WHEN_NO_MATCH"|"NEVER"|"WHEN_NO_TEMPLATES",
#'   RequestParameters = list(
#'     "string"
#'   ),
#'   RequestTemplates = list(
#'     "string"
#'   ),
#'   TemplateSelectionExpression = "string",
#'   TimeoutInMillis = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_integration
apigatewayv2_update_integration <- function(ApiId, ConnectionId = NULL, ConnectionType = NULL, ContentHandlingStrategy = NULL, CredentialsArn = NULL, Description = NULL, IntegrationId, IntegrationMethod = NULL, IntegrationType = NULL, IntegrationUri = NULL, PassthroughBehavior = NULL, RequestParameters = NULL, RequestTemplates = NULL, TemplateSelectionExpression = NULL, TimeoutInMillis = NULL) {
  op <- new_operation(
    name = "UpdateIntegration",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}",
    paginator = list()
  )
  input <- .apigatewayv2$update_integration_input(ApiId = ApiId, ConnectionId = ConnectionId, ConnectionType = ConnectionType, ContentHandlingStrategy = ContentHandlingStrategy, CredentialsArn = CredentialsArn, Description = Description, IntegrationId = IntegrationId, IntegrationMethod = IntegrationMethod, IntegrationType = IntegrationType, IntegrationUri = IntegrationUri, PassthroughBehavior = PassthroughBehavior, RequestParameters = RequestParameters, RequestTemplates = RequestTemplates, TemplateSelectionExpression = TemplateSelectionExpression, TimeoutInMillis = TimeoutInMillis)
  output <- .apigatewayv2$update_integration_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_integration <- apigatewayv2_update_integration

#' Updates an IntegrationResponses
#'
#' Updates an IntegrationResponses.
#'
#' @usage
#' apigatewayv2_update_integration_response(ApiId, ContentHandlingStrategy,
#'   IntegrationId, IntegrationResponseId, IntegrationResponseKey,
#'   ResponseParameters, ResponseTemplates, TemplateSelectionExpression)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ContentHandlingStrategy Specifies how to handle response payload content type conversions.
#' Supported values are CONVERT\\_TO\\_BINARY and CONVERT\\_TO\\_TEXT, with the
#' following behaviors:
#' 
#' CONVERT\\_TO\\_BINARY: Converts a response payload from a Base64-encoded
#' string to the corresponding binary blob.
#' 
#' CONVERT\\_TO\\_TEXT: Converts a response payload from a binary blob to a
#' Base64-encoded string.
#' 
#' If this property is not defined, the response payload will be passed
#' through from the integration response to the route response or method
#' response without modification.
#' @param IntegrationId &#91;required&#93; The integration ID.
#' @param IntegrationResponseId &#91;required&#93; The integration response ID.
#' @param IntegrationResponseKey The integration response key.
#' @param ResponseParameters A key-value map specifying response parameters that are passed to the
#' method response from the backend. The key is a method response header
#' parameter name and the mapped value is an integration response header
#' value, a static value enclosed within a pair of single quotes, or a JSON
#' expression from the integration response body. The mapping key must
#' match the pattern of method.response.header.\{name\} , where name is a
#' valid and unique header name. The mapped non-static value must match the
#' pattern of integration.response.header.\{name\} or
#' integration.response.body.\{JSON-expression\} , where \{name\} is a valid
#' and unique response header name and \{JSON-expression\} is a valid JSON
#' expression without the \\$ prefix.
#' @param ResponseTemplates The collection of response templates for the integration response as a
#' string-to-string map of key-value pairs. Response templates are
#' represented as a key/value map, with a content-type as the key and a
#' template as the value.
#' @param TemplateSelectionExpression The template selection expression for the integration response.
#'
#' @section Request syntax:
#' ```
#' svc$update_integration_response(
#'   ApiId = "string",
#'   ContentHandlingStrategy = "CONVERT_TO_BINARY"|"CONVERT_TO_TEXT",
#'   IntegrationId = "string",
#'   IntegrationResponseId = "string",
#'   IntegrationResponseKey = "string",
#'   ResponseParameters = list(
#'     "string"
#'   ),
#'   ResponseTemplates = list(
#'     "string"
#'   ),
#'   TemplateSelectionExpression = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_integration_response
apigatewayv2_update_integration_response <- function(ApiId, ContentHandlingStrategy = NULL, IntegrationId, IntegrationResponseId, IntegrationResponseKey = NULL, ResponseParameters = NULL, ResponseTemplates = NULL, TemplateSelectionExpression = NULL) {
  op <- new_operation(
    name = "UpdateIntegrationResponse",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/integrations/{integrationId}/integrationresponses/{integrationResponseId}",
    paginator = list()
  )
  input <- .apigatewayv2$update_integration_response_input(ApiId = ApiId, ContentHandlingStrategy = ContentHandlingStrategy, IntegrationId = IntegrationId, IntegrationResponseId = IntegrationResponseId, IntegrationResponseKey = IntegrationResponseKey, ResponseParameters = ResponseParameters, ResponseTemplates = ResponseTemplates, TemplateSelectionExpression = TemplateSelectionExpression)
  output <- .apigatewayv2$update_integration_response_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_integration_response <- apigatewayv2_update_integration_response

#' Updates a Model
#'
#' Updates a Model.
#'
#' @usage
#' apigatewayv2_update_model(ApiId, ContentType, Description, ModelId,
#'   Name, Schema)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ContentType The content-type for the model, for example, \"application/json\".
#' @param Description The description of the model.
#' @param ModelId &#91;required&#93; The model ID.
#' @param Name The name of the model.
#' @param Schema The schema for the model. For application/json models, this should be
#' JSON schema draft 4 model.
#'
#' @section Request syntax:
#' ```
#' svc$update_model(
#'   ApiId = "string",
#'   ContentType = "string",
#'   Description = "string",
#'   ModelId = "string",
#'   Name = "string",
#'   Schema = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_model
apigatewayv2_update_model <- function(ApiId, ContentType = NULL, Description = NULL, ModelId, Name = NULL, Schema = NULL) {
  op <- new_operation(
    name = "UpdateModel",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/models/{modelId}",
    paginator = list()
  )
  input <- .apigatewayv2$update_model_input(ApiId = ApiId, ContentType = ContentType, Description = Description, ModelId = ModelId, Name = Name, Schema = Schema)
  output <- .apigatewayv2$update_model_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_model <- apigatewayv2_update_model

#' Updates a Route
#'
#' Updates a Route.
#'
#' @usage
#' apigatewayv2_update_route(ApiId, ApiKeyRequired, AuthorizationScopes,
#'   AuthorizationType, AuthorizerId, ModelSelectionExpression,
#'   OperationName, RequestModels, RequestParameters, RouteId, RouteKey,
#'   RouteResponseSelectionExpression, Target)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ApiKeyRequired Specifies whether an API key is required for the route.
#' @param AuthorizationScopes The authorization scopes supported by this route.
#' @param AuthorizationType The authorization type for the route. Valid values are NONE for open
#' access, AWS\\_IAM for using AWS IAM permissions, and CUSTOM for using a
#' Lambda authorizer.
#' @param AuthorizerId The identifier of the Authorizer resource to be associated with this
#' route, if the authorizationType is CUSTOM . The authorizer identifier is
#' generated by API Gateway when you created the authorizer.
#' @param ModelSelectionExpression The model selection expression for the route.
#' @param OperationName The operation name for the route.
#' @param RequestModels The request models for the route.
#' @param RequestParameters The request parameters for the route.
#' @param RouteId &#91;required&#93; The route ID.
#' @param RouteKey The route key for the route.
#' @param RouteResponseSelectionExpression The route response selection expression for the route.
#' @param Target The target for the route.
#'
#' @section Request syntax:
#' ```
#' svc$update_route(
#'   ApiId = "string",
#'   ApiKeyRequired = TRUE|FALSE,
#'   AuthorizationScopes = list(
#'     "string"
#'   ),
#'   AuthorizationType = "NONE"|"AWS_IAM"|"CUSTOM",
#'   AuthorizerId = "string",
#'   ModelSelectionExpression = "string",
#'   OperationName = "string",
#'   RequestModels = list(
#'     "string"
#'   ),
#'   RequestParameters = list(
#'     list(
#'       Required = TRUE|FALSE
#'     )
#'   ),
#'   RouteId = "string",
#'   RouteKey = "string",
#'   RouteResponseSelectionExpression = "string",
#'   Target = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_route
apigatewayv2_update_route <- function(ApiId, ApiKeyRequired = NULL, AuthorizationScopes = NULL, AuthorizationType = NULL, AuthorizerId = NULL, ModelSelectionExpression = NULL, OperationName = NULL, RequestModels = NULL, RequestParameters = NULL, RouteId, RouteKey = NULL, RouteResponseSelectionExpression = NULL, Target = NULL) {
  op <- new_operation(
    name = "UpdateRoute",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/routes/{routeId}",
    paginator = list()
  )
  input <- .apigatewayv2$update_route_input(ApiId = ApiId, ApiKeyRequired = ApiKeyRequired, AuthorizationScopes = AuthorizationScopes, AuthorizationType = AuthorizationType, AuthorizerId = AuthorizerId, ModelSelectionExpression = ModelSelectionExpression, OperationName = OperationName, RequestModels = RequestModels, RequestParameters = RequestParameters, RouteId = RouteId, RouteKey = RouteKey, RouteResponseSelectionExpression = RouteResponseSelectionExpression, Target = Target)
  output <- .apigatewayv2$update_route_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_route <- apigatewayv2_update_route

#' Updates a RouteResponse
#'
#' Updates a RouteResponse.
#'
#' @usage
#' apigatewayv2_update_route_response(ApiId, ModelSelectionExpression,
#'   ResponseModels, ResponseParameters, RouteId, RouteResponseId,
#'   RouteResponseKey)
#'
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ModelSelectionExpression The model selection expression for the route response.
#' @param ResponseModels The response models for the route response.
#' @param ResponseParameters The route response parameters.
#' @param RouteId &#91;required&#93; The route ID.
#' @param RouteResponseId &#91;required&#93; The route response ID.
#' @param RouteResponseKey The route response key.
#'
#' @section Request syntax:
#' ```
#' svc$update_route_response(
#'   ApiId = "string",
#'   ModelSelectionExpression = "string",
#'   ResponseModels = list(
#'     "string"
#'   ),
#'   ResponseParameters = list(
#'     list(
#'       Required = TRUE|FALSE
#'     )
#'   ),
#'   RouteId = "string",
#'   RouteResponseId = "string",
#'   RouteResponseKey = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_route_response
apigatewayv2_update_route_response <- function(ApiId, ModelSelectionExpression = NULL, ResponseModels = NULL, ResponseParameters = NULL, RouteId, RouteResponseId, RouteResponseKey = NULL) {
  op <- new_operation(
    name = "UpdateRouteResponse",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/routes/{routeId}/routeresponses/{routeResponseId}",
    paginator = list()
  )
  input <- .apigatewayv2$update_route_response_input(ApiId = ApiId, ModelSelectionExpression = ModelSelectionExpression, ResponseModels = ResponseModels, ResponseParameters = ResponseParameters, RouteId = RouteId, RouteResponseId = RouteResponseId, RouteResponseKey = RouteResponseKey)
  output <- .apigatewayv2$update_route_response_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_route_response <- apigatewayv2_update_route_response

#' Updates a Stage
#'
#' Updates a Stage.
#'
#' @usage
#' apigatewayv2_update_stage(AccessLogSettings, ApiId, ClientCertificateId,
#'   DefaultRouteSettings, DeploymentId, Description, RouteSettings,
#'   StageName, StageVariables)
#'
#' @param AccessLogSettings Settings for logging access in this stage.
#' @param ApiId &#91;required&#93; The API identifier.
#' @param ClientCertificateId The identifier of a client certificate for a Stage.
#' @param DefaultRouteSettings The default route settings for the stage.
#' @param DeploymentId The deployment identifier for the API stage.
#' @param Description The description for the API stage.
#' @param RouteSettings Route settings for the stage.
#' @param StageName &#91;required&#93; The stage name.
#' @param StageVariables A map that defines the stage variables for a Stage. Variable names can
#' have alphanumeric and underscore characters, and the values must match
#' \[A-Za-z0-9-.\\_\~:/?\\#&=,\]+.
#'
#' @section Request syntax:
#' ```
#' svc$update_stage(
#'   AccessLogSettings = list(
#'     DestinationArn = "string",
#'     Format = "string"
#'   ),
#'   ApiId = "string",
#'   ClientCertificateId = "string",
#'   DefaultRouteSettings = list(
#'     DataTraceEnabled = TRUE|FALSE,
#'     DetailedMetricsEnabled = TRUE|FALSE,
#'     LoggingLevel = "ERROR"|"INFO"|"false",
#'     ThrottlingBurstLimit = 123,
#'     ThrottlingRateLimit = 123.0
#'   ),
#'   DeploymentId = "string",
#'   Description = "string",
#'   RouteSettings = list(
#'     list(
#'       DataTraceEnabled = TRUE|FALSE,
#'       DetailedMetricsEnabled = TRUE|FALSE,
#'       LoggingLevel = "ERROR"|"INFO"|"false",
#'       ThrottlingBurstLimit = 123,
#'       ThrottlingRateLimit = 123.0
#'     )
#'   ),
#'   StageName = "string",
#'   StageVariables = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname apigatewayv2_update_stage
apigatewayv2_update_stage <- function(AccessLogSettings = NULL, ApiId, ClientCertificateId = NULL, DefaultRouteSettings = NULL, DeploymentId = NULL, Description = NULL, RouteSettings = NULL, StageName, StageVariables = NULL) {
  op <- new_operation(
    name = "UpdateStage",
    http_method = "PATCH",
    http_path = "/v2/apis/{apiId}/stages/{stageName}",
    paginator = list()
  )
  input <- .apigatewayv2$update_stage_input(AccessLogSettings = AccessLogSettings, ApiId = ApiId, ClientCertificateId = ClientCertificateId, DefaultRouteSettings = DefaultRouteSettings, DeploymentId = DeploymentId, Description = Description, RouteSettings = RouteSettings, StageName = StageName, StageVariables = StageVariables)
  output <- .apigatewayv2$update_stage_output()
  svc <- .apigatewayv2$service()
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.apigatewayv2$operations$update_stage <- apigatewayv2_update_stage
