% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_get_resolver_rule}
\alias{route53resolver_get_resolver_rule}
\title{Gets information about a specified Resolver rule, such as the domain
name that the rule forwards DNS queries for and the ID of the outbound
Resolver endpoint that the rule is associated with}
\usage{
route53resolver_get_resolver_rule(ResolverRuleId)
}
\arguments{
\item{ResolverRuleId}{[required] The ID of the Resolver rule that you want to get information about.}
}
\value{
A list with the following syntax:\preformatted{list(
  ResolverRule = list(
    Id = "string",
    CreatorRequestId = "string",
    Arn = "string",
    DomainName = "string",
    Status = "COMPLETE"|"DELETING"|"UPDATING"|"FAILED",
    StatusMessage = "string",
    RuleType = "FORWARD"|"SYSTEM"|"RECURSIVE",
    Name = "string",
    TargetIps = list(
      list(
        Ip = "string",
        Port = 123
      )
    ),
    ResolverEndpointId = "string",
    OwnerId = "string",
    ShareStatus = "NOT_SHARED"|"SHARED_WITH_ME"|"SHARED_BY_ME",
    CreationTime = "string",
    ModificationTime = "string"
  )
)
}
}
\description{
Gets information about a specified Resolver rule, such as the domain
name that the rule forwards DNS queries for and the ID of the outbound
Resolver endpoint that the rule is associated with.
}
\section{Request syntax}{
\preformatted{svc$get_resolver_rule(
  ResolverRuleId = "string"
)
}
}

\keyword{internal}
