% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_delete_load_balancer_listeners}
\alias{elb_delete_load_balancer_listeners}
\title{Deletes the specified listeners from the specified load balancer}
\usage{
elb_delete_load_balancer_listeners(LoadBalancerName, LoadBalancerPorts)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.}

\item{LoadBalancerPorts}{[required] The client port numbers of the listeners.}
}
\value{
An empty list.
}
\description{
Deletes the specified listeners from the specified load balancer.
}
\section{Request syntax}{
\preformatted{svc$delete_load_balancer_listeners(
  LoadBalancerName = "string",
  LoadBalancerPorts = list(
    123
  )
)
}
}

\examples{
\dontrun{
# This example deletes the listener for the specified port from the
# specified load balancer.
svc$delete_load_balancer_listeners(
  LoadBalancerName = "my-load-balancer",
  LoadBalancerPorts = list(
    80L
  )
)
}

}
\keyword{internal}
