% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_tags_for_resources}
\alias{route53_list_tags_for_resources}
\title{Lists tags for up to 10 health checks or hosted zones}
\usage{
route53_list_tags_for_resources(ResourceType, ResourceIds)
}
\arguments{
\item{ResourceType}{[required] The type of the resources.
\itemize{
\item The resource type for health checks is \code{healthcheck}.
\item The resource type for hosted zones is \code{hostedzone}.
}}

\item{ResourceIds}{[required] A complex type that contains the ResourceId element for each resource
for which you want to get a list of tags.}
}
\description{
Lists tags for up to 10 health checks or hosted zones.

For information about using tags for cost allocation, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html}{Using Cost Allocation Tags}
in the \emph{AWS Billing and Cost Management User Guide}.
}
\section{Request syntax}{
\preformatted{svc$list_tags_for_resources(
  ResourceType = "healthcheck"|"hostedzone",
  ResourceIds = list(
    "string"
  )
)
}
}

\keyword{internal}
