% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_get_reusable_delegation_set_limit}
\alias{route53_get_reusable_delegation_set_limit}
\title{Gets the maximum number of hosted zones that you can associate with the
specified reusable delegation set}
\usage{
route53_get_reusable_delegation_set_limit(Type, DelegationSetId)
}
\arguments{
\item{Type}{[required] Specify \code{MAX_ZONES_BY_REUSABLE_DELEGATION_SET} to get the maximum number
of hosted zones that you can associate with the specified reusable
delegation set.}

\item{DelegationSetId}{[required] The ID of the delegation set that you want to get the limit for.}
}
\description{
Gets the maximum number of hosted zones that you can associate with the
specified reusable delegation set.
}
\details{
For the default limit, see
\href{http://docs.aws.amazon.com/Route53/latest/DeveloperGuide/DNSLimitations.html}{Limits}
in the \emph{Amazon Route 53 Developer Guide}. To request a higher limit,
\href{https://console.aws.amazon.com/support/home#/case/create?issueType=service-limit-increase&limitType=service-code-route53}{open a case}.
}
\section{Request syntax}{
\preformatted{svc$get_reusable_delegation_set_limit(
  Type = "MAX_ZONES_BY_REUSABLE_DELEGATION_SET",
  DelegationSetId = "string"
)
}
}

\keyword{internal}
