% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elb_operations.R
\name{elb_create_load_balancer}
\alias{elb_create_load_balancer}
\title{Creates a Classic Load Balancer}
\usage{
elb_create_load_balancer(LoadBalancerName, Listeners, AvailabilityZones,
  Subnets, SecurityGroups, Scheme, Tags)
}
\arguments{
\item{LoadBalancerName}{[required] The name of the load balancer.

This name must be unique within your set of load balancers for the
region, must have a maximum of 32 characters, must contain only
alphanumeric characters or hyphens, and cannot begin or end with a
hyphen.}

\item{Listeners}{[required] The listeners.

For more information, see \href{http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-listener-config.html}{Listeners for Your Classic Load Balancer}
in the \emph{Classic Load Balancers Guide}.}

\item{AvailabilityZones}{One or more Availability Zones from the same region as the load
balancer.

You must specify at least one Availability Zone.

You can add more Availability Zones after you create the load balancer
using EnableAvailabilityZonesForLoadBalancer.}

\item{Subnets}{The IDs of the subnets in your VPC to attach to the load balancer.
Specify one subnet per Availability Zone specified in
\code{AvailabilityZones}.}

\item{SecurityGroups}{The IDs of the security groups to assign to the load balancer.}

\item{Scheme}{The type of a load balancer. Valid only for load balancers in a VPC.

By default, Elastic Load Balancing creates an Internet-facing load
balancer with a DNS name that resolves to public IP addresses. For more
information about Internet-facing and Internal load balancers, see \href{http://docs.aws.amazon.com/elasticloadbalancing/latest/userguide/how-elastic-load-balancing-works.html#load-balancer-scheme}{Load Balancer Scheme}
in the \emph{Elastic Load Balancing User Guide}.

Specify \code{internal} to create a load balancer with a DNS name that
resolves to private IP addresses.}

\item{Tags}{A list of tags to assign to the load balancer.

For more information about tagging your load balancer, see \href{http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/add-remove-tags.html}{Tag Your Classic Load Balancer}
in the \emph{Classic Load Balancers Guide}.}
}
\description{
Creates a Classic Load Balancer.
}
\details{
You can add listeners, security groups, subnets, and tags when you
create your load balancer, or you can add them later using
CreateLoadBalancerListeners, ApplySecurityGroupsToLoadBalancer,
AttachLoadBalancerToSubnets, and AddTags.

To describe your current load balancers, see DescribeLoadBalancers. When
you are finished with a load balancer, you can delete it using
DeleteLoadBalancer.

You can create up to 20 load balancers per region per account. You can
request an increase for the number of load balancers for your account.
For more information, see \href{http://docs.aws.amazon.com/elasticloadbalancing/latest/classic/elb-limits.html}{Limits for Your Classic Load Balancer}
in the \emph{Classic Load Balancers Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_load_balancer(
  LoadBalancerName = "string",
  Listeners = list(
    list(
      Protocol = "string",
      LoadBalancerPort = 123,
      InstanceProtocol = "string",
      InstancePort = 123,
      SSLCertificateId = "string"
    )
  ),
  AvailabilityZones = list(
    "string"
  ),
  Subnets = list(
    "string"
  ),
  SecurityGroups = list(
    "string"
  ),
  Scheme = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\examples{
# This example creates a load balancer with an HTTP listener in a VPC.
\donttest{svc$create_load_balancer(
  Listeners = list(
    list(
      InstancePort = 80L,
      InstanceProtocol = "HTTP",
      LoadBalancerPort = 80L,
      Protocol = "HTTP"
    )
  ),
  LoadBalancerName = "my-load-balancer",
  SecurityGroups = list(
    "sg-a61988c3"
  ),
  Subnets = list(
    "subnet-15aaab61"
  )
)}

# This example creates a load balancer with an HTTP listener in
# EC2-Classic.
\donttest{svc$create_load_balancer(
  AvailabilityZones = list(
    "us-west-2a"
  ),
  Listeners = list(
    list(
      InstancePort = 80L,
      InstanceProtocol = "HTTP",
      LoadBalancerPort = 80L,
      Protocol = "HTTP"
    )
  ),
  LoadBalancerName = "my-load-balancer"
)}

# This example creates a load balancer with an HTTPS listener in a VPC.
\donttest{svc$create_load_balancer(
  Listeners = list(
    list(
      InstancePort = 80L,
      InstanceProtocol = "HTTP",
      LoadBalancerPort = 80L,
      Protocol = "HTTP"
    ),
    list(
      InstancePort = 80L,
      InstanceProtocol = "HTTP",
      LoadBalancerPort = 443L,
      Protocol = "HTTPS",
      SSLCertificateId = "arn:aws:iam::123456789012:server-certificate/my-server-cert"
    )
  ),
  LoadBalancerName = "my-load-balancer",
  SecurityGroups = list(
    "sg-a61988c3"
  ),
  Subnets = list(
    "subnet-15aaab61"
  )
)}

# This example creates a load balancer with an HTTPS listener in
# EC2-Classic.
\donttest{svc$create_load_balancer(
  AvailabilityZones = list(
    "us-west-2a"
  ),
  Listeners = list(
    list(
      InstancePort = 80L,
      InstanceProtocol = "HTTP",
      LoadBalancerPort = 80L,
      Protocol = "HTTP"
    ),
    list(
      InstancePort = 80L,
      InstanceProtocol = "HTTP",
      LoadBalancerPort = 443L,
      Protocol = "HTTPS",
      SSLCertificateId = "arn:aws:iam::123456789012:server-certificate/my-server-cert"
    )
  ),
  LoadBalancerName = "my-load-balancer"
)}

# This example creates an internal load balancer with an HTTP listener in
# a VPC.
\donttest{svc$create_load_balancer(
  Listeners = list(
    list(
      InstancePort = 80L,
      InstanceProtocol = "HTTP",
      LoadBalancerPort = 80L,
      Protocol = "HTTP"
    )
  ),
  LoadBalancerName = "my-load-balancer",
  Scheme = "internal",
  SecurityGroups = list(
    "sg-a61988c3"
  ),
  Subnets = list(
    "subnet-15aaab61"
  )
)}

}
\keyword{internal}
