% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_partner_app}
\alias{sagemaker_update_partner_app}
\title{Updates all of the SageMaker Partner AI Apps in an account}
\usage{
sagemaker_update_partner_app(
  Arn,
  MaintenanceConfig = NULL,
  Tier = NULL,
  ApplicationConfig = NULL,
  EnableIamSessionBasedIdentity = NULL,
  ClientToken = NULL,
  Tags = NULL
)
}
\arguments{
\item{Arn}{[required] The ARN of the SageMaker Partner AI App to update.}

\item{MaintenanceConfig}{Maintenance configuration settings for the SageMaker Partner AI App.}

\item{Tier}{Indicates the instance type and size of the cluster attached to the
SageMaker Partner AI App.}

\item{ApplicationConfig}{Configuration settings for the SageMaker Partner AI App.}

\item{EnableIamSessionBasedIdentity}{When set to \code{TRUE}, the SageMaker Partner AI App sets the Amazon Web
Services IAM session name or the authenticated IAM user as the identity
of the SageMaker Partner AI App user.}

\item{ClientToken}{A unique token that guarantees that the call to this API is idempotent.}

\item{Tags}{Each tag consists of a key and an optional value. Tag keys must be
unique per resource.}
}
\description{
Updates all of the SageMaker Partner AI Apps in an account.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_update_partner_app/} for full documentation.
}
\keyword{internal}
