% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_code_repository}
\alias{sagemaker_create_code_repository}
\title{Creates a Git repository as a resource in your SageMaker AI account}
\usage{
sagemaker_create_code_repository(CodeRepositoryName, GitConfig, Tags = NULL)
}
\arguments{
\item{CodeRepositoryName}{[required] The name of the Git repository. The name must have 1 to 63 characters.
Valid characters are a-z, A-Z, 0-9, and - (hyphen).}

\item{GitConfig}{[required] Specifies details about the repository, including the URL where the
repository is located, the default branch, and credentials to use to
access the repository.}

\item{Tags}{An array of key-value pairs. You can use tags to categorize your Amazon
Web Services resources in different ways, for example, by purpose,
owner, or environment. For more information, see \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services Resources}.}
}
\description{
Creates a Git repository as a resource in your SageMaker AI account. You can associate the repository with notebook instances so that you can use Git source control for the notebooks you create. The Git repository is a resource in your SageMaker AI account, so it can be associated with more than one notebook instance, and it persists independently from the lifecycle of any notebook instances it is associated with.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_code_repository/} for full documentation.
}
\keyword{internal}
