% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_start_person_tracking}
\alias{rekognition_start_person_tracking}
\title{Starts the asynchronous tracking of a person's path in a stored video}
\usage{
rekognition_start_person_tracking(
  Video,
  ClientRequestToken = NULL,
  NotificationChannel = NULL,
  JobTag = NULL
)
}
\arguments{
\item{Video}{[required] The video in which you want to detect people. The video must be stored
in an Amazon S3 bucket.}

\item{ClientRequestToken}{Idempotent token used to identify the start request. If you use the same
token with multiple
\code{\link[=rekognition_start_person_tracking]{start_person_tracking}} requests,
the same \code{JobId} is returned. Use \code{ClientRequestToken} to prevent the
same job from being accidently started more than once.}

\item{NotificationChannel}{The Amazon SNS topic ARN you want Amazon Rekognition Video to publish
the completion status of the people detection operation to. The Amazon
SNS topic must have a topic name that begins with \emph{AmazonRekognition} if
you are using the AmazonRekognitionServiceRole permissions policy.}

\item{JobTag}{An identifier you specify that's returned in the completion notification
that's published to your Amazon Simple Notification Service topic. For
example, you can use \code{JobTag} to group related jobs and identify them in
the completion notification.}
}
\description{
Starts the asynchronous tracking of a person's path in a stored video.

See \url{https://www.paws-r-sdk.com/docs/rekognition_start_person_tracking/} for full documentation.
}
\keyword{internal}
