% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_experiment}
\alias{sagemaker_create_experiment}
\title{Creates a SageMaker experiment}
\usage{
sagemaker_create_experiment(
  ExperimentName,
  DisplayName = NULL,
  Description = NULL,
  Tags = NULL
)
}
\arguments{
\item{ExperimentName}{[required] The name of the experiment. The name must be unique in your Amazon Web
Services account and is not case-sensitive.}

\item{DisplayName}{The name of the experiment as displayed. The name doesn't need to be
unique. If you don't specify \code{DisplayName}, the value in
\code{ExperimentName} is displayed.}

\item{Description}{The description of the experiment.}

\item{Tags}{A list of tags to associate with the experiment. You can use
\code{\link[=sagemaker_search]{search}} API to search on the tags.}
}
\description{
Creates a SageMaker \emph{experiment}. An experiment is a collection of \emph{trials} that are observed, compared and evaluated as a group. A trial is a set of steps, called \emph{trial components}, that produce a machine learning model.

See \url{https://www.paws-r-sdk.com/docs/sagemaker_create_experiment/} for full documentation.
}
\keyword{internal}
