% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/voiceid_operations.R
\name{voiceid_list_fraudster_registration_jobs}
\alias{voiceid_list_fraudster_registration_jobs}
\title{Lists all the fraudster registration jobs in the domain with the given
JobStatus}
\usage{
voiceid_list_fraudster_registration_jobs(
  DomainId,
  JobStatus = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DomainId}{[required] The identifier of the domain containing the fraudster registration Jobs.}

\item{JobStatus}{Provides the status of your fraudster registration job.}

\item{MaxResults}{The maximum number of results that are returned per call. You can use
\code{NextToken} to obtain further pages of results. The default is 100; the
maximum allowed page size is also 100.}

\item{NextToken}{If \code{NextToken} is returned, there are more results available. The value
of \code{NextToken} is a unique pagination token for each page. Make the call
again using the returned token to retrieve the next page. Keep all other
arguments unchanged. Each pagination token expires after 24 hours.}
}
\description{
Lists all the fraudster registration jobs in the domain with the given \code{JobStatus}. If \code{JobStatus} is not provided, this lists all fraudster registration jobs in the given domain.

See \url{https://paws-r.github.io/docs/voiceid/list_fraudster_registration_jobs.html} for full documentation.
}
\keyword{internal}
