% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_transform_job}
\alias{sagemaker_create_transform_job}
\title{Starts a transform job}
\usage{
sagemaker_create_transform_job(
  TransformJobName,
  ModelName,
  MaxConcurrentTransforms = NULL,
  ModelClientConfig = NULL,
  MaxPayloadInMB = NULL,
  BatchStrategy = NULL,
  Environment = NULL,
  TransformInput,
  TransformOutput,
  TransformResources,
  DataProcessing = NULL,
  Tags = NULL,
  ExperimentConfig = NULL
)
}
\arguments{
\item{TransformJobName}{[required] The name of the transform job. The name must be unique within an Amazon
Web Services Region in an Amazon Web Services account.}

\item{ModelName}{[required] The name of the model that you want to use for the transform job.
\code{ModelName} must be the name of an existing Amazon SageMaker model
within an Amazon Web Services Region in an Amazon Web Services account.}

\item{MaxConcurrentTransforms}{The maximum number of parallel requests that can be sent to each
instance in a transform job. If \code{MaxConcurrentTransforms} is set to \code{0}
or left unset, Amazon SageMaker checks the optional execution-parameters
to determine the settings for your chosen algorithm. If the
execution-parameters endpoint is not enabled, the default value is \code{1}.
For more information on execution-parameters, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/your-algorithms-batch-code.html#your-algorithms-batch-code-how-containe-serves-requests}{How Containers Serve Requests}.
For built-in algorithms, you don't need to set a value for
\code{MaxConcurrentTransforms}.}

\item{ModelClientConfig}{Configures the timeout and maximum number of retries for processing a
transform job invocation.}

\item{MaxPayloadInMB}{The maximum allowed size of the payload, in MB. A \emph{payload} is the data
portion of a record (without metadata). The value in \code{MaxPayloadInMB}
must be greater than, or equal to, the size of a single record. To
estimate the size of a record in MB, divide the size of your dataset by
the number of records. To ensure that the records fit within the maximum
payload size, we recommend using a slightly larger value. The default
value is \code{6} MB.

The value of \code{MaxPayloadInMB} cannot be greater than 100 MB. If you
specify the \code{MaxConcurrentTransforms} parameter, the value of
\code{(MaxConcurrentTransforms * MaxPayloadInMB)} also cannot exceed 100 MB.

For cases where the payload might be arbitrarily large and is
transmitted using HTTP chunked encoding, set the value to \code{0}. This
feature works only in supported algorithms. Currently, Amazon SageMaker
built-in algorithms do not support HTTP chunked encoding.}

\item{BatchStrategy}{Specifies the number of records to include in a mini-batch for an HTTP
inference request. A \emph{record} is a single unit of input data that
inference can be made on. For example, a single line in a CSV file is a
record.

To enable the batch strategy, you must set the \code{SplitType} property to
\code{Line}, \code{RecordIO}, or \code{TFRecord}.

To use only one record when making an HTTP invocation request to a
container, set \code{BatchStrategy} to \code{SingleRecord} and \code{SplitType} to
\code{Line}.

To fit as many records in a mini-batch as can fit within the
\code{MaxPayloadInMB} limit, set \code{BatchStrategy} to \code{MultiRecord} and
\code{SplitType} to \code{Line}.}

\item{Environment}{The environment variables to set in the Docker container. We support up
to 16 key and values entries in the map.}

\item{TransformInput}{[required] Describes the input source and the way the transform job consumes it.}

\item{TransformOutput}{[required] Describes the results of the transform job.}

\item{TransformResources}{[required] Describes the resources, including ML instance types and ML instance
count, to use for the transform job.}

\item{DataProcessing}{The data structure used to specify the data to be used for inference in
a batch transform job and to associate the data that is relevant to the
prediction results in the output. The input filter provided allows you
to exclude input data that is not needed for inference in a batch
transform job. The output filter provided allows you to include input
data relevant to interpreting the predictions in the output from the
job. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/batch-transform-data-processing.html}{Associate Prediction Results with their Corresponding Input Records}.}

\item{Tags}{(Optional) An array of key-value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what}{Using Cost Allocation Tags}
in the \emph{Amazon Web Services Billing and Cost Management User Guide}.}

\item{ExperimentConfig}{}
}
\description{
Starts a transform job. A transform job uses a trained model to get inferences on a dataset and saves these results to an Amazon S3 location that you specify.

See \url{https://paws-r.github.io/docs/sagemaker/create_transform_job.html} for full documentation.
}
\keyword{internal}
