% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_action}
\alias{sagemaker_create_action}
\title{Creates an action}
\usage{
sagemaker_create_action(
  ActionName,
  Source,
  ActionType,
  Description = NULL,
  Status = NULL,
  Properties = NULL,
  MetadataProperties = NULL,
  Tags = NULL
)
}
\arguments{
\item{ActionName}{[required] The name of the action. Must be unique to your account in an Amazon Web
Services Region.}

\item{Source}{[required] The source type, ID, and URI.}

\item{ActionType}{[required] The action type.}

\item{Description}{The description of the action.}

\item{Status}{The status of the action.}

\item{Properties}{A list of properties to add to the action.}

\item{MetadataProperties}{}

\item{Tags}{A list of tags to apply to the action.}
}
\description{
Creates an \emph{action}. An action is a lineage tracking entity that represents an action or activity. For example, a model deployment or an HPO job. Generally, an action involves at least one input or output artifact. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/lineage-tracking.html}{Amazon SageMaker ML Lineage Tracking}.

See \url{https://paws-r.github.io/docs/sagemaker/create_action.html} for full documentation.
}
\keyword{internal}
