% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/machinelearning_operations.R
\name{machinelearning_describe_ml_models}
\alias{machinelearning_describe_ml_models}
\title{Returns a list of MLModel that match the search criteria in the request}
\usage{
machinelearning_describe_ml_models(
  FilterVariable = NULL,
  EQ = NULL,
  GT = NULL,
  LT = NULL,
  GE = NULL,
  LE = NULL,
  NE = NULL,
  Prefix = NULL,
  SortOrder = NULL,
  NextToken = NULL,
  Limit = NULL
)
}
\arguments{
\item{FilterVariable}{Use one of the following variables to filter a list of \code{MLModel}:
\itemize{
\item \code{CreatedAt} - Sets the search criteria to \code{MLModel} creation date.
\item \code{Status} - Sets the search criteria to \code{MLModel} status.
\item \code{Name} - Sets the search criteria to the contents of \code{MLModel}
\code{Name}.
\item \code{IAMUser} - Sets the search criteria to the user account that
invoked the \code{MLModel} creation.
\item \code{TrainingDataSourceId} - Sets the search criteria to the
\code{DataSource} used to train one or more \code{MLModel}.
\item \code{RealtimeEndpointStatus} - Sets the search criteria to the \code{MLModel}
real-time endpoint status.
\item \code{MLModelType} - Sets the search criteria to \code{MLModel} type: binary,
regression, or multi-class.
\item \code{Algorithm} - Sets the search criteria to the algorithm that the
\code{MLModel} uses.
\item \code{TrainingDataURI} - Sets the search criteria to the data file(s)
used in training a \code{MLModel}. The URL can identify either a file or
an Amazon Simple Storage Service (Amazon S3) bucket or directory.
}}

\item{EQ}{The equal to operator. The \code{MLModel} results will have \code{FilterVariable}
values that exactly match the value specified with \code{EQ}.}

\item{GT}{The greater than operator. The \code{MLModel} results will have
\code{FilterVariable} values that are greater than the value specified with
\code{GT}.}

\item{LT}{The less than operator. The \code{MLModel} results will have \code{FilterVariable}
values that are less than the value specified with \code{LT}.}

\item{GE}{The greater than or equal to operator. The \code{MLModel} results will have
\code{FilterVariable} values that are greater than or equal to the value
specified with \code{GE}.}

\item{LE}{The less than or equal to operator. The \code{MLModel} results will have
\code{FilterVariable} values that are less than or equal to the value
specified with \code{LE}.}

\item{NE}{The not equal to operator. The \code{MLModel} results will have
\code{FilterVariable} values not equal to the value specified with \code{NE}.}

\item{Prefix}{A string that is found at the beginning of a variable, such as \code{Name} or
\code{Id}.

For example, an \code{MLModel} could have the \code{Name}
\code{2014-09-09-HolidayGiftMailer}. To search for this \code{MLModel}, select
\code{Name} for the \code{FilterVariable} and any of the following strings for the
\code{Prefix}:
\itemize{
\item 2014-09
\item 2014-09-09
\item 2014-09-09-Holiday
}}

\item{SortOrder}{A two-value parameter that determines the sequence of the resulting list
of \code{MLModel}.
\itemize{
\item \code{asc} - Arranges the list in ascending order (A-Z, 0-9).
\item \code{dsc} - Arranges the list in descending order (Z-A, 9-0).
}

Results are sorted by \code{FilterVariable}.}

\item{NextToken}{The ID of the page in the paginated results.}

\item{Limit}{The number of pages of information to include in the result. The range
of acceptable values is \code{1} through \code{100}. The default value is \code{100}.}
}
\description{
Returns a list of \code{MLModel} that match the search criteria in the request.

See \url{https://paws-r.github.io/docs/machinelearning/describe_ml_models.html} for full documentation.
}
\keyword{internal}
