% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_labeling_job}
\alias{sagemaker_create_labeling_job}
\title{Creates a job that uses workers to label the data objects in your input
dataset}
\usage{
sagemaker_create_labeling_job(LabelingJobName, LabelAttributeName,
  InputConfig, OutputConfig, RoleArn, LabelCategoryConfigS3Uri,
  StoppingConditions, LabelingJobAlgorithmsConfig, HumanTaskConfig, Tags)
}
\arguments{
\item{LabelingJobName}{[required] The name of the labeling job. This name is used to identify the job in a
list of labeling jobs.}

\item{LabelAttributeName}{[required] The attribute name to use for the label in the output manifest file.
This is the key for the key/value pair formed with the label that a
worker assigns to the object. The name can\'t end with \"-metadata\". If
you are running a semantic segmentation labeling job, the attribute name
must end with \"-ref\". If you are running any other kind of labeling
job, the attribute name must not end with \"-ref\".}

\item{InputConfig}{[required] Input data for the labeling job, such as the Amazon S3 location of the
data objects and the location of the manifest file that describes the
data objects.}

\item{OutputConfig}{[required] The location of the output data and the AWS Key Management Service key
ID for the key used to encrypt the output data, if any.}

\item{RoleArn}{[required] The Amazon Resource Number (ARN) that Amazon SageMaker assumes to
perform tasks on your behalf during data labeling. You must grant this
role the necessary permissions so that Amazon SageMaker can successfully
complete data labeling.}

\item{LabelCategoryConfigS3Uri}{The S3 URL of the file that defines the categories used to label the
data objects.

For 3D point cloud task types, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sms-point-cloud-label-category-config.html}{Create a Labeling Category Configuration File for 3D Point Cloud Labeling Jobs}.

For all other \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sms-task-types.html}{built-in task types}
and \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sms-custom-templates.html}{custom tasks},
your label category configuration file must be a JSON file in the
following format. Identify the labels you want to use by replacing
\code{label_1}, \code{label_2},\code{...},\code{label_n} with your label categories.

\verb{\\\{}

\code{ "document-version": "2018-11-28"}

\verb{ "labels": \\\[}

\verb{ \\\{}

\code{ "label": "<i>label_1</i>"}

\verb{ \\\},}

\verb{ \\\{}

\code{ "label": "<i>label_2</i>"}

\verb{ \\\},}

\code{ ...}

\verb{ \\\{}

\code{ "label": "<i>label_n</i>"}

\verb{ \\\}}

\verb{ \\\]}

\verb{\\\}}}

\item{StoppingConditions}{A set of conditions for stopping the labeling job. If any of the
conditions are met, the job is automatically stopped. You can use these
conditions to control the cost of data labeling.}

\item{LabelingJobAlgorithmsConfig}{Configures the information required to perform automated data labeling.}

\item{HumanTaskConfig}{[required] Configures the labeling task and how it is presented to workers;
including, but not limited to price, keywords, and batch size (task
count).}

\item{Tags}{An array of key/value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what}{Using Cost Allocation Tags}
in the \emph{AWS Billing and Cost Management User Guide}.}
}
\description{
Creates a job that uses workers to label the data objects in your input
dataset. You can use the labeled data to train machine learning models.
}
\details{
You can select your workforce from one of three providers:
\itemize{
\item A private workforce that you create. It can include employees,
contractors, and outside experts. Use a private workforce when want
the data to stay within your organization or when a specific set of
skills is required.
\item One or more vendors that you select from the AWS Marketplace.
Vendors provide expertise in specific areas.
\item The Amazon Mechanical Turk workforce. This is the largest workforce,
but it should only be used for public data or data that has been
stripped of any personally identifiable information.
}

You can also use \emph{automated data labeling} to reduce the number of data
objects that need to be labeled by a human. Automated data labeling uses
\emph{active learning} to determine if a data object can be labeled by
machine or if it needs to be sent to a human worker. For more
information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sms-automated-labeling.html}{Using Automated Data Labeling}.

The data objects to be labeled are contained in an Amazon S3 bucket. You
create a \emph{manifest file} that describes the location of each object. For
more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sms-data.html}{Using Input and Output Data}.

The output can be used as the manifest file for another labeling job or
as training data for your machine learning models.
}
\section{Request syntax}{
\preformatted{svc$create_labeling_job(
  LabelingJobName = "string",
  LabelAttributeName = "string",
  InputConfig = list(
    DataSource = list(
      S3DataSource = list(
        ManifestS3Uri = "string"
      )
    ),
    DataAttributes = list(
      ContentClassifiers = list(
        "FreeOfPersonallyIdentifiableInformation"|"FreeOfAdultContent"
      )
    )
  ),
  OutputConfig = list(
    S3OutputPath = "string",
    KmsKeyId = "string"
  ),
  RoleArn = "string",
  LabelCategoryConfigS3Uri = "string",
  StoppingConditions = list(
    MaxHumanLabeledObjectCount = 123,
    MaxPercentageOfInputDatasetLabeled = 123
  ),
  LabelingJobAlgorithmsConfig = list(
    LabelingJobAlgorithmSpecificationArn = "string",
    InitialActiveLearningModelArn = "string",
    LabelingJobResourceConfig = list(
      VolumeKmsKeyId = "string"
    )
  ),
  HumanTaskConfig = list(
    WorkteamArn = "string",
    UiConfig = list(
      UiTemplateS3Uri = "string",
      HumanTaskUiArn = "string"
    ),
    PreHumanTaskLambdaArn = "string",
    TaskKeywords = list(
      "string"
    ),
    TaskTitle = "string",
    TaskDescription = "string",
    NumberOfHumanWorkersPerDataObject = 123,
    TaskTimeLimitInSeconds = 123,
    TaskAvailabilityLifetimeInSeconds = 123,
    MaxConcurrentTaskCount = 123,
    AnnotationConsolidationConfig = list(
      AnnotationConsolidationLambdaArn = "string"
    ),
    PublicWorkforceTaskPrice = list(
      AmountInUsd = list(
        Dollars = 123,
        Cents = 123,
        TenthFractionsOfACent = 123
      )
    )
  ),
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
