% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_get_slot_type}
\alias{lexmodelbuildingservice_get_slot_type}
\title{Returns information about a specific version of a slot type}
\usage{
lexmodelbuildingservice_get_slot_type(name, version)
}
\arguments{
\item{name}{[required] The name of the slot type. The name is case sensitive.}

\item{version}{[required] The version of the slot type.}
}
\description{
Returns information about a specific version of a slot type. In addition
to specifying the slot type name, you must specify the slot type
version.
}
\details{
This operation requires permissions for the \code{lex:GetSlotType} action.
}
\section{Request syntax}{
\preformatted{svc$get_slot_type(
  name = "string",
  version = "string"
)
}
}

\examples{
\dontrun{
# This example shows how to get information about a slot type.
svc$get_slot_type(
  version = "$LATEST",
  name = "DocPizzaCrustType"
)
}

}
\keyword{internal}
