% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_get_person_tracking}
\alias{rekognition_get_person_tracking}
\title{Gets the path tracking results of a Amazon Rekognition Video analysis
started by StartPersonTracking}
\usage{
rekognition_get_person_tracking(JobId, MaxResults, NextToken, SortBy)
}
\arguments{
\item{JobId}{[required] The identifier for a job that tracks persons in a video. You get the
\code{JobId} from a call to \code{StartPersonTracking}.}

\item{MaxResults}{Maximum number of results to return per paginated call. The largest
value you can specify is 1000. If you specify a value greater than 1000,
a maximum of 1000 results is returned. The default value is 1000.}

\item{NextToken}{If the previous response was incomplete (because there are more persons
to retrieve), Amazon Rekognition Video returns a pagination token in the
response. You can use this pagination token to retrieve the next set of
persons.}

\item{SortBy}{Sort to use for elements in the \code{Persons} array. Use \code{TIMESTAMP} to sort
array elements by the time persons are detected. Use \code{INDEX} to sort by
the tracked persons. If you sort by \code{INDEX}, the array elements for each
person are sorted by detection confidence. The default sort is by
\code{TIMESTAMP}.}
}
\description{
Gets the path tracking results of a Amazon Rekognition Video analysis
started by StartPersonTracking.
}
\details{
The person path tracking operation is started by a call to
\code{StartPersonTracking} which returns a job identifier (\code{JobId}). When the
operation finishes, Amazon Rekognition Video publishes a completion
status to the Amazon Simple Notification Service topic registered in the
initial call to \code{StartPersonTracking}.

To get the results of the person path tracking operation, first check
that the status value published to the Amazon SNS topic is \code{SUCCEEDED}.
If so, call GetPersonTracking and pass the job identifier (\code{JobId}) from
the initial call to \code{StartPersonTracking}.

\code{GetPersonTracking} returns an array, \code{Persons}, of tracked persons and
the time(s) their paths were tracked in the video.

\code{GetPersonTracking} only returns the default facial attributes
(\code{BoundingBox}, \code{Confidence}, \code{Landmarks}, \code{Pose}, and \code{Quality}). The
other facial attributes listed in the \code{Face} object of the following
response syntax are not returned.

For more information, see FaceDetail in the Amazon Rekognition Developer
Guide.

By default, the array is sorted by the time(s) a person's path is
tracked in the video. You can sort by tracked persons by specifying
\code{INDEX} for the \code{SortBy} input parameter.

Use the \code{MaxResults} parameter to limit the number of items returned. If
there are more results than specified in \code{MaxResults}, the value of
\code{NextToken} in the operation response contains a pagination token for
getting the next set of results. To get the next page of results, call
\code{GetPersonTracking} and populate the \code{NextToken} request parameter with
the token value returned from the previous call to \code{GetPersonTracking}.
}
\section{Request syntax}{
\preformatted{svc$get_person_tracking(
  JobId = "string",
  MaxResults = 123,
  NextToken = "string",
  SortBy = "INDEX"|"TIMESTAMP"
)
}
}

\keyword{internal}
