% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lexmodelbuildingservice_operations.R
\name{lexmodelbuildingservice_get_slot_type_versions}
\alias{lexmodelbuildingservice_get_slot_type_versions}
\title{Gets information about all versions of a slot type}
\usage{
lexmodelbuildingservice_get_slot_type_versions(name, nextToken,
  maxResults)
}
\arguments{
\item{name}{[required] The name of the slot type for which versions should be returned.}

\item{nextToken}{A pagination token for fetching the next page of slot type versions. If
the response to this call is truncated, Amazon Lex returns a pagination
token in the response. To fetch the next page of versions, specify the
pagination token in the next request.}

\item{maxResults}{The maximum number of slot type versions to return in the response. The
default is 10.}
}
\description{
Gets information about all versions of a slot type.
}
\details{
The \code{GetSlotTypeVersions} operation returns a \code{SlotTypeMetadata} object
for each version of a slot type. For example, if a slot type has three
numbered versions, the \code{GetSlotTypeVersions} operation returns four
\code{SlotTypeMetadata} objects in the response, one for each numbered
version and one for the \code{$LATEST} version.

The \code{GetSlotTypeVersions} operation always returns at least one version,
the \code{$LATEST} version.

This operation requires permissions for the \code{lex:GetSlotTypeVersions}
action.
}
\section{Request syntax}{
\preformatted{svc$get_slot_type_versions(
  name = "string",
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
