% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_search_faces_by_image}
\alias{rekognition_search_faces_by_image}
\title{For a given input image, first detects the largest face in the image,
and then searches the specified collection for matching faces}
\usage{
rekognition_search_faces_by_image(CollectionId, Image, MaxFaces,
  FaceMatchThreshold)
}
\arguments{
\item{CollectionId}{[required] ID of the collection to search.}

\item{Image}{[required] The input image as base64-encoded bytes or an S3 object. If you use the
AWS CLI to call Amazon Rekognition operations, passing base64-encoded
image bytes is not supported.

If you are using an AWS SDK to call Amazon Rekognition, you might not
need to base64-encode image bytes passed using the \code{Bytes} field. For
more information, see Images in the Amazon Rekognition developer guide.}

\item{MaxFaces}{Maximum number of faces to return. The operation returns the maximum
number of faces with the highest confidence in the match.}

\item{FaceMatchThreshold}{(Optional) Specifies the minimum confidence in the face match to return.
For example, don't return any matches where confidence in matches is
less than 70\%.}
}
\description{
For a given input image, first detects the largest face in the image,
and then searches the specified collection for matching faces. The
operation compares the features of the input face with faces in the
specified collection.
}
\details{
To search for all faces in an input image, you might first call the
IndexFaces operation, and then use the face IDs returned in subsequent
calls to the SearchFaces operation.

You can also call the \code{DetectFaces} operation and use the bounding boxes
in the response to make face crops, which then you can pass in to the
\code{SearchFacesByImage} operation.

You pass the input image either as base64-encoded image bytes or as a
reference to an image in an Amazon S3 bucket. If you use the AWS CLI to
call Amazon Rekognition operations, passing image bytes is not
supported. The image must be either a PNG or JPEG formatted file.

The response returns an array of faces that match, ordered by similarity
score with the highest similarity first. More specifically, it is an
array of metadata for each face match found. Along with the metadata,
the response also includes a \code{similarity} indicating how similar the
face is to the input face. In the response, the operation also returns
the bounding box (and a confidence level that the bounding box contains
a face) of the face that Amazon Rekognition used for the input image.

For an example, Searching for a Face Using an Image in the Amazon
Rekognition Developer Guide.

This operation requires permissions to perform the
\code{rekognition:SearchFacesByImage} action.
}
\section{Request syntax}{
\preformatted{svc$search_faces_by_image(
  CollectionId = "string",
  Image = list(
    Bytes = raw,
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  ),
  MaxFaces = 123,
  FaceMatchThreshold = 123.0
)
}
}

\examples{
# This operation searches for faces in a Rekognition collection that match
# the largest face in an S3 bucket stored image.
\donttest{svc$search_faces_by_image(
  CollectionId = "myphotos",
  FaceMatchThreshold = 95L,
  Image = list(
    S3Object = list(
      Bucket = "mybucket",
      Name = "myphoto"
    )
  ),
  MaxFaces = 5L
)}

}
\keyword{internal}
