% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_update_vocabulary}
\alias{transcribeservice_update_vocabulary}
\title{Updates an existing vocabulary with new values}
\usage{
transcribeservice_update_vocabulary(VocabularyName, LanguageCode,
  Phrases, VocabularyFileUri)
}
\arguments{
\item{VocabularyName}{[required] The name of the vocabulary to update. The name is case sensitive. If you
try to update a vocabulary with the same name as a previous vocabulary
you will receive a \code{ConflictException} error.}

\item{LanguageCode}{[required] The language code of the vocabulary entries.}

\item{Phrases}{An array of strings containing the vocabulary entries.}

\item{VocabularyFileUri}{The S3 location of the text file that contains the definition of the
custom vocabulary. The URI must be in the same region as the API
endpoint that you are calling. The general form is

For example:

For more information about S3 object names, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/UsingMetadata.html#object-keys}{Object Keys}
in the \emph{Amazon S3 Developer Guide}.

For more information about custom vocabularies, see \href{https://docs.aws.amazon.com/transcribe/latest/dg/how-it-works.html#how-vocabulary}{Custom Vocabularies}.}
}
\value{
A list with the following syntax:\preformatted{list(
  VocabularyName = "string",
  LanguageCode = "af-ZA"|"ar-AE"|"ar-SA"|"cy-GB"|"da-DK"|"de-CH"|"de-DE"|"en-AB"|"en-AU"|"en-GB"|"en-IE"|"en-IN"|"en-US"|"en-WL"|"es-ES"|"es-US"|"fa-IR"|"fr-CA"|"fr-FR"|"ga-IE"|"gd-GB"|"he-IL"|"hi-IN"|"id-ID"|"it-IT"|"ja-JP"|"ko-KR"|"ms-MY"|"nl-NL"|"pt-BR"|"pt-PT"|"ru-RU"|"ta-IN"|"te-IN"|"tr-TR"|"zh-CN",
  LastModifiedTime = as.POSIXct(
    "2015-01-01"
  ),
  VocabularyState = "PENDING"|"READY"|"FAILED"
)
}
}
\description{
Updates an existing vocabulary with new values. The
\code{\link[=transcribeservice_update_vocabulary]{update_vocabulary}} operation
overwrites all of the existing information with the values that you
provide in the request.
}
\section{Request syntax}{
\preformatted{svc$update_vocabulary(
  VocabularyName = "string",
  LanguageCode = "af-ZA"|"ar-AE"|"ar-SA"|"cy-GB"|"da-DK"|"de-CH"|"de-DE"|"en-AB"|"en-AU"|"en-GB"|"en-IE"|"en-IN"|"en-US"|"en-WL"|"es-ES"|"es-US"|"fa-IR"|"fr-CA"|"fr-FR"|"ga-IE"|"gd-GB"|"he-IL"|"hi-IN"|"id-ID"|"it-IT"|"ja-JP"|"ko-KR"|"ms-MY"|"nl-NL"|"pt-BR"|"pt-PT"|"ru-RU"|"ta-IN"|"te-IN"|"tr-TR"|"zh-CN",
  Phrases = list(
    "string"
  ),
  VocabularyFileUri = "string"
)
}
}

\keyword{internal}
