% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_update_image}
\alias{sagemaker_update_image}
\title{Updates the properties of a SageMaker image}
\usage{
sagemaker_update_image(DeleteProperties, Description, DisplayName,
  ImageName, RoleArn)
}
\arguments{
\item{DeleteProperties}{A list of properties to delete. Only the \code{Description} and \code{DisplayName}
properties can be deleted.}

\item{Description}{The new description for the image.}

\item{DisplayName}{The new display name for the image.}

\item{ImageName}{[required] The name of the image to update.}

\item{RoleArn}{The new Amazon Resource Name (ARN) for the IAM role that enables Amazon
SageMaker to perform tasks on your behalf.}
}
\value{
A list with the following syntax:\preformatted{list(
  ImageArn = "string"
)
}
}
\description{
Updates the properties of a SageMaker image. To change the image's tags,
use the \code{\link[=sagemaker_add_tags]{add_tags}} and
\code{\link[=sagemaker_delete_tags]{delete_tags}} APIs.
}
\section{Request syntax}{
\preformatted{svc$update_image(
  DeleteProperties = list(
    "string"
  ),
  Description = "string",
  DisplayName = "string",
  ImageName = "string",
  RoleArn = "string"
)
}
}

\keyword{internal}
