% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_get_label_detection}
\alias{rekognition_get_label_detection}
\title{Gets the label detection results of a Amazon Rekognition Video analysis
started by StartLabelDetection}
\usage{
rekognition_get_label_detection(JobId, MaxResults, NextToken, SortBy)
}
\arguments{
\item{JobId}{[required] Job identifier for the label detection operation for which you want
results returned. You get the job identifer from an initial call to
\code{StartlabelDetection}.}

\item{MaxResults}{Maximum number of results to return per paginated call. The largest
value you can specify is 1000. If you specify a value greater than 1000,
a maximum of 1000 results is returned. The default value is 1000.}

\item{NextToken}{If the previous response was incomplete (because there are more labels
to retrieve), Amazon Rekognition Video returns a pagination token in the
response. You can use this pagination token to retrieve the next set of
labels.}

\item{SortBy}{Sort to use for elements in the \code{Labels} array. Use \code{TIMESTAMP} to sort
array elements by the time labels are detected. Use \code{NAME} to
alphabetically group elements for a label together. Within each label
group, the array element are sorted by detection confidence. The default
sort is by \code{TIMESTAMP}.}
}
\value{
A list with the following syntax:\preformatted{list(
  JobStatus = "IN_PROGRESS"|"SUCCEEDED"|"FAILED",
  StatusMessage = "string",
  VideoMetadata = list(
    Codec = "string",
    DurationMillis = 123,
    Format = "string",
    FrameRate = 123.0,
    FrameHeight = 123,
    FrameWidth = 123
  ),
  NextToken = "string",
  Labels = list(
    list(
      Timestamp = 123,
      Label = list(
        Name = "string",
        Confidence = 123.0,
        Instances = list(
          list(
            BoundingBox = list(
              Width = 123.0,
              Height = 123.0,
              Left = 123.0,
              Top = 123.0
            ),
            Confidence = 123.0
          )
        ),
        Parents = list(
          list(
            Name = "string"
          )
        )
      )
    )
  ),
  LabelModelVersion = "string"
)
}
}
\description{
Gets the label detection results of a Amazon Rekognition Video analysis
started by \code{\link[=rekognition_start_label_detection]{start_label_detection}}.

The label detection operation is started by a call to
\code{\link[=rekognition_start_label_detection]{start_label_detection}} which
returns a job identifier (\code{JobId}). When the label detection operation
finishes, Amazon Rekognition publishes a completion status to the Amazon
Simple Notification Service topic registered in the initial call to
\code{StartlabelDetection}. To get the results of the label detection
operation, first check that the status value published to the Amazon SNS
topic is \code{SUCCEEDED}. If so, call
\code{\link[=rekognition_get_label_detection]{get_label_detection}} and pass the
job identifier (\code{JobId}) from the initial call to
\code{\link[=rekognition_start_label_detection]{start_label_detection}}.

\code{\link[=rekognition_get_label_detection]{get_label_detection}} returns an
array of detected labels (\code{Labels}) sorted by the time the labels were
detected. You can also sort by the label name by specifying \code{NAME} for
the \code{SortBy} input parameter.

The labels returned include the label name, the percentage confidence in
the accuracy of the detected label, and the time the label was detected
in the video.

The returned labels also include bounding box information for common
objects, a hierarchical taxonomy of detected labels, and the version of
the label model used for detection.

Use MaxResults parameter to limit the number of labels returned. If
there are more results than specified in \code{MaxResults}, the value of
\code{NextToken} in the operation response contains a pagination token for
getting the next set of results. To get the next page of results, call
\code{GetlabelDetection} and populate the \code{NextToken} request parameter with
the token value returned from the previous call to
\code{\link[=rekognition_get_label_detection]{get_label_detection}}.
}
\section{Request syntax}{
\preformatted{svc$get_label_detection(
  JobId = "string",
  MaxResults = 123,
  NextToken = "string",
  SortBy = "NAME"|"TIMESTAMP"
)
}
}

\keyword{internal}
