% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rekognition_operations.R
\name{rekognition_create_project_version}
\alias{rekognition_create_project_version}
\title{Creates a new version of a model and begins training}
\usage{
rekognition_create_project_version(ProjectArn, VersionName,
  OutputConfig, TrainingData, TestingData)
}
\arguments{
\item{ProjectArn}{[required] The ARN of the Amazon Rekognition Custom Labels project that manages the
model that you want to train.}

\item{VersionName}{[required] A name for the version of the model. This value must be unique.}

\item{OutputConfig}{[required] The Amazon S3 location to store the results of training.}

\item{TrainingData}{[required] The dataset to use for training.}

\item{TestingData}{[required] The dataset to use for testing.}
}
\value{
A list with the following syntax:\preformatted{list(
  ProjectVersionArn = "string"
)
}
}
\description{
Creates a new version of a model and begins training. Models are managed
as part of an Amazon Rekognition Custom Labels project. You can specify
one training dataset and one testing dataset. The response from
\code{\link[=rekognition_create_project_version]{create_project_version}} is an
Amazon Resource Name (ARN) for the version of the model.

Training takes a while to complete. You can get the current status by
calling
\code{\link[=rekognition_describe_project_versions]{describe_project_versions}}.

Once training has successfully completed, call
\code{\link[=rekognition_describe_project_versions]{describe_project_versions}} to
get the training results and evaluate the model.

After evaluating the model, you start the model by calling
\code{\link[=rekognition_start_project_version]{start_project_version}}.

This operation requires permissions to perform the
\code{rekognition:CreateProjectVersion} action.
}
\section{Request syntax}{
\preformatted{svc$create_project_version(
  ProjectArn = "string",
  VersionName = "string",
  OutputConfig = list(
    S3Bucket = "string",
    S3KeyPrefix = "string"
  ),
  TrainingData = list(
    Assets = list(
      list(
        GroundTruthManifest = list(
          S3Object = list(
            Bucket = "string",
            Name = "string",
            Version = "string"
          )
        )
      )
    )
  ),
  TestingData = list(
    Assets = list(
      list(
        GroundTruthManifest = list(
          S3Object = list(
            Bucket = "string",
            Name = "string",
            Version = "string"
          )
        )
      )
    ),
    AutoCreate = TRUE|FALSE
  )
)
}
}

\keyword{internal}
