% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/personalizeevents_operations.R
\name{personalizeevents_put_events}
\alias{personalizeevents_put_events}
\title{Records user interaction event data}
\usage{
personalizeevents_put_events(trackingId, userId, sessionId, eventList)
}
\arguments{
\item{trackingId}{[required] The tracking ID for the event. The ID is generated by a call to the
\href{https://docs.aws.amazon.com/personalize/latest/dg/API_CreateEventTracker.html}{CreateEventTracker}
API.}

\item{userId}{The user associated with the event.}

\item{sessionId}{[required] The session ID associated with the user's visit. Your application
generates the sessionId when a user first visits your website or uses
your application. Amazon Personalize uses the sessionId to associate
events with the user before they log in. For more information see
event-record-api.}

\item{eventList}{[required] A list of event data from the session.}
}
\value{
An empty list.
}
\description{
Records user interaction event data. For more information see
event-record-api.
}
\section{Request syntax}{
\preformatted{svc$put_events(
  trackingId = "string",
  userId = "string",
  sessionId = "string",
  eventList = list(
    list(
      eventId = "string",
      eventType = "string",
      eventValue = 123.0,
      itemId = "string",
      properties = "string",
      sentAt = as.POSIXct(
        "2015-01-01"
      ),
      recommendationId = "string",
      impression = list(
        "string"
      )
    )
  )
)
}
}

\keyword{internal}
