% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transcribeservice_operations.R
\name{transcribeservice_list_transcription_jobs}
\alias{transcribeservice_list_transcription_jobs}
\title{Lists transcription jobs with the specified status}
\usage{
transcribeservice_list_transcription_jobs(Status, JobNameContains,
  NextToken, MaxResults)
}
\arguments{
\item{Status}{When specified, returns only transcription jobs with the specified
status. Jobs are ordered by creation date, with the newest jobs returned
first. If you don’t specify a status, Amazon Transcribe returns all
transcription jobs ordered by creation date.}

\item{JobNameContains}{When specified, the jobs returned in the list are limited to jobs whose
name contains the specified string.}

\item{NextToken}{If the result of the previous request to
\code{\link[=transcribeservice_list_transcription_jobs]{list_transcription_jobs}}
was truncated, include the \code{NextToken} to fetch the next set of jobs.}

\item{MaxResults}{The maximum number of jobs to return in the response. If there are fewer
results in the list, this response contains only the actual results.}
}
\value{
A list with the following syntax:\preformatted{list(
  Status = "QUEUED"|"IN_PROGRESS"|"FAILED"|"COMPLETED",
  NextToken = "string",
  TranscriptionJobSummaries = list(
    list(
      TranscriptionJobName = "string",
      CreationTime = as.POSIXct(
        "2015-01-01"
      ),
      StartTime = as.POSIXct(
        "2015-01-01"
      ),
      CompletionTime = as.POSIXct(
        "2015-01-01"
      ),
      LanguageCode = "af-ZA"|"ar-AE"|"ar-SA"|"cy-GB"|"da-DK"|"de-CH"|"de-DE"|"en-AB"|"en-AU"|"en-GB"|"en-IE"|"en-IN"|"en-US"|"en-WL"|"es-ES"|"es-US"|"fa-IR"|"fr-CA"|"fr-FR"|"ga-IE"|"gd-GB"|"he-IL"|"hi-IN"|"id-ID"|"it-IT"|"ja-JP"|"ko-KR"|"ms-MY"|"nl-NL"|"pt-BR"|"pt-PT"|"ru-RU"|"ta-IN"|"te-IN"|"tr-TR"|"zh-CN",
      TranscriptionJobStatus = "QUEUED"|"IN_PROGRESS"|"FAILED"|"COMPLETED",
      FailureReason = "string",
      OutputLocationType = "CUSTOMER_BUCKET"|"SERVICE_BUCKET",
      ContentRedaction = list(
        RedactionType = "PII",
        RedactionOutput = "redacted"|"redacted_and_unredacted"
      ),
      ModelSettings = list(
        LanguageModelName = "string"
      ),
      IdentifyLanguage = TRUE|FALSE,
      IdentifiedLanguageScore = 123.0
    )
  )
)
}
}
\description{
Lists transcription jobs with the specified status.
}
\section{Request syntax}{
\preformatted{svc$list_transcription_jobs(
  Status = "QUEUED"|"IN_PROGRESS"|"FAILED"|"COMPLETED",
  JobNameContains = "string",
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
