% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/polly_operations.R
\name{polly_synthesize_speech}
\alias{polly_synthesize_speech}
\title{Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes}
\usage{
polly_synthesize_speech(Engine, LanguageCode, LexiconNames,
  OutputFormat, SampleRate, SpeechMarkTypes, Text, TextType, VoiceId)
}
\arguments{
\item{Engine}{Specifies the engine (\code{standard} or \code{neural}) for Amazon Polly to use
when processing input text for speech synthesis. For information on
Amazon Polly voices and which voices are available in standard-only,
NTTS-only, and both standard and NTTS formats, see \href{https://docs.aws.amazon.com/polly/latest/dg/voicelist.html}{Available Voices}.

\strong{NTTS-only voices}

When using NTTS-only voices such as Kevin (en-US), this parameter is
required and must be set to \code{neural}. If the engine is not specified, or
is set to \code{standard}, this will result in an error.

Type: String

Valid Values: \code{standard} | \code{neural}

Required: Yes

\strong{Standard voices}

For standard voices, this is not required; the engine parameter defaults
to \code{standard}. If the engine is not specified, or is set to \code{standard}
and an NTTS-only voice is selected, this will result in an error.}

\item{LanguageCode}{Optional language code for the Synthesize Speech request. This is only
necessary if using a bilingual voice, such as Aditi, which can be used
for either Indian English (en-IN) or Hindi (hi-IN).

If a bilingual voice is used and no language code is specified, Amazon
Polly will use the default language of the bilingual voice. The default
language for any voice is the one returned by the
\code{\link[=polly_describe_voices]{describe_voices}} operation for the
\code{LanguageCode} parameter. For example, if no language code is specified,
Aditi will use Indian English rather than Hindi.}

\item{LexiconNames}{List of one or more pronunciation lexicon names you want the service to
apply during synthesis. Lexicons are applied only if the language of the
lexicon is the same as the language of the voice. For information about
storing lexicons, see \code{\link[=polly_put_lexicon]{put_lexicon}}.}

\item{OutputFormat}{[required] The format in which the returned output will be encoded. For audio
stream, this will be mp3, ogg_vorbis, or pcm. For speech marks, this
will be json.

When pcm is used, the content returned is audio/pcm in a signed 16-bit,
1 channel (mono), little-endian format.}

\item{SampleRate}{The audio frequency specified in Hz.

The valid values for mp3 and ogg_vorbis are "8000", "16000", "22050",
and "24000". The default value for standard voices is "22050". The
default value for neural voices is "24000".

Valid values for pcm are "8000" and "16000" The default value is
"16000".}

\item{SpeechMarkTypes}{The type of speech marks returned for the input text.}

\item{Text}{[required] Input text to synthesize. If you specify \code{ssml} as the \code{TextType},
follow the SSML format for the input text.}

\item{TextType}{Specifies whether the input text is plain text or SSML. The default
value is plain text. For more information, see \href{https://docs.aws.amazon.com/polly/latest/dg/ssml.html}{Using SSML}.}

\item{VoiceId}{[required] Voice ID to use for the synthesis. You can get a list of available voice
IDs by calling the \code{\link[=polly_describe_voices]{describe_voices}} operation.}
}
\value{
A list with the following syntax:\preformatted{list(
  AudioStream = raw,
  ContentType = "string",
  RequestCharacters = 123
)
}
}
\description{
Synthesizes UTF-8 input, plain text or SSML, to a stream of bytes. SSML
input must be valid, well-formed SSML. Some alphabets might not be
available with all the voices (for example, Cyrillic might not be read
at all by English voices) unless phoneme mapping is used. For more
information, see \href{https://docs.aws.amazon.com/polly/latest/dg/how-text-to-speech-works.html}{How it Works}.
}
\section{Request syntax}{
\preformatted{svc$synthesize_speech(
  Engine = "standard"|"neural",
  LanguageCode = "arb"|"cmn-CN"|"cy-GB"|"da-DK"|"de-DE"|"en-AU"|"en-GB"|"en-GB-WLS"|"en-IN"|"en-US"|"es-ES"|"es-MX"|"es-US"|"fr-CA"|"fr-FR"|"is-IS"|"it-IT"|"ja-JP"|"hi-IN"|"ko-KR"|"nb-NO"|"nl-NL"|"pl-PL"|"pt-BR"|"pt-PT"|"ro-RO"|"ru-RU"|"sv-SE"|"tr-TR",
  LexiconNames = list(
    "string"
  ),
  OutputFormat = "json"|"mp3"|"ogg_vorbis"|"pcm",
  SampleRate = "string",
  SpeechMarkTypes = list(
    "sentence"|"ssml"|"viseme"|"word"
  ),
  Text = "string",
  TextType = "ssml"|"text",
  VoiceId = "Aditi"|"Amy"|"Astrid"|"Bianca"|"Brian"|"Camila"|"Carla"|"Carmen"|"Celine"|"Chantal"|"Conchita"|"Cristiano"|"Dora"|"Emma"|"Enrique"|"Ewa"|"Filiz"|"Geraint"|"Giorgio"|"Gwyneth"|"Hans"|"Ines"|"Ivy"|"Jacek"|"Jan"|"Joanna"|"Joey"|"Justin"|"Karl"|"Kendra"|"Kevin"|"Kimberly"|"Lea"|"Liv"|"Lotte"|"Lucia"|"Lupe"|"Mads"|"Maja"|"Marlene"|"Mathieu"|"Matthew"|"Maxim"|"Mia"|"Miguel"|"Mizuki"|"Naja"|"Nicole"|"Olivia"|"Penelope"|"Raveena"|"Ricardo"|"Ruben"|"Russell"|"Salli"|"Seoyeon"|"Takumi"|"Tatyana"|"Vicki"|"Vitoria"|"Zeina"|"Zhiyu"
)
}
}

\examples{
\dontrun{
# Synthesizes plain text or SSML into a file of human-like speech.
svc$synthesize_speech(
  LexiconNames = list(
    "example"
  ),
  OutputFormat = "mp3",
  SampleRate = "8000",
  Text = "All Gaul is divided into three parts",
  TextType = "text",
  VoiceId = "Joanna"
)
}

}
\keyword{internal}
