% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/textract_operations.R
\name{textract_detect_document_text}
\alias{textract_detect_document_text}
\title{Detects text in the input document}
\usage{
textract_detect_document_text(Document)
}
\arguments{
\item{Document}{[required] The input document as base64-encoded bytes or an Amazon S3 object. If
you use the AWS CLI to call Amazon Textract operations, you can't pass
image bytes. The document must be an image in JPG or PNG format.}
}
\description{
Detects text in the input document. Amazon Textract can detect lines of
text and the words that make up a line of text. The input document must
be an image in JPG or PNG format. \code{DetectDocumentText} returns the
detected text in an array of Block objects. For more information, see
how-it-works-detecting.
}
\details{
\code{DetectDocumentText} is a synchronous operation. To analyze documents
asynchronously, use StartDocumentTextDetection.
}
\section{Request syntax}{
\preformatted{svc$detect_document_text(
  Document = list(
    Bytes = raw,
    S3Object = list(
      Bucket = "string",
      Name = "string",
      Version = "string"
    )
  )
)
}
}

\keyword{internal}
