% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_create_model}
\alias{sagemaker_create_model}
\title{Creates a model in Amazon SageMaker}
\usage{
sagemaker_create_model(ModelName, PrimaryContainer, Containers,
  ExecutionRoleArn, Tags, VpcConfig, EnableNetworkIsolation)
}
\arguments{
\item{ModelName}{[required] The name of the new model.}

\item{PrimaryContainer}{The location of the primary docker image containing inference code,
associated artifacts, and custom environment map that the inference code
uses when the model is deployed for predictions.}

\item{Containers}{Specifies the containers in the inference pipeline.}

\item{ExecutionRoleArn}{[required] The Amazon Resource Name (ARN) of the IAM role that Amazon SageMaker can
assume to access model artifacts and docker image for deployment on ML
compute instances or for batch transform jobs. Deploying on ML compute
instances is part of model hosting. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/sagemaker-roles.html}{Amazon SageMaker Roles}.

To be able to pass this role to Amazon SageMaker, the caller of this API
must have the \code{iam:PassRole} permission.}

\item{Tags}{An array of key-value pairs. For more information, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html#allocation-what}{Using Cost Allocation Tags}
in the \emph{AWS Billing and Cost Management User Guide}.}

\item{VpcConfig}{A VpcConfig object that specifies the VPC that you want your model to
connect to. Control access to and from your model container by
configuring the VPC. \code{VpcConfig} is used in hosting services and in
batch transform. For more information, see \href{https://docs.aws.amazon.com/sagemaker/latest/dg/host-vpc.html}{Protect Endpoints by Using an Amazon Virtual Private Cloud}
and \href{https://docs.aws.amazon.com/sagemaker/latest/dg/batch-vpc.html}{Protect Data in Batch Transform Jobs by Using an Amazon Virtual Private Cloud}.}

\item{EnableNetworkIsolation}{Isolates the model container. No inbound or outbound network calls can
be made to or from the model container.

The Semantic Segmentation built-in algorithm does not support network
isolation.}
}
\description{
Creates a model in Amazon SageMaker. In the request, you name the model
and describe a primary container. For the primary container, you specify
the docker image containing inference code, artifacts (from prior
training), and custom environment map that the inference code uses when
you deploy the model for predictions.
}
\details{
Use this API to create a model if you want to use Amazon SageMaker
hosting services or run a batch transform job.

To host your model, you create an endpoint configuration with the
\code{CreateEndpointConfig} API, and then create an endpoint with the
\code{CreateEndpoint} API. Amazon SageMaker then deploys all of the
containers that you defined for the model in the hosting environment.

To run a batch transform using your model, you start a job with the
\code{CreateTransformJob} API. Amazon SageMaker uses your model and your
dataset to get inferences which are then saved to a specified S3
location.

In the \code{CreateModel} request, you must define a container with the
\code{PrimaryContainer} parameter.

In the request, you also provide an IAM role that Amazon SageMaker can
assume to access model artifacts and docker image for deployment on ML
compute hosting instances or for batch transform jobs. In addition, you
also use the IAM role to manage permissions the inference code needs.
For example, if the inference code access any other AWS resources, you
grant necessary permissions via this role.
}
\section{Request syntax}{
\preformatted{svc$create_model(
  ModelName = "string",
  PrimaryContainer = list(
    ContainerHostname = "string",
    Image = "string",
    ModelDataUrl = "string",
    Environment = list(
      "string"
    ),
    ModelPackageName = "string"
  ),
  Containers = list(
    list(
      ContainerHostname = "string",
      Image = "string",
      ModelDataUrl = "string",
      Environment = list(
        "string"
      ),
      ModelPackageName = "string"
    )
  ),
  ExecutionRoleArn = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  ),
  VpcConfig = list(
    SecurityGroupIds = list(
      "string"
    ),
    Subnets = list(
      "string"
    )
  ),
  EnableNetworkIsolation = TRUE|FALSE
)
}
}

\keyword{internal}
