% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sagemaker_operations.R
\name{sagemaker_delete_model}
\alias{sagemaker_delete_model}
\title{Deletes a model}
\usage{
sagemaker_delete_model(ModelName)
}
\arguments{
\item{ModelName}{[required] The name of the model to delete.}
}
\description{
Deletes a model. The \code{DeleteModel} API deletes only the model entry that
was created in Amazon SageMaker when you called the
\href{https://docs.aws.amazon.com/sagemaker/latest/dg/API_CreateModel.html}{CreateModel}
API. It does not delete model artifacts, inference code, or the IAM role
that you specified when creating the model.
}
\section{Request syntax}{
\preformatted{svc$delete_model(
  ModelName = "string"
)
}
}

\keyword{internal}
