% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workmail_operations.R
\name{workmail_update_availability_configuration}
\alias{workmail_update_availability_configuration}
\title{Updates an existing AvailabilityConfiguration for the given WorkMail
organization and domain}
\usage{
workmail_update_availability_configuration(
  OrganizationId,
  DomainName,
  EwsProvider = NULL,
  LambdaProvider = NULL
)
}
\arguments{
\item{OrganizationId}{[required] The WorkMail organization for which the \code{AvailabilityConfiguration} will
be updated.}

\item{DomainName}{[required] The domain to which the provider applies the availability configuration.}

\item{EwsProvider}{The EWS availability provider definition. The request must contain
exactly one provider definition, either \code{EwsProvider} or
\code{LambdaProvider}. The previously stored provider will be overridden by
the one provided.}

\item{LambdaProvider}{The Lambda availability provider definition. The request must contain
exactly one provider definition, either \code{EwsProvider} or
\code{LambdaProvider}. The previously stored provider will be overridden by
the one provided.}
}
\description{
Updates an existing \code{AvailabilityConfiguration} for the given WorkMail organization and domain.

See \url{https://www.paws-r-sdk.com/docs/workmail_update_availability_configuration/} for full documentation.
}
\keyword{internal}
