# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include workspaces_service.R
NULL

#' Associates the specified connection alias with the specified directory
#' to enable cross-Region redirection
#'
#' @description
#' Associates the specified connection alias with the specified directory to enable cross-Region redirection. For more information, see [Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_associate_connection_alias/](https://www.paws-r-sdk.com/docs/workspaces_associate_connection_alias/) for full documentation.
#'
#' @param AliasId &#91;required&#93; The identifier of the connection alias.
#' @param ResourceId &#91;required&#93; The identifier of the directory to associate the connection alias with.
#'
#' @keywords internal
#'
#' @rdname workspaces_associate_connection_alias
workspaces_associate_connection_alias <- function(AliasId, ResourceId) {
  op <- new_operation(
    name = "AssociateConnectionAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$associate_connection_alias_input(AliasId = AliasId, ResourceId = ResourceId)
  output <- .workspaces$associate_connection_alias_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$associate_connection_alias <- workspaces_associate_connection_alias

#' Associates the specified IP access control group with the specified
#' directory
#'
#' @description
#' Associates the specified IP access control group with the specified directory.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_associate_ip_groups/](https://www.paws-r-sdk.com/docs/workspaces_associate_ip_groups/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param GroupIds &#91;required&#93; The identifiers of one or more IP access control groups.
#'
#' @keywords internal
#'
#' @rdname workspaces_associate_ip_groups
workspaces_associate_ip_groups <- function(DirectoryId, GroupIds) {
  op <- new_operation(
    name = "AssociateIpGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$associate_ip_groups_input(DirectoryId = DirectoryId, GroupIds = GroupIds)
  output <- .workspaces$associate_ip_groups_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$associate_ip_groups <- workspaces_associate_ip_groups

#' Associates the specified application to the specified WorkSpace
#'
#' @description
#' Associates the specified application to the specified WorkSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_associate_workspace_application/](https://www.paws-r-sdk.com/docs/workspaces_associate_workspace_application/) for full documentation.
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#' @param ApplicationId &#91;required&#93; The identifier of the application.
#'
#' @keywords internal
#'
#' @rdname workspaces_associate_workspace_application
workspaces_associate_workspace_application <- function(WorkspaceId, ApplicationId) {
  op <- new_operation(
    name = "AssociateWorkspaceApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$associate_workspace_application_input(WorkspaceId = WorkspaceId, ApplicationId = ApplicationId)
  output <- .workspaces$associate_workspace_application_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$associate_workspace_application <- workspaces_associate_workspace_application

#' Adds one or more rules to the specified IP access control group
#'
#' @description
#' Adds one or more rules to the specified IP access control group.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_authorize_ip_rules/](https://www.paws-r-sdk.com/docs/workspaces_authorize_ip_rules/) for full documentation.
#'
#' @param GroupId &#91;required&#93; The identifier of the group.
#' @param UserRules &#91;required&#93; The rules to add to the group.
#'
#' @keywords internal
#'
#' @rdname workspaces_authorize_ip_rules
workspaces_authorize_ip_rules <- function(GroupId, UserRules) {
  op <- new_operation(
    name = "AuthorizeIpRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$authorize_ip_rules_input(GroupId = GroupId, UserRules = UserRules)
  output <- .workspaces$authorize_ip_rules_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$authorize_ip_rules <- workspaces_authorize_ip_rules

#' Copies the specified image from the specified Region to the current
#' Region
#'
#' @description
#' Copies the specified image from the specified Region to the current Region. For more information about copying images, see [Copy a Custom WorkSpaces Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/copy-custom-image.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_copy_workspace_image/](https://www.paws-r-sdk.com/docs/workspaces_copy_workspace_image/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the image.
#' @param Description A description of the image.
#' @param SourceImageId &#91;required&#93; The identifier of the source image.
#' @param SourceRegion &#91;required&#93; The identifier of the source Region.
#' @param Tags The tags for the image.
#'
#' @keywords internal
#'
#' @rdname workspaces_copy_workspace_image
workspaces_copy_workspace_image <- function(Name, Description = NULL, SourceImageId, SourceRegion, Tags = NULL) {
  op <- new_operation(
    name = "CopyWorkspaceImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$copy_workspace_image_input(Name = Name, Description = Description, SourceImageId = SourceImageId, SourceRegion = SourceRegion, Tags = Tags)
  output <- .workspaces$copy_workspace_image_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$copy_workspace_image <- workspaces_copy_workspace_image

#' Creates a client-add-in for Amazon Connect within a directory
#'
#' @description
#' Creates a client-add-in for Amazon Connect within a directory. You can create only one Amazon Connect client add-in within a directory.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_create_connect_client_add_in/](https://www.paws-r-sdk.com/docs/workspaces_create_connect_client_add_in/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The directory identifier for which to configure the client add-in.
#' @param Name &#91;required&#93; The name of the client add-in.
#' @param URL &#91;required&#93; The endpoint URL of the Amazon Connect client add-in.
#'
#' @keywords internal
#'
#' @rdname workspaces_create_connect_client_add_in
workspaces_create_connect_client_add_in <- function(ResourceId, Name, URL) {
  op <- new_operation(
    name = "CreateConnectClientAddIn",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_connect_client_add_in_input(ResourceId = ResourceId, Name = Name, URL = URL)
  output <- .workspaces$create_connect_client_add_in_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_connect_client_add_in <- workspaces_create_connect_client_add_in

#' Creates the specified connection alias for use with cross-Region
#' redirection
#'
#' @description
#' Creates the specified connection alias for use with cross-Region redirection. For more information, see [Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_create_connection_alias/](https://www.paws-r-sdk.com/docs/workspaces_create_connection_alias/) for full documentation.
#'
#' @param ConnectionString &#91;required&#93; A connection string in the form of a fully qualified domain name (FQDN),
#' such as `www.example.com`.
#' 
#' After you create a connection string, it is always associated to your
#' Amazon Web Services account. You cannot recreate the same connection
#' string with a different account, even if you delete all instances of it
#' from the original account. The connection string is globally reserved
#' for your account.
#' @param Tags The tags to associate with the connection alias.
#'
#' @keywords internal
#'
#' @rdname workspaces_create_connection_alias
workspaces_create_connection_alias <- function(ConnectionString, Tags = NULL) {
  op <- new_operation(
    name = "CreateConnectionAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_connection_alias_input(ConnectionString = ConnectionString, Tags = Tags)
  output <- .workspaces$create_connection_alias_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_connection_alias <- workspaces_create_connection_alias

#' Creates an IP access control group
#'
#' @description
#' Creates an IP access control group.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_create_ip_group/](https://www.paws-r-sdk.com/docs/workspaces_create_ip_group/) for full documentation.
#'
#' @param GroupName &#91;required&#93; The name of the group.
#' @param GroupDesc The description of the group.
#' @param UserRules The rules to add to the group.
#' @param Tags The tags. Each WorkSpaces resource can have a maximum of 50 tags.
#'
#' @keywords internal
#'
#' @rdname workspaces_create_ip_group
workspaces_create_ip_group <- function(GroupName, GroupDesc = NULL, UserRules = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateIpGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_ip_group_input(GroupName = GroupName, GroupDesc = GroupDesc, UserRules = UserRules, Tags = Tags)
  output <- .workspaces$create_ip_group_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_ip_group <- workspaces_create_ip_group

#' Creates a standby WorkSpace in a secondary Region
#'
#' @description
#' Creates a standby WorkSpace in a secondary Region.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_create_standby_workspaces/](https://www.paws-r-sdk.com/docs/workspaces_create_standby_workspaces/) for full documentation.
#'
#' @param PrimaryRegion &#91;required&#93; The Region of the primary WorkSpace.
#' @param StandbyWorkspaces &#91;required&#93; Information about the standby WorkSpace to be created.
#'
#' @keywords internal
#'
#' @rdname workspaces_create_standby_workspaces
workspaces_create_standby_workspaces <- function(PrimaryRegion, StandbyWorkspaces) {
  op <- new_operation(
    name = "CreateStandbyWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_standby_workspaces_input(PrimaryRegion = PrimaryRegion, StandbyWorkspaces = StandbyWorkspaces)
  output <- .workspaces$create_standby_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_standby_workspaces <- workspaces_create_standby_workspaces

#' Creates the specified tags for the specified WorkSpaces resource
#'
#' @description
#' Creates the specified tags for the specified WorkSpaces resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_create_tags/](https://www.paws-r-sdk.com/docs/workspaces_create_tags/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The identifier of the WorkSpaces resource. The supported resource types
#' are WorkSpaces, registered directories, images, custom bundles, IP
#' access control groups, and connection aliases.
#' @param Tags &#91;required&#93; The tags. Each WorkSpaces resource can have a maximum of 50 tags.
#'
#' @keywords internal
#'
#' @rdname workspaces_create_tags
workspaces_create_tags <- function(ResourceId, Tags) {
  op <- new_operation(
    name = "CreateTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_tags_input(ResourceId = ResourceId, Tags = Tags)
  output <- .workspaces$create_tags_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_tags <- workspaces_create_tags

#' Creates a new updated WorkSpace image based on the specified source
#' image
#'
#' @description
#' Creates a new updated WorkSpace image based on the specified source image. The new updated WorkSpace image has the latest drivers and other updates required by the Amazon WorkSpaces components.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_create_updated_workspace_image/](https://www.paws-r-sdk.com/docs/workspaces_create_updated_workspace_image/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the new updated WorkSpace image.
#' @param Description &#91;required&#93; A description of whether updates for the WorkSpace image are available.
#' @param SourceImageId &#91;required&#93; The identifier of the source WorkSpace image.
#' @param Tags The tags that you want to add to the new updated WorkSpace image.
#' 
#' To add tags at the same time when you're creating the updated image, you
#' must create an IAM policy that grants your IAM user permissions to use
#' `workspaces:CreateTags`.
#'
#' @keywords internal
#'
#' @rdname workspaces_create_updated_workspace_image
workspaces_create_updated_workspace_image <- function(Name, Description, SourceImageId, Tags = NULL) {
  op <- new_operation(
    name = "CreateUpdatedWorkspaceImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_updated_workspace_image_input(Name = Name, Description = Description, SourceImageId = SourceImageId, Tags = Tags)
  output <- .workspaces$create_updated_workspace_image_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_updated_workspace_image <- workspaces_create_updated_workspace_image

#' Creates the specified WorkSpace bundle
#'
#' @description
#' Creates the specified WorkSpace bundle. For more information about creating WorkSpace bundles, see [Create a Custom WorkSpaces Image and Bundle](https://docs.aws.amazon.com/workspaces/latest/adminguide/create-custom-bundle.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_create_workspace_bundle/](https://www.paws-r-sdk.com/docs/workspaces_create_workspace_bundle/) for full documentation.
#'
#' @param BundleName &#91;required&#93; The name of the bundle.
#' @param BundleDescription &#91;required&#93; The description of the bundle.
#' @param ImageId &#91;required&#93; The identifier of the image that is used to create the bundle.
#' @param ComputeType &#91;required&#93; 
#' @param UserStorage &#91;required&#93; 
#' @param RootStorage 
#' @param Tags The tags associated with the bundle.
#' 
#' To add tags at the same time when you're creating the bundle, you must
#' create an IAM policy that grants your IAM user permissions to use
#' `workspaces:CreateTags`.
#'
#' @keywords internal
#'
#' @rdname workspaces_create_workspace_bundle
workspaces_create_workspace_bundle <- function(BundleName, BundleDescription, ImageId, ComputeType, UserStorage, RootStorage = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateWorkspaceBundle",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_workspace_bundle_input(BundleName = BundleName, BundleDescription = BundleDescription, ImageId = ImageId, ComputeType = ComputeType, UserStorage = UserStorage, RootStorage = RootStorage, Tags = Tags)
  output <- .workspaces$create_workspace_bundle_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_workspace_bundle <- workspaces_create_workspace_bundle

#' Creates a new WorkSpace image from an existing WorkSpace
#'
#' @description
#' Creates a new WorkSpace image from an existing WorkSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_create_workspace_image/](https://www.paws-r-sdk.com/docs/workspaces_create_workspace_image/) for full documentation.
#'
#' @param Name &#91;required&#93; The name of the new WorkSpace image.
#' @param Description &#91;required&#93; The description of the new WorkSpace image.
#' @param WorkspaceId &#91;required&#93; The identifier of the source WorkSpace
#' @param Tags The tags that you want to add to the new WorkSpace image. To add tags
#' when you're creating the image, you must create an IAM policy that
#' grants your IAM user permission to use `workspaces:CreateTags`.
#'
#' @keywords internal
#'
#' @rdname workspaces_create_workspace_image
workspaces_create_workspace_image <- function(Name, Description, WorkspaceId, Tags = NULL) {
  op <- new_operation(
    name = "CreateWorkspaceImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_workspace_image_input(Name = Name, Description = Description, WorkspaceId = WorkspaceId, Tags = Tags)
  output <- .workspaces$create_workspace_image_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_workspace_image <- workspaces_create_workspace_image

#' Creates one or more WorkSpaces
#'
#' @description
#' Creates one or more WorkSpaces.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_create_workspaces/](https://www.paws-r-sdk.com/docs/workspaces_create_workspaces/) for full documentation.
#'
#' @param Workspaces &#91;required&#93; The WorkSpaces to create. You can specify up to 25 WorkSpaces.
#'
#' @keywords internal
#'
#' @rdname workspaces_create_workspaces
workspaces_create_workspaces <- function(Workspaces) {
  op <- new_operation(
    name = "CreateWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$create_workspaces_input(Workspaces = Workspaces)
  output <- .workspaces$create_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$create_workspaces <- workspaces_create_workspaces

#' Deletes customized client branding
#'
#' @description
#' Deletes customized client branding. Client branding allows you to customize your WorkSpace's client login portal. You can tailor your login portal company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_delete_client_branding/](https://www.paws-r-sdk.com/docs/workspaces_delete_client_branding/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The directory identifier of the WorkSpace for which you want to delete
#' client branding.
#' @param Platforms &#91;required&#93; The device type for which you want to delete client branding.
#'
#' @keywords internal
#'
#' @rdname workspaces_delete_client_branding
workspaces_delete_client_branding <- function(ResourceId, Platforms) {
  op <- new_operation(
    name = "DeleteClientBranding",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$delete_client_branding_input(ResourceId = ResourceId, Platforms = Platforms)
  output <- .workspaces$delete_client_branding_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$delete_client_branding <- workspaces_delete_client_branding

#' Deletes a client-add-in for Amazon Connect that is configured within a
#' directory
#'
#' @description
#' Deletes a client-add-in for Amazon Connect that is configured within a directory.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_delete_connect_client_add_in/](https://www.paws-r-sdk.com/docs/workspaces_delete_connect_client_add_in/) for full documentation.
#'
#' @param AddInId &#91;required&#93; The identifier of the client add-in to delete.
#' @param ResourceId &#91;required&#93; The directory identifier for which the client add-in is configured.
#'
#' @keywords internal
#'
#' @rdname workspaces_delete_connect_client_add_in
workspaces_delete_connect_client_add_in <- function(AddInId, ResourceId) {
  op <- new_operation(
    name = "DeleteConnectClientAddIn",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$delete_connect_client_add_in_input(AddInId = AddInId, ResourceId = ResourceId)
  output <- .workspaces$delete_connect_client_add_in_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$delete_connect_client_add_in <- workspaces_delete_connect_client_add_in

#' Deletes the specified connection alias
#'
#' @description
#' Deletes the specified connection alias. For more information, see [Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_delete_connection_alias/](https://www.paws-r-sdk.com/docs/workspaces_delete_connection_alias/) for full documentation.
#'
#' @param AliasId &#91;required&#93; The identifier of the connection alias to delete.
#'
#' @keywords internal
#'
#' @rdname workspaces_delete_connection_alias
workspaces_delete_connection_alias <- function(AliasId) {
  op <- new_operation(
    name = "DeleteConnectionAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$delete_connection_alias_input(AliasId = AliasId)
  output <- .workspaces$delete_connection_alias_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$delete_connection_alias <- workspaces_delete_connection_alias

#' Deletes the specified IP access control group
#'
#' @description
#' Deletes the specified IP access control group.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_delete_ip_group/](https://www.paws-r-sdk.com/docs/workspaces_delete_ip_group/) for full documentation.
#'
#' @param GroupId &#91;required&#93; The identifier of the IP access control group.
#'
#' @keywords internal
#'
#' @rdname workspaces_delete_ip_group
workspaces_delete_ip_group <- function(GroupId) {
  op <- new_operation(
    name = "DeleteIpGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$delete_ip_group_input(GroupId = GroupId)
  output <- .workspaces$delete_ip_group_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$delete_ip_group <- workspaces_delete_ip_group

#' Deletes the specified tags from the specified WorkSpaces resource
#'
#' @description
#' Deletes the specified tags from the specified WorkSpaces resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_delete_tags/](https://www.paws-r-sdk.com/docs/workspaces_delete_tags/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The identifier of the WorkSpaces resource. The supported resource types
#' are WorkSpaces, registered directories, images, custom bundles, IP
#' access control groups, and connection aliases.
#' @param TagKeys &#91;required&#93; The tag keys.
#'
#' @keywords internal
#'
#' @rdname workspaces_delete_tags
workspaces_delete_tags <- function(ResourceId, TagKeys) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$delete_tags_input(ResourceId = ResourceId, TagKeys = TagKeys)
  output <- .workspaces$delete_tags_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$delete_tags <- workspaces_delete_tags

#' Deletes the specified WorkSpace bundle
#'
#' @description
#' Deletes the specified WorkSpace bundle. For more information about deleting WorkSpace bundles, see [Delete a Custom WorkSpaces Bundle or Image](https://docs.aws.amazon.com/workspaces/latest/adminguide/delete_bundle.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_delete_workspace_bundle/](https://www.paws-r-sdk.com/docs/workspaces_delete_workspace_bundle/) for full documentation.
#'
#' @param BundleId The identifier of the bundle.
#'
#' @keywords internal
#'
#' @rdname workspaces_delete_workspace_bundle
workspaces_delete_workspace_bundle <- function(BundleId = NULL) {
  op <- new_operation(
    name = "DeleteWorkspaceBundle",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$delete_workspace_bundle_input(BundleId = BundleId)
  output <- .workspaces$delete_workspace_bundle_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$delete_workspace_bundle <- workspaces_delete_workspace_bundle

#' Deletes the specified image from your account
#'
#' @description
#' Deletes the specified image from your account. To delete an image, you must first delete any bundles that are associated with the image and unshare the image if it is shared with other accounts.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_delete_workspace_image/](https://www.paws-r-sdk.com/docs/workspaces_delete_workspace_image/) for full documentation.
#'
#' @param ImageId &#91;required&#93; The identifier of the image.
#'
#' @keywords internal
#'
#' @rdname workspaces_delete_workspace_image
workspaces_delete_workspace_image <- function(ImageId) {
  op <- new_operation(
    name = "DeleteWorkspaceImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$delete_workspace_image_input(ImageId = ImageId)
  output <- .workspaces$delete_workspace_image_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$delete_workspace_image <- workspaces_delete_workspace_image

#' Deploys associated applications to the specified WorkSpace
#'
#' @description
#' Deploys associated applications to the specified WorkSpace
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_deploy_workspace_applications/](https://www.paws-r-sdk.com/docs/workspaces_deploy_workspace_applications/) for full documentation.
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#' @param Force Indicates whether the force flag is applied for the specified WorkSpace.
#' When the force flag is enabled, it allows previously failed deployments
#' to be retried.
#'
#' @keywords internal
#'
#' @rdname workspaces_deploy_workspace_applications
workspaces_deploy_workspace_applications <- function(WorkspaceId, Force = NULL) {
  op <- new_operation(
    name = "DeployWorkspaceApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$deploy_workspace_applications_input(WorkspaceId = WorkspaceId, Force = Force)
  output <- .workspaces$deploy_workspace_applications_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$deploy_workspace_applications <- workspaces_deploy_workspace_applications

#' Deregisters the specified directory
#'
#' @description
#' Deregisters the specified directory. This operation is asynchronous and returns before the WorkSpace directory is deregistered. If any WorkSpaces are registered to this directory, you must remove them before you can deregister the directory.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_deregister_workspace_directory/](https://www.paws-r-sdk.com/docs/workspaces_deregister_workspace_directory/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory. If any WorkSpaces are registered to
#' this directory, you must remove them before you deregister the
#' directory, or you will receive an OperationNotSupportedException error.
#'
#' @keywords internal
#'
#' @rdname workspaces_deregister_workspace_directory
workspaces_deregister_workspace_directory <- function(DirectoryId) {
  op <- new_operation(
    name = "DeregisterWorkspaceDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$deregister_workspace_directory_input(DirectoryId = DirectoryId)
  output <- .workspaces$deregister_workspace_directory_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$deregister_workspace_directory <- workspaces_deregister_workspace_directory

#' Retrieves a list that describes the configuration of Bring Your Own
#' License (BYOL) for the specified account
#'
#' @description
#' Retrieves a list that describes the configuration of Bring Your Own License (BYOL) for the specified account.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_account/](https://www.paws-r-sdk.com/docs/workspaces_describe_account/) for full documentation.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_account
workspaces_describe_account <- function() {
  op <- new_operation(
    name = "DescribeAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_account_input()
  output <- .workspaces$describe_account_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_account <- workspaces_describe_account

#' Retrieves a list that describes modifications to the configuration of
#' Bring Your Own License (BYOL) for the specified account
#'
#' @description
#' Retrieves a list that describes modifications to the configuration of Bring Your Own License (BYOL) for the specified account.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_account_modifications/](https://www.paws-r-sdk.com/docs/workspaces_describe_account_modifications/) for full documentation.
#'
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_account_modifications
workspaces_describe_account_modifications <- function(NextToken = NULL) {
  op <- new_operation(
    name = "DescribeAccountModifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_account_modifications_input(NextToken = NextToken)
  output <- .workspaces$describe_account_modifications_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_account_modifications <- workspaces_describe_account_modifications

#' Describes the associations between the application and the specified
#' associated resources
#'
#' @description
#' Describes the associations between the application and the specified associated resources.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_application_associations/](https://www.paws-r-sdk.com/docs/workspaces_describe_application_associations/) for full documentation.
#'
#' @param MaxResults The maximum number of associations to return.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#' @param ApplicationId &#91;required&#93; The identifier of the specified application.
#' @param AssociatedResourceTypes &#91;required&#93; The resource type of the associated resources.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_application_associations
workspaces_describe_application_associations <- function(MaxResults = NULL, NextToken = NULL, ApplicationId, AssociatedResourceTypes) {
  op <- new_operation(
    name = "DescribeApplicationAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .workspaces$describe_application_associations_input(MaxResults = MaxResults, NextToken = NextToken, ApplicationId = ApplicationId, AssociatedResourceTypes = AssociatedResourceTypes)
  output <- .workspaces$describe_application_associations_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_application_associations <- workspaces_describe_application_associations

#' Describes the specified applications by filtering based on their compute
#' types, license availability, operating systems, and owners
#'
#' @description
#' Describes the specified applications by filtering based on their compute types, license availability, operating systems, and owners.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_applications/](https://www.paws-r-sdk.com/docs/workspaces_describe_applications/) for full documentation.
#'
#' @param ApplicationIds The identifiers of one or more applications.
#' @param ComputeTypeNames The compute types supported by the applications.
#' @param LicenseType The license availability for the applications.
#' @param OperatingSystemNames The operating systems supported by the applications.
#' @param Owner The owner of the applications.
#' @param MaxResults The maximum number of applications to return.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_applications
workspaces_describe_applications <- function(ApplicationIds = NULL, ComputeTypeNames = NULL, LicenseType = NULL, OperatingSystemNames = NULL, Owner = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "MaxResults", output_token = "NextToken")
  )
  input <- .workspaces$describe_applications_input(ApplicationIds = ApplicationIds, ComputeTypeNames = ComputeTypeNames, LicenseType = LicenseType, OperatingSystemNames = OperatingSystemNames, Owner = Owner, MaxResults = MaxResults, NextToken = NextToken)
  output <- .workspaces$describe_applications_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_applications <- workspaces_describe_applications

#' Describes the associations between the applications and the specified
#' bundle
#'
#' @description
#' Describes the associations between the applications and the specified bundle.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_bundle_associations/](https://www.paws-r-sdk.com/docs/workspaces_describe_bundle_associations/) for full documentation.
#'
#' @param BundleId &#91;required&#93; The identifier of the bundle.
#' @param AssociatedResourceTypes &#91;required&#93; The resource types of the associated resource.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_bundle_associations
workspaces_describe_bundle_associations <- function(BundleId, AssociatedResourceTypes) {
  op <- new_operation(
    name = "DescribeBundleAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_bundle_associations_input(BundleId = BundleId, AssociatedResourceTypes = AssociatedResourceTypes)
  output <- .workspaces$describe_bundle_associations_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_bundle_associations <- workspaces_describe_bundle_associations

#' Describes the specified client branding
#'
#' @description
#' Describes the specified client branding. Client branding allows you to customize the log in page of various device types for your users. You can add your company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_client_branding/](https://www.paws-r-sdk.com/docs/workspaces_describe_client_branding/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The directory identifier of the WorkSpace for which you want to view
#' client branding information.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_client_branding
workspaces_describe_client_branding <- function(ResourceId) {
  op <- new_operation(
    name = "DescribeClientBranding",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_client_branding_input(ResourceId = ResourceId)
  output <- .workspaces$describe_client_branding_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_client_branding <- workspaces_describe_client_branding

#' Retrieves a list that describes one or more specified Amazon WorkSpaces
#' clients
#'
#' @description
#' Retrieves a list that describes one or more specified Amazon WorkSpaces clients.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_client_properties/](https://www.paws-r-sdk.com/docs/workspaces_describe_client_properties/) for full documentation.
#'
#' @param ResourceIds &#91;required&#93; The resource identifier, in the form of directory IDs.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_client_properties
workspaces_describe_client_properties <- function(ResourceIds) {
  op <- new_operation(
    name = "DescribeClientProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_client_properties_input(ResourceIds = ResourceIds)
  output <- .workspaces$describe_client_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_client_properties <- workspaces_describe_client_properties

#' Retrieves a list of Amazon Connect client add-ins that have been created
#'
#' @description
#' Retrieves a list of Amazon Connect client add-ins that have been created.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_connect_client_add_ins/](https://www.paws-r-sdk.com/docs/workspaces_describe_connect_client_add_ins/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The directory identifier for which the client add-in is configured.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#' @param MaxResults The maximum number of items to return.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_connect_client_add_ins
workspaces_describe_connect_client_add_ins <- function(ResourceId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeConnectClientAddIns",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_connect_client_add_ins_input(ResourceId = ResourceId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workspaces$describe_connect_client_add_ins_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_connect_client_add_ins <- workspaces_describe_connect_client_add_ins

#' Describes the permissions that the owner of a connection alias has
#' granted to another Amazon Web Services account for the specified
#' connection alias
#'
#' @description
#' Describes the permissions that the owner of a connection alias has granted to another Amazon Web Services account for the specified connection alias. For more information, see [Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_connection_alias_permissions/](https://www.paws-r-sdk.com/docs/workspaces_describe_connection_alias_permissions/) for full documentation.
#'
#' @param AliasId &#91;required&#93; The identifier of the connection alias.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#' @param MaxResults The maximum number of results to return.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_connection_alias_permissions
workspaces_describe_connection_alias_permissions <- function(AliasId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeConnectionAliasPermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_connection_alias_permissions_input(AliasId = AliasId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workspaces$describe_connection_alias_permissions_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_connection_alias_permissions <- workspaces_describe_connection_alias_permissions

#' Retrieves a list that describes the connection aliases used for
#' cross-Region redirection
#'
#' @description
#' Retrieves a list that describes the connection aliases used for cross-Region redirection. For more information, see [Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_connection_aliases/](https://www.paws-r-sdk.com/docs/workspaces_describe_connection_aliases/) for full documentation.
#'
#' @param AliasIds The identifiers of the connection aliases to describe.
#' @param ResourceId The identifier of the directory associated with the connection alias.
#' @param Limit The maximum number of connection aliases to return.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_connection_aliases
workspaces_describe_connection_aliases <- function(AliasIds = NULL, ResourceId = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeConnectionAliases",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_connection_aliases_input(AliasIds = AliasIds, ResourceId = ResourceId, Limit = Limit, NextToken = NextToken)
  output <- .workspaces$describe_connection_aliases_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_connection_aliases <- workspaces_describe_connection_aliases

#' Describes the associations between the applications and the specified
#' image
#'
#' @description
#' Describes the associations between the applications and the specified image.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_image_associations/](https://www.paws-r-sdk.com/docs/workspaces_describe_image_associations/) for full documentation.
#'
#' @param ImageId &#91;required&#93; The identifier of the image.
#' @param AssociatedResourceTypes &#91;required&#93; The resource types of the associated resource.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_image_associations
workspaces_describe_image_associations <- function(ImageId, AssociatedResourceTypes) {
  op <- new_operation(
    name = "DescribeImageAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_image_associations_input(ImageId = ImageId, AssociatedResourceTypes = AssociatedResourceTypes)
  output <- .workspaces$describe_image_associations_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_image_associations <- workspaces_describe_image_associations

#' Describes one or more of your IP access control groups
#'
#' @description
#' Describes one or more of your IP access control groups.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_ip_groups/](https://www.paws-r-sdk.com/docs/workspaces_describe_ip_groups/) for full documentation.
#'
#' @param GroupIds The identifiers of one or more IP access control groups.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#' @param MaxResults The maximum number of items to return.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_ip_groups
workspaces_describe_ip_groups <- function(GroupIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeIpGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_ip_groups_input(GroupIds = GroupIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workspaces$describe_ip_groups_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_ip_groups <- workspaces_describe_ip_groups

#' Describes the specified tags for the specified WorkSpaces resource
#'
#' @description
#' Describes the specified tags for the specified WorkSpaces resource.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_tags/](https://www.paws-r-sdk.com/docs/workspaces_describe_tags/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The identifier of the WorkSpaces resource. The supported resource types
#' are WorkSpaces, registered directories, images, custom bundles, IP
#' access control groups, and connection aliases.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_tags
workspaces_describe_tags <- function(ResourceId) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_tags_input(ResourceId = ResourceId)
  output <- .workspaces$describe_tags_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_tags <- workspaces_describe_tags

#' Describes the associations betweens applications and the specified
#' WorkSpace
#'
#' @description
#' Describes the associations betweens applications and the specified WorkSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_associations/](https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_associations/) for full documentation.
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#' @param AssociatedResourceTypes &#91;required&#93; The resource types of the associated resources.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspace_associations
workspaces_describe_workspace_associations <- function(WorkspaceId, AssociatedResourceTypes) {
  op <- new_operation(
    name = "DescribeWorkspaceAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspace_associations_input(WorkspaceId = WorkspaceId, AssociatedResourceTypes = AssociatedResourceTypes)
  output <- .workspaces$describe_workspace_associations_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspace_associations <- workspaces_describe_workspace_associations

#' Retrieves a list that describes the available WorkSpace bundles
#'
#' @description
#' Retrieves a list that describes the available WorkSpace bundles.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_bundles/](https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_bundles/) for full documentation.
#'
#' @param BundleIds The identifiers of the bundles. You cannot combine this parameter with
#' any other filter.
#' @param Owner The owner of the bundles. You cannot combine this parameter with any
#' other filter.
#' 
#' To describe the bundles provided by Amazon Web Services, specify
#' `AMAZON`. To describe the bundles that belong to your account, don't
#' specify a value.
#' @param NextToken The token for the next set of results. (You received this token from a
#' previous call.)
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspace_bundles
workspaces_describe_workspace_bundles <- function(BundleIds = NULL, Owner = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeWorkspaceBundles",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Bundles")
  )
  input <- .workspaces$describe_workspace_bundles_input(BundleIds = BundleIds, Owner = Owner, NextToken = NextToken)
  output <- .workspaces$describe_workspace_bundles_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspace_bundles <- workspaces_describe_workspace_bundles

#' Describes the available directories that are registered with Amazon
#' WorkSpaces
#'
#' @description
#' Describes the available directories that are registered with Amazon WorkSpaces.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_directories/](https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_directories/) for full documentation.
#'
#' @param DirectoryIds The identifiers of the directories. If the value is null, all
#' directories are retrieved.
#' @param Limit The maximum number of directories to return.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspace_directories
workspaces_describe_workspace_directories <- function(DirectoryIds = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeWorkspaceDirectories",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", output_token = "NextToken", result_key = "Directories")
  )
  input <- .workspaces$describe_workspace_directories_input(DirectoryIds = DirectoryIds, Limit = Limit, NextToken = NextToken)
  output <- .workspaces$describe_workspace_directories_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspace_directories <- workspaces_describe_workspace_directories

#' Describes the permissions that the owner of an image has granted to
#' other Amazon Web Services accounts for an image
#'
#' @description
#' Describes the permissions that the owner of an image has granted to other Amazon Web Services accounts for an image.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_image_permissions/](https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_image_permissions/) for full documentation.
#'
#' @param ImageId &#91;required&#93; The identifier of the image.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#' @param MaxResults The maximum number of items to return.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspace_image_permissions
workspaces_describe_workspace_image_permissions <- function(ImageId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeWorkspaceImagePermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspace_image_permissions_input(ImageId = ImageId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workspaces$describe_workspace_image_permissions_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspace_image_permissions <- workspaces_describe_workspace_image_permissions

#' Retrieves a list that describes one or more specified images, if the
#' image identifiers are provided
#'
#' @description
#' Retrieves a list that describes one or more specified images, if the image identifiers are provided. Otherwise, all images in the account are described.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_images/](https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_images/) for full documentation.
#'
#' @param ImageIds The identifier of the image.
#' @param ImageType The type (owned or shared) of the image.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#' @param MaxResults The maximum number of items to return.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspace_images
workspaces_describe_workspace_images <- function(ImageIds = NULL, ImageType = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeWorkspaceImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspace_images_input(ImageIds = ImageIds, ImageType = ImageType, NextToken = NextToken, MaxResults = MaxResults)
  output <- .workspaces$describe_workspace_images_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspace_images <- workspaces_describe_workspace_images

#' Describes the snapshots for the specified WorkSpace
#'
#' @description
#' Describes the snapshots for the specified WorkSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_snapshots/](https://www.paws-r-sdk.com/docs/workspaces_describe_workspace_snapshots/) for full documentation.
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspace_snapshots
workspaces_describe_workspace_snapshots <- function(WorkspaceId) {
  op <- new_operation(
    name = "DescribeWorkspaceSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspace_snapshots_input(WorkspaceId = WorkspaceId)
  output <- .workspaces$describe_workspace_snapshots_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspace_snapshots <- workspaces_describe_workspace_snapshots

#' Describes the specified WorkSpaces
#'
#' @description
#' Describes the specified WorkSpaces.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_workspaces/](https://www.paws-r-sdk.com/docs/workspaces_describe_workspaces/) for full documentation.
#'
#' @param WorkspaceIds The identifiers of the WorkSpaces. You cannot combine this parameter
#' with any other filter.
#' 
#' Because the [`create_workspaces`][workspaces_create_workspaces]
#' operation is asynchronous, the identifier it returns is not immediately
#' available. If you immediately call
#' [`describe_workspaces`][workspaces_describe_workspaces] with this
#' identifier, no information is returned.
#' @param DirectoryId The identifier of the directory. In addition, you can optionally specify
#' a specific directory user (see `UserName`). You cannot combine this
#' parameter with any other filter.
#' @param UserName The name of the directory user. You must specify this parameter with
#' `DirectoryId`.
#' @param BundleId The identifier of the bundle. All WorkSpaces that are created from this
#' bundle are retrieved. You cannot combine this parameter with any other
#' filter.
#' @param Limit The maximum number of items to return.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspaces
workspaces_describe_workspaces <- function(WorkspaceIds = NULL, DirectoryId = NULL, UserName = NULL, BundleId = NULL, Limit = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list(input_token = "NextToken", limit_key = "Limit", output_token = "NextToken", result_key = "Workspaces")
  )
  input <- .workspaces$describe_workspaces_input(WorkspaceIds = WorkspaceIds, DirectoryId = DirectoryId, UserName = UserName, BundleId = BundleId, Limit = Limit, NextToken = NextToken)
  output <- .workspaces$describe_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspaces <- workspaces_describe_workspaces

#' Describes the connection status of the specified WorkSpaces
#'
#' @description
#' Describes the connection status of the specified WorkSpaces.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_describe_workspaces_connection_status/](https://www.paws-r-sdk.com/docs/workspaces_describe_workspaces_connection_status/) for full documentation.
#'
#' @param WorkspaceIds The identifiers of the WorkSpaces. You can specify up to 25 WorkSpaces.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname workspaces_describe_workspaces_connection_status
workspaces_describe_workspaces_connection_status <- function(WorkspaceIds = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeWorkspacesConnectionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$describe_workspaces_connection_status_input(WorkspaceIds = WorkspaceIds, NextToken = NextToken)
  output <- .workspaces$describe_workspaces_connection_status_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$describe_workspaces_connection_status <- workspaces_describe_workspaces_connection_status

#' Disassociates a connection alias from a directory
#'
#' @description
#' Disassociates a connection alias from a directory. Disassociating a connection alias disables cross-Region redirection between two directories in different Regions. For more information, see [Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_disassociate_connection_alias/](https://www.paws-r-sdk.com/docs/workspaces_disassociate_connection_alias/) for full documentation.
#'
#' @param AliasId &#91;required&#93; The identifier of the connection alias to disassociate.
#'
#' @keywords internal
#'
#' @rdname workspaces_disassociate_connection_alias
workspaces_disassociate_connection_alias <- function(AliasId) {
  op <- new_operation(
    name = "DisassociateConnectionAlias",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$disassociate_connection_alias_input(AliasId = AliasId)
  output <- .workspaces$disassociate_connection_alias_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$disassociate_connection_alias <- workspaces_disassociate_connection_alias

#' Disassociates the specified IP access control group from the specified
#' directory
#'
#' @description
#' Disassociates the specified IP access control group from the specified directory.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_disassociate_ip_groups/](https://www.paws-r-sdk.com/docs/workspaces_disassociate_ip_groups/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory.
#' @param GroupIds &#91;required&#93; The identifiers of one or more IP access control groups.
#'
#' @keywords internal
#'
#' @rdname workspaces_disassociate_ip_groups
workspaces_disassociate_ip_groups <- function(DirectoryId, GroupIds) {
  op <- new_operation(
    name = "DisassociateIpGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$disassociate_ip_groups_input(DirectoryId = DirectoryId, GroupIds = GroupIds)
  output <- .workspaces$disassociate_ip_groups_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$disassociate_ip_groups <- workspaces_disassociate_ip_groups

#' Disassociates the specified application from a WorkSpace
#'
#' @description
#' Disassociates the specified application from a WorkSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_disassociate_workspace_application/](https://www.paws-r-sdk.com/docs/workspaces_disassociate_workspace_application/) for full documentation.
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#' @param ApplicationId &#91;required&#93; The identifier of the application.
#'
#' @keywords internal
#'
#' @rdname workspaces_disassociate_workspace_application
workspaces_disassociate_workspace_application <- function(WorkspaceId, ApplicationId) {
  op <- new_operation(
    name = "DisassociateWorkspaceApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$disassociate_workspace_application_input(WorkspaceId = WorkspaceId, ApplicationId = ApplicationId)
  output <- .workspaces$disassociate_workspace_application_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$disassociate_workspace_application <- workspaces_disassociate_workspace_application

#' Imports client branding
#'
#' @description
#' Imports client branding. Client branding allows you to customize your WorkSpace's client login portal. You can tailor your login portal company logo, the support email address, support link, link to reset password, and a custom message for users trying to sign in.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_import_client_branding/](https://www.paws-r-sdk.com/docs/workspaces_import_client_branding/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The directory identifier of the WorkSpace for which you want to import
#' client branding.
#' @param DeviceTypeWindows The branding information to import for Windows devices.
#' @param DeviceTypeOsx The branding information to import for macOS devices.
#' @param DeviceTypeAndroid The branding information to import for Android devices.
#' @param DeviceTypeIos The branding information to import for iOS devices.
#' @param DeviceTypeLinux The branding information to import for Linux devices.
#' @param DeviceTypeWeb The branding information to import for web access.
#'
#' @keywords internal
#'
#' @rdname workspaces_import_client_branding
workspaces_import_client_branding <- function(ResourceId, DeviceTypeWindows = NULL, DeviceTypeOsx = NULL, DeviceTypeAndroid = NULL, DeviceTypeIos = NULL, DeviceTypeLinux = NULL, DeviceTypeWeb = NULL) {
  op <- new_operation(
    name = "ImportClientBranding",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$import_client_branding_input(ResourceId = ResourceId, DeviceTypeWindows = DeviceTypeWindows, DeviceTypeOsx = DeviceTypeOsx, DeviceTypeAndroid = DeviceTypeAndroid, DeviceTypeIos = DeviceTypeIos, DeviceTypeLinux = DeviceTypeLinux, DeviceTypeWeb = DeviceTypeWeb)
  output <- .workspaces$import_client_branding_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$import_client_branding <- workspaces_import_client_branding

#' Imports the specified Windows 10 or 11 Bring Your Own License (BYOL)
#' image into Amazon WorkSpaces
#'
#' @description
#' Imports the specified Windows 10 or 11 Bring Your Own License (BYOL) image into Amazon WorkSpaces. The image must be an already licensed Amazon EC2 image that is in your Amazon Web Services account, and you must own the image. For more information about creating BYOL images, see [Bring Your Own Windows Desktop Licenses](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_import_workspace_image/](https://www.paws-r-sdk.com/docs/workspaces_import_workspace_image/) for full documentation.
#'
#' @param Ec2ImageId &#91;required&#93; The identifier of the EC2 image.
#' @param IngestionProcess &#91;required&#93; The ingestion process to be used when importing the image, depending on
#' which protocol you want to use for your BYOL Workspace image, either
#' PCoIP, WorkSpaces Streaming Protocol (WSP), or bring your own protocol
#' (BYOP). To use WSP, specify a value that ends in `_WSP`. To use PCoIP,
#' specify a value that does not end in `_WSP`. To use BYOP, specify a
#' value that ends in `_BYOP`.
#' 
#' For non-GPU-enabled bundles (bundles other than Graphics or
#' GraphicsPro), specify `BYOL_REGULAR`, `BYOL_REGULAR_WSP`, or
#' `BYOL_REGULAR_BYOP`, depending on the protocol.
#' 
#' The `BYOL_REGULAR_BYOP` and `BYOL_GRAPHICS_G4DN_BYOP` values are only
#' supported by Amazon WorkSpaces Core. Contact your account team to be
#' allow-listed to use these values. For more information, see [Amazon
#' WorkSpaces Core](https://aws.amazon.com/workspaces/core/).
#' @param ImageName &#91;required&#93; The name of the WorkSpace image.
#' @param ImageDescription &#91;required&#93; The description of the WorkSpace image.
#' @param Tags The tags. Each WorkSpaces resource can have a maximum of 50 tags.
#' @param Applications If specified, the version of Microsoft Office to subscribe to. Valid
#' only for Windows 10 and 11 BYOL images. For more information about
#' subscribing to Office for BYOL images, see [Bring Your Own Windows
#' Desktop
#' Licenses](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
#' 
#' -   Although this parameter is an array, only one item is allowed at
#'     this time.
#' 
#' -   Windows 11 only supports `Microsoft_Office_2019`.
#'
#' @keywords internal
#'
#' @rdname workspaces_import_workspace_image
workspaces_import_workspace_image <- function(Ec2ImageId, IngestionProcess, ImageName, ImageDescription, Tags = NULL, Applications = NULL) {
  op <- new_operation(
    name = "ImportWorkspaceImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$import_workspace_image_input(Ec2ImageId = Ec2ImageId, IngestionProcess = IngestionProcess, ImageName = ImageName, ImageDescription = ImageDescription, Tags = Tags, Applications = Applications)
  output <- .workspaces$import_workspace_image_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$import_workspace_image <- workspaces_import_workspace_image

#' Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks,
#' that you can use for the network management interface when you enable
#' Bring Your Own License (BYOL)
#'
#' @description
#' Retrieves a list of IP address ranges, specified as IPv4 CIDR blocks, that you can use for the network management interface when you enable Bring Your Own License (BYOL).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_list_available_management_cidr_ranges/](https://www.paws-r-sdk.com/docs/workspaces_list_available_management_cidr_ranges/) for full documentation.
#'
#' @param ManagementCidrRangeConstraint &#91;required&#93; The IP address range to search. Specify an IP address range that is
#' compatible with your network and in CIDR notation (that is, specify the
#' range as an IPv4 CIDR block).
#' @param MaxResults The maximum number of items to return.
#' @param NextToken If you received a `NextToken` from a previous call that was paginated,
#' provide this token to receive the next set of results.
#'
#' @keywords internal
#'
#' @rdname workspaces_list_available_management_cidr_ranges
workspaces_list_available_management_cidr_ranges <- function(ManagementCidrRangeConstraint, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListAvailableManagementCidrRanges",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$list_available_management_cidr_ranges_input(ManagementCidrRangeConstraint = ManagementCidrRangeConstraint, MaxResults = MaxResults, NextToken = NextToken)
  output <- .workspaces$list_available_management_cidr_ranges_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$list_available_management_cidr_ranges <- workspaces_list_available_management_cidr_ranges

#' Migrates a WorkSpace from one operating system or bundle type to
#' another, while retaining the data on the user volume
#'
#' @description
#' Migrates a WorkSpace from one operating system or bundle type to another, while retaining the data on the user volume.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_migrate_workspace/](https://www.paws-r-sdk.com/docs/workspaces_migrate_workspace/) for full documentation.
#'
#' @param SourceWorkspaceId &#91;required&#93; The identifier of the WorkSpace to migrate from.
#' @param BundleId &#91;required&#93; The identifier of the target bundle type to migrate the WorkSpace to.
#'
#' @keywords internal
#'
#' @rdname workspaces_migrate_workspace
workspaces_migrate_workspace <- function(SourceWorkspaceId, BundleId) {
  op <- new_operation(
    name = "MigrateWorkspace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$migrate_workspace_input(SourceWorkspaceId = SourceWorkspaceId, BundleId = BundleId)
  output <- .workspaces$migrate_workspace_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$migrate_workspace <- workspaces_migrate_workspace

#' Modifies the configuration of Bring Your Own License (BYOL) for the
#' specified account
#'
#' @description
#' Modifies the configuration of Bring Your Own License (BYOL) for the specified account.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_modify_account/](https://www.paws-r-sdk.com/docs/workspaces_modify_account/) for full documentation.
#'
#' @param DedicatedTenancySupport The status of BYOL.
#' @param DedicatedTenancyManagementCidrRange The IP address range, specified as an IPv4 CIDR block, for the
#' management network interface. Specify an IP address range that is
#' compatible with your network and in CIDR notation (that is, specify the
#' range as an IPv4 CIDR block). The CIDR block size must be /16 (for
#' example, 203.0.113.25/16). It must also be specified as available by the
#' [`list_available_management_cidr_ranges`][workspaces_list_available_management_cidr_ranges]
#' operation.
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_account
workspaces_modify_account <- function(DedicatedTenancySupport = NULL, DedicatedTenancyManagementCidrRange = NULL) {
  op <- new_operation(
    name = "ModifyAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_account_input(DedicatedTenancySupport = DedicatedTenancySupport, DedicatedTenancyManagementCidrRange = DedicatedTenancyManagementCidrRange)
  output <- .workspaces$modify_account_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_account <- workspaces_modify_account

#' Modifies the properties of the certificate-based authentication you want
#' to use with your WorkSpaces
#'
#' @description
#' Modifies the properties of the certificate-based authentication you want to use with your WorkSpaces.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_modify_certificate_based_auth_properties/](https://www.paws-r-sdk.com/docs/workspaces_modify_certificate_based_auth_properties/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The resource identifiers, in the form of directory IDs.
#' @param CertificateBasedAuthProperties The properties of the certificate-based authentication.
#' @param PropertiesToDelete The properties of the certificate-based authentication you want to
#' delete.
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_certificate_based_auth_properties
workspaces_modify_certificate_based_auth_properties <- function(ResourceId, CertificateBasedAuthProperties = NULL, PropertiesToDelete = NULL) {
  op <- new_operation(
    name = "ModifyCertificateBasedAuthProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_certificate_based_auth_properties_input(ResourceId = ResourceId, CertificateBasedAuthProperties = CertificateBasedAuthProperties, PropertiesToDelete = PropertiesToDelete)
  output <- .workspaces$modify_certificate_based_auth_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_certificate_based_auth_properties <- workspaces_modify_certificate_based_auth_properties

#' Modifies the properties of the specified Amazon WorkSpaces clients
#'
#' @description
#' Modifies the properties of the specified Amazon WorkSpaces clients.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_modify_client_properties/](https://www.paws-r-sdk.com/docs/workspaces_modify_client_properties/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The resource identifiers, in the form of directory IDs.
#' @param ClientProperties &#91;required&#93; Information about the Amazon WorkSpaces client.
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_client_properties
workspaces_modify_client_properties <- function(ResourceId, ClientProperties) {
  op <- new_operation(
    name = "ModifyClientProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_client_properties_input(ResourceId = ResourceId, ClientProperties = ClientProperties)
  output <- .workspaces$modify_client_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_client_properties <- workspaces_modify_client_properties

#' Modifies multiple properties related to SAML 2
#'
#' @description
#' Modifies multiple properties related to SAML 2.0 authentication, including the enablement status, user access URL, and relay state parameter name that are used for configuring federation with an SAML 2.0 identity provider.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_modify_saml_properties/](https://www.paws-r-sdk.com/docs/workspaces_modify_saml_properties/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The directory identifier for which you want to configure SAML
#' properties.
#' @param SamlProperties The properties for configuring SAML 2.0 authentication.
#' @param PropertiesToDelete The SAML properties to delete as part of your request.
#' 
#' Specify one of the following options:
#' 
#' -   `SAML_PROPERTIES_USER_ACCESS_URL` to delete the user access URL.
#' 
#' -   `SAML_PROPERTIES_RELAY_STATE_PARAMETER_NAME` to delete the relay
#'     state parameter name.
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_saml_properties
workspaces_modify_saml_properties <- function(ResourceId, SamlProperties = NULL, PropertiesToDelete = NULL) {
  op <- new_operation(
    name = "ModifySamlProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_saml_properties_input(ResourceId = ResourceId, SamlProperties = SamlProperties, PropertiesToDelete = PropertiesToDelete)
  output <- .workspaces$modify_saml_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_saml_properties <- workspaces_modify_saml_properties

#' Modifies the self-service WorkSpace management capabilities for your
#' users
#'
#' @description
#' Modifies the self-service WorkSpace management capabilities for your users. For more information, see [Enable Self-Service WorkSpace Management Capabilities for Your Users](https://docs.aws.amazon.com/workspaces/latest/adminguide/enable-user-self-service-workspace-management.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_modify_selfservice_permissions/](https://www.paws-r-sdk.com/docs/workspaces_modify_selfservice_permissions/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The identifier of the directory.
#' @param SelfservicePermissions &#91;required&#93; The permissions to enable or disable self-service capabilities.
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_selfservice_permissions
workspaces_modify_selfservice_permissions <- function(ResourceId, SelfservicePermissions) {
  op <- new_operation(
    name = "ModifySelfservicePermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_selfservice_permissions_input(ResourceId = ResourceId, SelfservicePermissions = SelfservicePermissions)
  output <- .workspaces$modify_selfservice_permissions_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_selfservice_permissions <- workspaces_modify_selfservice_permissions

#' Specifies which devices and operating systems users can use to access
#' their WorkSpaces
#'
#' @description
#' Specifies which devices and operating systems users can use to access their WorkSpaces. For more information, see [Control Device Access](https://docs.aws.amazon.com/workspaces/latest/adminguide/update-directory-details.html#control-device-access).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_modify_workspace_access_properties/](https://www.paws-r-sdk.com/docs/workspaces_modify_workspace_access_properties/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The identifier of the directory.
#' @param WorkspaceAccessProperties &#91;required&#93; The device types and operating systems to enable or disable for access.
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_workspace_access_properties
workspaces_modify_workspace_access_properties <- function(ResourceId, WorkspaceAccessProperties) {
  op <- new_operation(
    name = "ModifyWorkspaceAccessProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_workspace_access_properties_input(ResourceId = ResourceId, WorkspaceAccessProperties = WorkspaceAccessProperties)
  output <- .workspaces$modify_workspace_access_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_workspace_access_properties <- workspaces_modify_workspace_access_properties

#' Modify the default properties used to create WorkSpaces
#'
#' @description
#' Modify the default properties used to create WorkSpaces.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_modify_workspace_creation_properties/](https://www.paws-r-sdk.com/docs/workspaces_modify_workspace_creation_properties/) for full documentation.
#'
#' @param ResourceId &#91;required&#93; The identifier of the directory.
#' @param WorkspaceCreationProperties &#91;required&#93; The default properties for creating WorkSpaces.
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_workspace_creation_properties
workspaces_modify_workspace_creation_properties <- function(ResourceId, WorkspaceCreationProperties) {
  op <- new_operation(
    name = "ModifyWorkspaceCreationProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_workspace_creation_properties_input(ResourceId = ResourceId, WorkspaceCreationProperties = WorkspaceCreationProperties)
  output <- .workspaces$modify_workspace_creation_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_workspace_creation_properties <- workspaces_modify_workspace_creation_properties

#' Modifies the specified WorkSpace properties
#'
#' @description
#' Modifies the specified WorkSpace properties. For important information about how to modify the size of the root and user volumes, see [Modify a WorkSpace](https://docs.aws.amazon.com/workspaces/latest/adminguide/modify-workspaces.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_modify_workspace_properties/](https://www.paws-r-sdk.com/docs/workspaces_modify_workspace_properties/) for full documentation.
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#' @param WorkspaceProperties The properties of the WorkSpace.
#' @param DataReplication Indicates the data replication status.
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_workspace_properties
workspaces_modify_workspace_properties <- function(WorkspaceId, WorkspaceProperties = NULL, DataReplication = NULL) {
  op <- new_operation(
    name = "ModifyWorkspaceProperties",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_workspace_properties_input(WorkspaceId = WorkspaceId, WorkspaceProperties = WorkspaceProperties, DataReplication = DataReplication)
  output <- .workspaces$modify_workspace_properties_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_workspace_properties <- workspaces_modify_workspace_properties

#' Sets the state of the specified WorkSpace
#'
#' @description
#' Sets the state of the specified WorkSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_modify_workspace_state/](https://www.paws-r-sdk.com/docs/workspaces_modify_workspace_state/) for full documentation.
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#' @param WorkspaceState &#91;required&#93; The WorkSpace state.
#'
#' @keywords internal
#'
#' @rdname workspaces_modify_workspace_state
workspaces_modify_workspace_state <- function(WorkspaceId, WorkspaceState) {
  op <- new_operation(
    name = "ModifyWorkspaceState",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$modify_workspace_state_input(WorkspaceId = WorkspaceId, WorkspaceState = WorkspaceState)
  output <- .workspaces$modify_workspace_state_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$modify_workspace_state <- workspaces_modify_workspace_state

#' Reboots the specified WorkSpaces
#'
#' @description
#' Reboots the specified WorkSpaces.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_reboot_workspaces/](https://www.paws-r-sdk.com/docs/workspaces_reboot_workspaces/) for full documentation.
#'
#' @param RebootWorkspaceRequests &#91;required&#93; The WorkSpaces to reboot. You can specify up to 25 WorkSpaces.
#'
#' @keywords internal
#'
#' @rdname workspaces_reboot_workspaces
workspaces_reboot_workspaces <- function(RebootWorkspaceRequests) {
  op <- new_operation(
    name = "RebootWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$reboot_workspaces_input(RebootWorkspaceRequests = RebootWorkspaceRequests)
  output <- .workspaces$reboot_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$reboot_workspaces <- workspaces_reboot_workspaces

#' Rebuilds the specified WorkSpace
#'
#' @description
#' Rebuilds the specified WorkSpace.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_rebuild_workspaces/](https://www.paws-r-sdk.com/docs/workspaces_rebuild_workspaces/) for full documentation.
#'
#' @param RebuildWorkspaceRequests &#91;required&#93; The WorkSpace to rebuild. You can specify a single WorkSpace.
#'
#' @keywords internal
#'
#' @rdname workspaces_rebuild_workspaces
workspaces_rebuild_workspaces <- function(RebuildWorkspaceRequests) {
  op <- new_operation(
    name = "RebuildWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$rebuild_workspaces_input(RebuildWorkspaceRequests = RebuildWorkspaceRequests)
  output <- .workspaces$rebuild_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$rebuild_workspaces <- workspaces_rebuild_workspaces

#' Registers the specified directory
#'
#' @description
#' Registers the specified directory. This operation is asynchronous and returns before the WorkSpace directory is registered. If this is the first time you are registering a directory, you will need to create the workspaces_DefaultRole role before you can register a directory. For more information, see [Creating the workspaces_DefaultRole Role](https://docs.aws.amazon.com/workspaces/latest/adminguide/workspaces-access-control.html#create-default-role).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_register_workspace_directory/](https://www.paws-r-sdk.com/docs/workspaces_register_workspace_directory/) for full documentation.
#'
#' @param DirectoryId &#91;required&#93; The identifier of the directory. You cannot register a directory if it
#' does not have a status of Active. If the directory does not have a
#' status of Active, you will receive an InvalidResourceStateException
#' error. If you have already registered the maximum number of directories
#' that you can register with Amazon WorkSpaces, you will receive a
#' ResourceLimitExceededException error. Deregister directories that you
#' are not using for WorkSpaces, and try again.
#' @param SubnetIds The identifiers of the subnets for your virtual private cloud (VPC).
#' Make sure that the subnets are in supported Availability Zones. The
#' subnets must also be in separate Availability Zones. If these conditions
#' are not met, you will receive an OperationNotSupportedException error.
#' @param EnableWorkDocs &#91;required&#93; Indicates whether Amazon WorkDocs is enabled or disabled. If you have
#' enabled this parameter and WorkDocs is not available in the Region, you
#' will receive an OperationNotSupportedException error. Set
#' `EnableWorkDocs` to disabled, and try again.
#' @param EnableSelfService Indicates whether self-service capabilities are enabled or disabled.
#' @param Tenancy Indicates whether your WorkSpace directory is dedicated or shared. To
#' use Bring Your Own License (BYOL) images, this value must be set to
#' `DEDICATED` and your Amazon Web Services account must be enabled for
#' BYOL. If your account has not been enabled for BYOL, you will receive an
#' InvalidParameterValuesException error. For more information about BYOL
#' images, see [Bring Your Own Windows Desktop
#' Images](https://docs.aws.amazon.com/workspaces/latest/adminguide/byol-windows-images.html).
#' @param Tags The tags associated with the directory.
#'
#' @keywords internal
#'
#' @rdname workspaces_register_workspace_directory
workspaces_register_workspace_directory <- function(DirectoryId, SubnetIds = NULL, EnableWorkDocs, EnableSelfService = NULL, Tenancy = NULL, Tags = NULL) {
  op <- new_operation(
    name = "RegisterWorkspaceDirectory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$register_workspace_directory_input(DirectoryId = DirectoryId, SubnetIds = SubnetIds, EnableWorkDocs = EnableWorkDocs, EnableSelfService = EnableSelfService, Tenancy = Tenancy, Tags = Tags)
  output <- .workspaces$register_workspace_directory_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$register_workspace_directory <- workspaces_register_workspace_directory

#' Restores the specified WorkSpace to its last known healthy state
#'
#' @description
#' Restores the specified WorkSpace to its last known healthy state.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_restore_workspace/](https://www.paws-r-sdk.com/docs/workspaces_restore_workspace/) for full documentation.
#'
#' @param WorkspaceId &#91;required&#93; The identifier of the WorkSpace.
#'
#' @keywords internal
#'
#' @rdname workspaces_restore_workspace
workspaces_restore_workspace <- function(WorkspaceId) {
  op <- new_operation(
    name = "RestoreWorkspace",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$restore_workspace_input(WorkspaceId = WorkspaceId)
  output <- .workspaces$restore_workspace_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$restore_workspace <- workspaces_restore_workspace

#' Removes one or more rules from the specified IP access control group
#'
#' @description
#' Removes one or more rules from the specified IP access control group.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_revoke_ip_rules/](https://www.paws-r-sdk.com/docs/workspaces_revoke_ip_rules/) for full documentation.
#'
#' @param GroupId &#91;required&#93; The identifier of the group.
#' @param UserRules &#91;required&#93; The rules to remove from the group.
#'
#' @keywords internal
#'
#' @rdname workspaces_revoke_ip_rules
workspaces_revoke_ip_rules <- function(GroupId, UserRules) {
  op <- new_operation(
    name = "RevokeIpRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$revoke_ip_rules_input(GroupId = GroupId, UserRules = UserRules)
  output <- .workspaces$revoke_ip_rules_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$revoke_ip_rules <- workspaces_revoke_ip_rules

#' Starts the specified WorkSpaces
#'
#' @description
#' Starts the specified WorkSpaces.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_start_workspaces/](https://www.paws-r-sdk.com/docs/workspaces_start_workspaces/) for full documentation.
#'
#' @param StartWorkspaceRequests &#91;required&#93; The WorkSpaces to start. You can specify up to 25 WorkSpaces.
#'
#' @keywords internal
#'
#' @rdname workspaces_start_workspaces
workspaces_start_workspaces <- function(StartWorkspaceRequests) {
  op <- new_operation(
    name = "StartWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$start_workspaces_input(StartWorkspaceRequests = StartWorkspaceRequests)
  output <- .workspaces$start_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$start_workspaces <- workspaces_start_workspaces

#' Stops the specified WorkSpaces
#'
#' @description
#' Stops the specified WorkSpaces.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_stop_workspaces/](https://www.paws-r-sdk.com/docs/workspaces_stop_workspaces/) for full documentation.
#'
#' @param StopWorkspaceRequests &#91;required&#93; The WorkSpaces to stop. You can specify up to 25 WorkSpaces.
#'
#' @keywords internal
#'
#' @rdname workspaces_stop_workspaces
workspaces_stop_workspaces <- function(StopWorkspaceRequests) {
  op <- new_operation(
    name = "StopWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$stop_workspaces_input(StopWorkspaceRequests = StopWorkspaceRequests)
  output <- .workspaces$stop_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$stop_workspaces <- workspaces_stop_workspaces

#' Terminates the specified WorkSpaces
#'
#' @description
#' Terminates the specified WorkSpaces.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_terminate_workspaces/](https://www.paws-r-sdk.com/docs/workspaces_terminate_workspaces/) for full documentation.
#'
#' @param TerminateWorkspaceRequests &#91;required&#93; The WorkSpaces to terminate. You can specify up to 25 WorkSpaces.
#'
#' @keywords internal
#'
#' @rdname workspaces_terminate_workspaces
workspaces_terminate_workspaces <- function(TerminateWorkspaceRequests) {
  op <- new_operation(
    name = "TerminateWorkspaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$terminate_workspaces_input(TerminateWorkspaceRequests = TerminateWorkspaceRequests)
  output <- .workspaces$terminate_workspaces_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$terminate_workspaces <- workspaces_terminate_workspaces

#' Updates a Amazon Connect client add-in
#'
#' @description
#' Updates a Amazon Connect client add-in. Use this action to update the name and endpoint URL of a Amazon Connect client add-in.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_update_connect_client_add_in/](https://www.paws-r-sdk.com/docs/workspaces_update_connect_client_add_in/) for full documentation.
#'
#' @param AddInId &#91;required&#93; The identifier of the client add-in to update.
#' @param ResourceId &#91;required&#93; The directory identifier for which the client add-in is configured.
#' @param Name The name of the client add-in.
#' @param URL The endpoint URL of the Amazon Connect client add-in.
#'
#' @keywords internal
#'
#' @rdname workspaces_update_connect_client_add_in
workspaces_update_connect_client_add_in <- function(AddInId, ResourceId, Name = NULL, URL = NULL) {
  op <- new_operation(
    name = "UpdateConnectClientAddIn",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$update_connect_client_add_in_input(AddInId = AddInId, ResourceId = ResourceId, Name = Name, URL = URL)
  output <- .workspaces$update_connect_client_add_in_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$update_connect_client_add_in <- workspaces_update_connect_client_add_in

#' Shares or unshares a connection alias with one account by specifying
#' whether that account has permission to associate the connection alias
#' with a directory
#'
#' @description
#' Shares or unshares a connection alias with one account by specifying whether that account has permission to associate the connection alias with a directory. If the association permission is granted, the connection alias is shared with that account. If the association permission is revoked, the connection alias is unshared with the account. For more information, see [Cross-Region Redirection for Amazon WorkSpaces](https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_update_connection_alias_permission/](https://www.paws-r-sdk.com/docs/workspaces_update_connection_alias_permission/) for full documentation.
#'
#' @param AliasId &#91;required&#93; The identifier of the connection alias that you want to update
#' permissions for.
#' @param ConnectionAliasPermission &#91;required&#93; Indicates whether to share or unshare the connection alias with the
#' specified Amazon Web Services account.
#'
#' @keywords internal
#'
#' @rdname workspaces_update_connection_alias_permission
workspaces_update_connection_alias_permission <- function(AliasId, ConnectionAliasPermission) {
  op <- new_operation(
    name = "UpdateConnectionAliasPermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$update_connection_alias_permission_input(AliasId = AliasId, ConnectionAliasPermission = ConnectionAliasPermission)
  output <- .workspaces$update_connection_alias_permission_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$update_connection_alias_permission <- workspaces_update_connection_alias_permission

#' Replaces the current rules of the specified IP access control group with
#' the specified rules
#'
#' @description
#' Replaces the current rules of the specified IP access control group with the specified rules.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_update_rules_of_ip_group/](https://www.paws-r-sdk.com/docs/workspaces_update_rules_of_ip_group/) for full documentation.
#'
#' @param GroupId &#91;required&#93; The identifier of the group.
#' @param UserRules &#91;required&#93; One or more rules.
#'
#' @keywords internal
#'
#' @rdname workspaces_update_rules_of_ip_group
workspaces_update_rules_of_ip_group <- function(GroupId, UserRules) {
  op <- new_operation(
    name = "UpdateRulesOfIpGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$update_rules_of_ip_group_input(GroupId = GroupId, UserRules = UserRules)
  output <- .workspaces$update_rules_of_ip_group_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$update_rules_of_ip_group <- workspaces_update_rules_of_ip_group

#' Updates a WorkSpace bundle with a new image
#'
#' @description
#' Updates a WorkSpace bundle with a new image. For more information about updating WorkSpace bundles, see [Update a Custom WorkSpaces Bundle](https://docs.aws.amazon.com/workspaces/latest/adminguide/update-custom-bundle.html).
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_update_workspace_bundle/](https://www.paws-r-sdk.com/docs/workspaces_update_workspace_bundle/) for full documentation.
#'
#' @param BundleId The identifier of the bundle.
#' @param ImageId The identifier of the image.
#'
#' @keywords internal
#'
#' @rdname workspaces_update_workspace_bundle
workspaces_update_workspace_bundle <- function(BundleId = NULL, ImageId = NULL) {
  op <- new_operation(
    name = "UpdateWorkspaceBundle",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$update_workspace_bundle_input(BundleId = BundleId, ImageId = ImageId)
  output <- .workspaces$update_workspace_bundle_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$update_workspace_bundle <- workspaces_update_workspace_bundle

#' Shares or unshares an image with one account in the same Amazon Web
#' Services Region by specifying whether that account has permission to
#' copy the image
#'
#' @description
#' Shares or unshares an image with one account in the same Amazon Web Services Region by specifying whether that account has permission to copy the image. If the copy image permission is granted, the image is shared with that account. If the copy image permission is revoked, the image is unshared with the account.
#'
#' See [https://www.paws-r-sdk.com/docs/workspaces_update_workspace_image_permission/](https://www.paws-r-sdk.com/docs/workspaces_update_workspace_image_permission/) for full documentation.
#'
#' @param ImageId &#91;required&#93; The identifier of the image.
#' @param AllowCopyImage &#91;required&#93; The permission to copy the image. This permission can be revoked only
#' after an image has been shared.
#' @param SharedAccountId &#91;required&#93; The identifier of the Amazon Web Services account to share or unshare
#' the image with.
#' 
#' Before sharing the image, confirm that you are sharing to the correct
#' Amazon Web Services account ID.
#'
#' @keywords internal
#'
#' @rdname workspaces_update_workspace_image_permission
workspaces_update_workspace_image_permission <- function(ImageId, AllowCopyImage, SharedAccountId) {
  op <- new_operation(
    name = "UpdateWorkspaceImagePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .workspaces$update_workspace_image_permission_input(ImageId = ImageId, AllowCopyImage = AllowCopyImage, SharedAccountId = SharedAccountId)
  output <- .workspaces$update_workspace_image_permission_output()
  config <- get_config()
  svc <- .workspaces$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.workspaces$operations$update_workspace_image_permission <- workspaces_update_workspace_image_permission
