% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspacesweb_operations.R
\name{workspacesweb_create_trust_store}
\alias{workspacesweb_create_trust_store}
\title{Creates a trust store that can be associated with a web portal}
\usage{
workspacesweb_create_trust_store(
  certificateList,
  clientToken = NULL,
  tags = NULL
)
}
\arguments{
\item{certificateList}{[required] A list of CA certificates to be added to the trust store.}

\item{clientToken}{A unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Idempotency ensures that an API request
completes only once. With an idempotent request, if the original request
completes successfully, subsequent retries with the same client token
returns the result from the original successful request.

If you do not specify a client token, one is automatically generated by
the AWS SDK.}

\item{tags}{The tags to add to the trust store. A tag is a key-value pair.}
}
\description{
Creates a trust store that can be associated with a web portal. A trust store contains certificate authority (CA) certificates. Once associated with a web portal, the browser in a streaming session will recognize certificates that have been issued using any of the CAs in the trust store. If your organization has internal websites that use certificates issued by private CAs, you should add the private CA certificate to the trust store.

See \url{https://paws-r.github.io/docs/workspacesweb/create_trust_store.html} for full documentation.
}
\keyword{internal}
