% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/appstream_operations.R
\name{appstream_create_streaming_url}
\alias{appstream_create_streaming_url}
\title{Creates a temporary URL to start an AppStream 2}
\usage{
appstream_create_streaming_url(
  StackName,
  FleetName,
  UserId,
  ApplicationId = NULL,
  Validity = NULL,
  SessionContext = NULL
)
}
\arguments{
\item{StackName}{[required] The name of the stack.}

\item{FleetName}{[required] The name of the fleet.}

\item{UserId}{[required] The identifier of the user.}

\item{ApplicationId}{The name of the application to launch after the session starts. This is
the name that you specified as \strong{Name} in the Image Assistant. If your
fleet is enabled for the \strong{Desktop} stream view, you can also choose to
launch directly to the operating system desktop. To do so, specify
\strong{Desktop}.}

\item{Validity}{The time that the streaming URL will be valid, in seconds. Specify a
value between 1 and 604800 seconds. The default is 60 seconds.}

\item{SessionContext}{The session context. For more information, see \href{https://docs.aws.amazon.com/appstream2/latest/developerguide/managing-stacks-fleets.html#managing-stacks-fleets-parameters}{Session Context}
in the \emph{Amazon AppStream 2.0 Administration Guide}.}
}
\description{
Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL enables application streaming to be tested without user setup.

See \url{https://paws-r.github.io/docs/appstream/create_streaming_url.html} for full documentation.
}
\keyword{internal}
