% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/workspaces_operations.R
\name{workspaces_describe_connection_aliases}
\alias{workspaces_describe_connection_aliases}
\title{Retrieves a list that describes the connection aliases used for
cross-Region redirection}
\usage{
workspaces_describe_connection_aliases(AliasIds, ResourceId, Limit,
  NextToken)
}
\arguments{
\item{AliasIds}{The identifiers of the connection aliases to describe.}

\item{ResourceId}{The identifier of the directory associated with the connection alias.}

\item{Limit}{The maximum number of connection aliases to return.}

\item{NextToken}{If you received a \code{NextToken} from a previous call that was paginated,
provide this token to receive the next set of results.}
}
\value{
A list with the following syntax:\preformatted{list(
  ConnectionAliases = list(
    list(
      ConnectionString = "string",
      AliasId = "string",
      State = "CREATING"|"CREATED"|"DELETING",
      OwnerAccountId = "string",
      Associations = list(
        list(
          AssociationStatus = "NOT_ASSOCIATED"|"ASSOCIATED_WITH_OWNER_ACCOUNT"|"ASSOCIATED_WITH_SHARED_ACCOUNT"|"PENDING_ASSOCIATION"|"PENDING_DISASSOCIATION",
          AssociatedAccountId = "string",
          ResourceId = "string",
          ConnectionIdentifier = "string"
        )
      )
    )
  ),
  NextToken = "string"
)
}
}
\description{
Retrieves a list that describes the connection aliases used for
cross-Region redirection. For more information, see \href{https://docs.aws.amazon.com/workspaces/latest/adminguide/cross-region-redirection.html}{Cross-Region Redirection for Amazon WorkSpaces}.
}
\section{Request syntax}{
\preformatted{svc$describe_connection_aliases(
  AliasIds = list(
    "string"
  ),
  ResourceId = "string",
  Limit = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
